/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.bean;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.ee.Creator;
import org.wildfly.clustering.ee.MutatorFactory;
import org.wildfly.clustering.ee.Remover;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.infinispan.InfinispanConfiguration;
import org.wildfly.clustering.ejb.DeploymentConfiguration;
import org.wildfly.clustering.ejb.bean.BeanInstance;
import org.wildfly.clustering.ejb.cache.bean.BeanGroupManager;
import org.wildfly.clustering.ejb.cache.bean.BeanGroupManagerServiceNameProvider;
import org.wildfly.clustering.ejb.cache.bean.DefaultBeanGroupManager;
import org.wildfly.clustering.ejb.cache.bean.DefaultBeanGroupManagerConfiguration;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanGroupManager;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshalledValueFactory;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.spi.MarshalledValue;
import org.wildfly.clustering.marshalling.spi.MarshalledValueFactory;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.SupplierDependency;

public class InfinispanBeanGroupManagerServiceConfigurator<K, V extends BeanInstance<K>>
extends BeanGroupManagerServiceNameProvider
implements CapabilityServiceConfigurator,
Supplier<BeanGroupManager<K, V>>,
InfinispanConfiguration {
    private final SupplierDependency<Cache<?, ?>> cache;
    private final SupplierDependency<ByteBufferMarshaller> marshaller;

    public InfinispanBeanGroupManagerServiceConfigurator(DeploymentConfiguration config, SupplierDependency<Cache<?, ?>> cache, SupplierDependency<ByteBufferMarshaller> marshaller) {
        super(config);
        this.cache = cache;
        this.marshaller = marshaller;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceName name = this.getServiceName();
        ServiceBuilder builder = target.addService(name);
        Consumer manager = new CompositeDependency(new Dependency[]{this.marshaller, this.cache}).register(builder).provides(new ServiceName[]{name});
        return builder.setInstance((Service)new FunctionalService(manager, Function.identity(), (Supplier)this));
    }

    @Override
    public BeanGroupManager<K, V> get() {
        final CacheProperties properties = this.getCacheProperties();
        final InfinispanBeanGroupManager factory = new InfinispanBeanGroupManager(this);
        ByteBufferMarshalledValueFactory marshalledValueFactory = new ByteBufferMarshalledValueFactory((ByteBufferMarshaller)this.marshaller.get());
        return new DefaultBeanGroupManager(new DefaultBeanGroupManagerConfiguration<K, V, ByteBufferMarshaller>((MarshalledValueFactory)marshalledValueFactory){
            final /* synthetic */ MarshalledValueFactory val$marshalledValueFactory;
            {
                this.val$marshalledValueFactory = marshalledValueFactory;
            }

            public Creator<K, MarshalledValue<Map<K, V>, ByteBufferMarshaller>, MarshalledValue<Map<K, V>, ByteBufferMarshaller>> getCreator() {
                return factory;
            }

            public Remover<K> getRemover() {
                return factory;
            }

            public MutatorFactory<K, MarshalledValue<Map<K, V>, ByteBufferMarshaller>> getMutatorFactory() {
                return factory;
            }

            public CacheProperties getCacheProperties() {
                return properties;
            }

            public MarshalledValueFactory<ByteBufferMarshaller> getMarshalledValueFactory() {
                return this.val$marshalledValueFactory;
            }
        });
    }

    public <KK, VV> Cache<KK, VV> getCache() {
        return (Cache)this.cache.get();
    }
}

