/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.BatchFetchQueue;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.loader.ast.internal.AbstractEntityBatchLoader;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.MultiKeyLoadChunker;
import org.hibernate.loader.ast.internal.MultiKeyLoadHelper;
import org.hibernate.loader.ast.internal.MultiKeyLoadLogging;
import org.hibernate.loader.ast.internal.Preparable;
import org.hibernate.loader.ast.internal.SingleIdExecutionContext;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.loader.ast.spi.SqlInPredicateMultiKeyLoader;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.internal.RowTransformerStandardImpl;
import org.hibernate.sql.results.spi.ListResultsConsumer;

public class EntityBatchLoaderInPredicate<T>
extends AbstractEntityBatchLoader<T>
implements SqlInPredicateMultiKeyLoader,
Preparable {
    private final int domainBatchSize;
    private final int sqlBatchSize;
    private JdbcParametersList jdbcParameters;
    private SelectStatement sqlAst;
    private JdbcOperationQuerySelect jdbcSelectOperation;

    public EntityBatchLoaderInPredicate(int domainBatchSize, int sqlBatchSize, EntityMappingType entityDescriptor, SessionFactoryImplementor sessionFactory) {
        super(entityDescriptor, sessionFactory);
        this.domainBatchSize = domainBatchSize;
        this.sqlBatchSize = sqlBatchSize;
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isDebugEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.debugf("Batch fetching `%s` entity using padded IN-list : %s (%s)", (Object)entityDescriptor.getEntityName(), (Object)domainBatchSize, (Object)sqlBatchSize);
        }
    }

    @Override
    public int getDomainBatchSize() {
        return this.domainBatchSize;
    }

    public int getSqlBatchSize() {
        return this.sqlBatchSize;
    }

    @Override
    public final T load(Object pkValue, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        return this.load(pkValue, null, lockOptions, readOnly, session);
    }

    @Override
    public final T load(Object pkValue, Object entityInstance, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        Object[] idsToInitialize;
        boolean loggerDebugEnabled = MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isDebugEnabled();
        if (loggerDebugEnabled) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.debugf("Batch loading entity `%s#%s`", (Object)this.getLoadable().getEntityName(), pkValue);
        }
        if (MultiKeyLoadHelper.hasSingleId(idsToInitialize = this.resolveIdsToLoad(pkValue, session)) || lockOptions.getLockMode() != LockMode.NONE) {
            return this.singleIdLoader.load(pkValue, entityInstance, lockOptions, readOnly, session);
        }
        if (loggerDebugEnabled) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.debugf("Ids to batch-fetch initialize (`%s#%s`) %s", (Object)this.getLoadable().getEntityName(), pkValue, (Object)Arrays.toString(idsToInitialize));
        }
        this.initializeEntities(idsToInitialize, pkValue, entityInstance, lockOptions, readOnly, session);
        EntityKey entityKey = session.generateEntityKey(pkValue, this.getLoadable().getEntityPersister());
        return (T)session.getPersistenceContext().getEntity(entityKey);
    }

    protected Object[] resolveIdsToLoad(Object pkValue, SharedSessionContractImplementor session) {
        return session.getPersistenceContextInternal().getBatchFetchQueue().getBatchLoadableEntityIds(this.getLoadable(), pkValue, this.domainBatchSize);
    }

    protected void initializeEntities(Object[] idsToInitialize, Object pkValue, Object entityInstance, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        MultiKeyLoadChunker<Object> chunker = new MultiKeyLoadChunker<Object>(this.sqlBatchSize, this.getLoadable().getIdentifierMapping().getJdbcTypeCount(), this.getLoadable().getIdentifierMapping(), this.jdbcParameters, this.sqlAst, this.jdbcSelectOperation);
        BatchFetchQueue batchFetchQueue = session.getPersistenceContextInternal().getBatchFetchQueue();
        ArrayList entityKeys = CollectionHelper.arrayList(this.sqlBatchSize);
        chunker.processChunks(idsToInitialize, this.sqlBatchSize, (jdbcParameterBindings, session1) -> {
            SubselectFetch.RegistrationHandler registrationHandler = SubselectFetch.createRegistrationHandler(batchFetchQueue, this.sqlAst, this.jdbcParameters, jdbcParameterBindings);
            return new SingleIdExecutionContext(pkValue, entityInstance, this.getLoadable().getRootEntityDescriptor(), readOnly, lockOptions, registrationHandler, session);
        }, (key, relativePosition, absolutePosition) -> {
            if (key != null) {
                entityKeys.add(session.generateEntityKey(key, this.getLoadable().getEntityPersister()));
            }
        }, startIndex -> {
            if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isDebugEnabled()) {
                MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.debugf("Processing entity batch-fetch chunk (`%s#%s`) %s - %s", new Object[]{this.getLoadable().getEntityName(), pkValue, startIndex, startIndex + (this.sqlBatchSize - 1)});
            }
        }, (startIndex, nonNullElementCount) -> {
            entityKeys.forEach(batchFetchQueue::removeBatchLoadableEntityKey);
            entityKeys.clear();
        }, session);
    }

    private void initializeChunk(Object[] idsToInitialize, int start, Object pkValue, Object entityInstance, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        EntityBatchLoaderInPredicate.initializeChunk(idsToInitialize, this.getLoadable(), start, this.sqlBatchSize, this.jdbcParameters, this.sqlAst, this.jdbcSelectOperation, pkValue, entityInstance, lockOptions, readOnly, session);
    }

    private static void initializeChunk(Object[] idsToInitialize, EntityMappingType entityMapping, int startIndex, int numberOfKeys, JdbcParametersList jdbcParameters, SelectStatement sqlAst, JdbcOperationQuerySelect jdbcSelectOperation, Object pkValue, Object entityInstance, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        BatchFetchQueue batchFetchQueue = session.getPersistenceContext().getBatchFetchQueue();
        int numberOfJdbcParameters = entityMapping.getIdentifierMapping().getJdbcTypeCount() * numberOfKeys;
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(numberOfJdbcParameters);
        ArrayList<EntityKey> entityKeys = CollectionHelper.arrayList(numberOfKeys);
        int bindCount = 0;
        for (int i = 0; i < numberOfKeys; ++i) {
            int idPosition = i + startIndex;
            Object value = idPosition >= idsToInitialize.length ? null : idsToInitialize[idPosition];
            if (value != null) {
                entityKeys.add(session.generateEntityKey(value, entityMapping.getEntityPersister()));
            }
            bindCount += jdbcParameterBindings.registerParametersForEachJdbcValue(value, bindCount, entityMapping.getIdentifierMapping(), jdbcParameters, session);
        }
        assert (bindCount == jdbcParameters.size());
        if (entityKeys.isEmpty()) {
            return;
        }
        SubselectFetch.RegistrationHandler subSelectFetchableKeysHandler = SubselectFetch.createRegistrationHandler(batchFetchQueue, sqlAst, jdbcParameters, jdbcParameterBindings);
        session.getJdbcServices().getJdbcSelectExecutor().list(jdbcSelectOperation, jdbcParameterBindings, new SingleIdExecutionContext(pkValue, entityInstance, entityMapping.getRootEntityDescriptor(), readOnly, lockOptions, subSelectFetchableKeysHandler, session), RowTransformerStandardImpl.instance(), ListResultsConsumer.UniqueSemantic.FILTER);
        entityKeys.forEach(batchFetchQueue::removeBatchLoadableEntityKey);
    }

    @Override
    public void prepare() {
        EntityIdentifierMapping identifierMapping = this.getLoadable().getIdentifierMapping();
        int expectedNumberOfParameters = identifierMapping.getJdbcTypeCount() * this.sqlBatchSize;
        JdbcParametersList.Builder jdbcParametersBuilder = JdbcParametersList.newBuilder(expectedNumberOfParameters);
        this.sqlAst = LoaderSelectBuilder.createSelect((Loadable)this.getLoadable(), null, identifierMapping, null, this.sqlBatchSize, LoadQueryInfluencers.NONE, LockOptions.NONE, jdbcParametersBuilder::add, this.sessionFactory);
        this.jdbcParameters = jdbcParametersBuilder.build();
        assert (this.jdbcParameters.size() == expectedNumberOfParameters);
        this.jdbcSelectOperation = this.sessionFactory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(this.sessionFactory, this.sqlAst).translate(JdbcParameterBindings.NO_BINDINGS, QueryOptions.NONE);
    }

    public String toString() {
        return String.format(Locale.ROOT, "EntityBatchLoaderInPredicate(%s [%s (%s)])", this.getLoadable().getEntityName(), this.domainBatchSize, this.sqlBatchSize);
    }
}

