/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.opentelemetry.api;

import io.smallrye.opentelemetry.api.OpenTelemetryConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class WildFlyOpenTelemetryConfig
implements OpenTelemetryConfig {
    public static final String OTEL_BSP_MAX_EXPORT_BATCH_SIZE = "otel.bsp.max.export.batch.size";
    public static final String OTEL_BSP_MAX_QUEUE_SIZE = "otel.bsp.max.queue.size";
    public static final String OTEL_BSP_SCHEDULE_DELAY = "otel.bsp.schedule.delay";
    public static final String OTEL_EXPERIMENTAL_SDK_ENABLED = "otel.experimental.sdk.enabled";
    public static final String OTEL_EXPORTER_JAEGER_ENDPOINT = "otel.exporter.jaeger.endpoint";
    public static final String OTEL_EXPORTER_JAEGER_TIMEOUT = "otel.exporter.jaeger.timeout";
    public static final String OTEL_EXPORTER_OTLP_ENDPOINT = "otel.exporter.otlp.endpoint";
    public static final String OTEL_EXPORTER_OTLP_TIMEOUT = "otel.exporter.otlp.timeout";
    public static final String OTEL_METRICS_EXPORTER = "otel.metrics.exporter";
    public static final String OTEL_SDK_DISABLED = "otel.sdk.disabled";
    public static final String OTEL_SERVICE_NAME = "otel.service.name";
    public static final String OTEL_TRACES_EXPORTER = "otel.traces.exporter";
    public static final String OTEL_TRACES_SAMPLER = "otel.traces.sampler";
    public static final String OTEL_TRACES_SAMPLER_ARG = "otel.traces.sampler.arg";
    private final Map<String, String> properties;

    public WildFlyOpenTelemetryConfig(String serviceName, String exporter, String endpoint, Long batchDelay, Long maxQueueSize, Long maxExportBatchSize, Long exportTimeout, String sampler, Double ratio) {
        HashMap<String, String> config = new HashMap<String, String>();
        this.addValue(config, OTEL_SDK_DISABLED, "false");
        this.addValue(config, OTEL_EXPERIMENTAL_SDK_ENABLED, "true");
        this.addValue(config, OTEL_SERVICE_NAME, serviceName);
        this.addValue(config, OTEL_METRICS_EXPORTER, "none");
        this.addValue(config, OTEL_TRACES_EXPORTER, exporter);
        switch (exporter) {
            case "jaeger": {
                this.addValue(config, OTEL_EXPORTER_JAEGER_ENDPOINT, endpoint);
                this.addValue(config, OTEL_EXPORTER_JAEGER_TIMEOUT, exportTimeout);
                break;
            }
            case "otlp": {
                this.addValue(config, OTEL_EXPORTER_OTLP_ENDPOINT, endpoint);
                this.addValue(config, OTEL_EXPORTER_OTLP_TIMEOUT, exportTimeout);
            }
        }
        this.addValue(config, OTEL_BSP_SCHEDULE_DELAY, batchDelay);
        this.addValue(config, OTEL_BSP_MAX_QUEUE_SIZE, maxQueueSize);
        this.addValue(config, OTEL_BSP_MAX_EXPORT_BATCH_SIZE, maxExportBatchSize);
        if (sampler != null) {
            switch (sampler) {
                case "on": {
                    this.addValue(config, OTEL_TRACES_SAMPLER, "always_on");
                    break;
                }
                case "off": {
                    this.addValue(config, OTEL_TRACES_SAMPLER, "always_off");
                    break;
                }
                case "ratio": {
                    this.addValue(config, OTEL_TRACES_SAMPLER, "traceidratio");
                }
            }
        }
        this.addValue(config, OTEL_TRACES_SAMPLER_ARG, ratio);
        this.properties = Collections.unmodifiableMap(config);
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    private void addValue(Map<String, String> config, String key, Object value) {
        if (value != null) {
            config.put(key, value.toString());
        }
    }
}

