/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.extensions.matrix;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.aesh.command.shell.Shell;
import org.aesh.extensions.matrix.MatrixPoint;
import org.aesh.readline.terminal.formatting.Color;
import org.aesh.readline.terminal.formatting.TerminalColor;
import org.aesh.readline.util.LoggerUtil;

public class MatrixRunner
implements Runnable {
    private static Logger logger = LoggerUtil.getLogger((String)"MatrixRunner.class");
    private final Shell shell;
    private final MatrixPoint[][] matrix;
    private final int[] delay;
    private final int columns;
    private final int rows;
    private boolean running = true;
    private boolean async = true;
    private int speed;
    private static final TerminalColor GREEN_COLOR = new TerminalColor(Color.GREEN, Color.DEFAULT);
    private static final TerminalColor DEFAULT_COLOR = new TerminalColor(Color.DEFAULT, Color.DEFAULT);

    public MatrixRunner(Shell shell, List<String> knockStrings, InputStream inputText, int speed, boolean async) {
        this.shell = shell;
        this.async = async;
        this.speed = speed;
        this.columns = shell.size().getWidth();
        this.rows = shell.size().getHeight();
        this.matrix = new MatrixPoint[this.rows][this.columns];
        this.delay = new int[this.columns];
        this.setupMatrix(knockStrings, inputText);
    }

    private void setupMatrix(List<String> knockStrings, InputStream inputStream) {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                this.matrix[i][j] = new MatrixPoint(this.rows, this.columns, i + 1, j + 1);
                if (i != 0) continue;
                this.delay[j] = (int)(Math.random() * 3.0) + 2;
            }
        }
        this.shell.write(GREEN_COLOR.fullString());
        if (knockStrings != null) {
            this.knockKnock(knockStrings);
        }
        if (inputStream != null) {
            this.readFile(inputStream);
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        int counter = 1;
        try {
            while (this.running) {
                long startTime = System.currentTimeMillis();
                ++counter;
                for (int i = 0; i < this.rows; ++i) {
                    for (int j = 0; j < this.columns; j += 2) {
                        if (counter <= this.delay[j] && this.async) continue;
                        if (i == 0) {
                            if (!this.matrix[i][j].isPartOfTextOrSpace()) {
                                this.matrix[i][j].newCycle();
                                this.matrix[i][j].getChanges(this.shell);
                                continue;
                            }
                            this.matrix[i][j].nextCycle();
                            this.matrix[i][j].getChanges(this.shell);
                            continue;
                        }
                        if (!this.matrix[i][j].isPartOfTextOrSpace()) {
                            if (!this.matrix[i - 1][j].isNextUp()) continue;
                            this.matrix[i][j].newCycle(this.matrix[i - 1][j].getPosition() - 1, this.matrix[i - 1][j].getLength(), true);
                            this.matrix[i][j].getChanges(this.shell);
                            continue;
                        }
                        if (!this.matrix[i][j].isPartOfTextOrSpace()) continue;
                        this.matrix[i][j].nextCycle();
                        this.matrix[i][j].getChanges(this.shell);
                    }
                }
                int sleepTime = this.speed * 8 - (int)(System.currentTimeMillis() - startTime);
                if (sleepTime > 0) {
                    Thread.sleep(sleepTime);
                }
                if (counter <= 4) continue;
                counter = 1;
            }
        }
        catch (IOException | InterruptedException ioe) {
            logger.warning(ioe.getMessage());
        }
    }

    private void knockKnock(List<String> knockStrings) {
        try {
            this.shell.write("\u001b[?25h");
            for (String knock : knockStrings) {
                this.showKnock(knock);
                Thread.sleep(2000L);
                this.shell.clear();
            }
            this.shell.write("\u001b[?25l");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            logger.warning(e.getMessage());
        }
    }

    private void showKnock(String knock) throws InterruptedException {
        this.shell.write("\u001b[1;1H");
        for (char c : knock.toCharArray()) {
            this.shell.write(c);
            Thread.sleep(40L);
        }
    }

    private void readFile(InputStream stream) {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            InputStreamReader inputReader = new InputStreamReader(stream);
            BufferedReader br = new BufferedReader(inputReader);
            String line = br.readLine();
            while (line != null) {
                lines.add(line);
                line = br.readLine();
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.warning(e.getMessage());
        }
        int height = this.shell.size().getHeight();
        this.shell.write("\u001b[" + height + ";" + 1 + "H");
        if (lines.size() > 0) {
            int counter = 0;
            for (int i = lines.size() - 1; i > -1; --i) {
                int columnCounter = 0;
                for (char c : ((String)lines.get(i)).toCharArray()) {
                    this.shell.write(c);
                    if (c != ' ') {
                        this.matrix[height - counter - 1][columnCounter].setDefaultCharacter(c);
                    }
                    ++columnCounter;
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                this.shell.write("\u001b[" + (height - ++counter) + ";" + 1 + "H");
            }
        }
    }

    public void stop() {
        this.running = false;
        this.shell.write(DEFAULT_COLOR.fullString());
    }

    public void asynch() {
        this.async = !this.async;
    }

    public void speed(int s) {
        if (s > 0 && s < 9) {
            this.speed = s;
        }
    }
}

