/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Consumer;
import org.jboss.as.clustering.jgroups.subsystem.AuthProtocolResourceTransformer;
import org.jboss.as.clustering.jgroups.subsystem.EncryptProtocolResourceTransformer;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceRegistrar;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;

public class ProtocolTransformer
implements Consumer<ModelVersion> {
    private final Map<ProtocolResourceRegistrar.AuthProtocol, ResourceTransformationDescriptionBuilder> authBuilders = new EnumMap<ProtocolResourceRegistrar.AuthProtocol, ResourceTransformationDescriptionBuilder>(ProtocolResourceRegistrar.AuthProtocol.class);
    private final Map<ProtocolResourceRegistrar.EncryptProtocol, ResourceTransformationDescriptionBuilder> encryptBuilders = new EnumMap<ProtocolResourceRegistrar.EncryptProtocol, ResourceTransformationDescriptionBuilder>(ProtocolResourceRegistrar.EncryptProtocol.class);

    ProtocolTransformer(ResourceTransformationDescriptionBuilder parent) {
        for (ProtocolResourceRegistrar.AuthProtocol authProtocol : EnumSet.allOf(ProtocolResourceRegistrar.AuthProtocol.class)) {
            this.authBuilders.put(authProtocol, parent.addChildResource(ProtocolResourceDefinition.pathElement(authProtocol.name())));
        }
        for (ProtocolResourceRegistrar.EncryptProtocol encryptProtocol : EnumSet.allOf(ProtocolResourceRegistrar.EncryptProtocol.class)) {
            this.encryptBuilders.put(encryptProtocol, parent.addChildResource(ProtocolResourceDefinition.pathElement(encryptProtocol.name())));
        }
    }

    @Override
    public void accept(ModelVersion version) {
        for (ResourceTransformationDescriptionBuilder builder : this.authBuilders.values()) {
            new AuthProtocolResourceTransformer(builder).accept(version);
        }
        for (ResourceTransformationDescriptionBuilder builder : this.encryptBuilders.values()) {
            new EncryptProtocolResourceTransformer(builder).accept(version);
        }
    }
}

