/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.ejb;

import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.ejb.bean.BeanManagementProvider;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanManagementConfiguration;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanManagementProvider;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.extension.clustering.ejb.BeanManagementServiceConfigurator;
import org.wildfly.extension.clustering.ejb.InfinispanBeanManagementResourceDefinition;

public class InfinispanBeanManagementServiceConfigurator
extends BeanManagementServiceConfigurator
implements InfinispanBeanManagementConfiguration {
    private volatile String containerName;
    private volatile String cacheName;

    public InfinispanBeanManagementServiceConfigurator(PathAddress address) {
        super(address);
    }

    @Override
    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.containerName = InfinispanBeanManagementResourceDefinition.Attribute.CACHE_CONTAINER.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.cacheName = InfinispanBeanManagementResourceDefinition.Attribute.CACHE.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        return super.configure(context, model);
    }

    @Override
    public BeanManagementProvider apply(String name) {
        return new InfinispanBeanManagementProvider(name, (InfinispanBeanManagementConfiguration)this);
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getCacheName() {
        return this.cacheName;
    }
}

