/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederation;

public final class AMQPFederationConsumerConfiguration {
    private final Map<String, Object> properties;
    private final AMQPFederation federation;

    public AMQPFederationConsumerConfiguration(AMQPFederation federation, Map<String, ?> properties) {
        this.federation = federation;
        this.properties = properties == null || properties.isEmpty() ? Collections.EMPTY_MAP : Collections.unmodifiableMap(new HashMap(properties));
    }

    public int getReceiverCredits() {
        Object property = this.properties.get("amqpCredits");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return this.federation.getReceiverCredits();
    }

    public int getReceiverCreditsLow() {
        Object property = this.properties.get("amqpLowCredits");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return this.federation.getReceiverCreditsLow();
    }

    public int getLargeMessageThreshold() {
        Object property = this.properties.get("minLargeMessageSize");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return this.federation.getLargeMessageThreshold();
    }

    public int getLinkAttachTimeout() {
        Object property = this.properties.get("attach-timeout");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return this.federation.getLinkAttachTimeout();
    }
}

