/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.weld.contexts;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.inject.spi.PassivationCapable;
import java.io.IOException;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.protostream.descriptors.WireType;
import org.jboss.weld.Container;
import org.jboss.weld.serialization.BeanIdentifierIndex;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.serialization.spi.helpers.SerializableContextual;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.weld.contexts.MarshallableContextual;

public class PassivationCapableSerializableMarshaller<SC extends SerializableContextual<C, I> & PassivationCapable, C extends Contextual<I> & PassivationCapable, I>
implements ProtoStreamMarshaller<SC> {
    private static final int CONTEXT_INDEX = 1;
    private static final int CONTEXTUAL_INDEX = 2;
    private static final int IDENTIFIER_INDEX = 3;
    private static final int INDEX_INDEX = 4;
    private final Class<SC> targetClass;
    private final BiFunction<String, C, SC> resolvedFactory;
    private final BiFunction<String, BeanIdentifier, SC> unresolvedFactory;
    private final Function<SC, String> contextFunction;

    PassivationCapableSerializableMarshaller(Class<SC> targetClass, BiFunction<String, C, SC> resolvedFactory, BiFunction<String, BeanIdentifier, SC> unresolvedFactory, Function<SC, String> contextFunction) {
        this.targetClass = targetClass;
        this.resolvedFactory = resolvedFactory;
        this.unresolvedFactory = unresolvedFactory;
        this.contextFunction = contextFunction;
    }

    public Class<SC> getJavaClass() {
        return this.targetClass;
    }

    public SC readFrom(ProtoStreamReader reader) throws IOException {
        String contextId = null;
        Contextual contextual = null;
        BeanIdentifier identifier = null;
        int beanIndex = 0;
        block6: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    contextId = (String)reader.readAny(String.class);
                    continue block6;
                }
                case 2: {
                    contextual = (Contextual)reader.readAny();
                    continue block6;
                }
                case 3: {
                    identifier = (BeanIdentifier)reader.readAny(BeanIdentifier.class);
                    continue block6;
                }
                case 4: {
                    beanIndex = reader.readUInt32();
                    continue block6;
                }
            }
            reader.skipField(tag);
        }
        if (contextual != null) {
            return (SC)((SerializableContextual)this.resolvedFactory.apply(contextId, contextual));
        }
        if (identifier == null) {
            BeanIdentifierIndex index = (BeanIdentifierIndex)Container.instance(contextId).services().get(BeanIdentifierIndex.class);
            identifier = index.getIdentifier(beanIndex);
        }
        return (SC)((SerializableContextual)this.unresolvedFactory.apply(contextId, identifier));
    }

    public void writeTo(ProtoStreamWriter writer, SC contextual) throws IOException {
        String contextId = this.contextFunction.apply(contextual);
        writer.writeAny(1, (Object)this.contextFunction.apply(contextual));
        Contextual instance = (Contextual)((MarshallableContextual)contextual).getInstance();
        if (instance != null && writer.getSerializationContext().canMarshall((Object)instance)) {
            writer.writeAny(2, (Object)instance);
        } else {
            Integer beanIndex;
            BeanIdentifier identifier = ((MarshallableContextual)contextual).getIdentifier();
            BeanIdentifierIndex index = (BeanIdentifierIndex)Container.instance((String)contextId).services().get(BeanIdentifierIndex.class);
            Integer n = beanIndex = index != null && index.isBuilt() ? index.getIndex(identifier) : null;
            if (beanIndex != null) {
                int value = beanIndex;
                if (value != 0) {
                    writer.writeUInt32(4, value);
                }
            } else {
                writer.writeAny(3, (Object)identifier);
            }
        }
    }
}

