/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.msc.Service;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.IdentityHashSet;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceControllerImpl;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistrationImpl;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTargetImpl;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.service.WritableValueImpl;

final class ServiceBuilderImpl<T>
implements ServiceBuilder<T> {
    final ServiceName serviceId;
    final ServiceControllerImpl<?> parent;
    private final ServiceTargetImpl serviceTarget;
    private final Thread thread = Thread.currentThread();
    private final Map<ServiceName, WritableValueImpl> provides = new HashMap<ServiceName, WritableValueImpl>();
    private Service service;
    private Set<ServiceName> aliases;
    private ServiceController.Mode initialMode;
    private Map<ServiceName, Dependency> requires;
    private Set<StabilityMonitor> monitors;
    private Set<LifecycleListener> lifecycleListeners;
    private boolean installed;

    ServiceBuilderImpl(ServiceName serviceId, ServiceTargetImpl serviceTarget, org.jboss.msc.service.Service<T> service, ServiceControllerImpl<?> parent) {
        this(serviceId, serviceTarget, parent);
        if (service == null) {
            throw new IllegalArgumentException("Service can not be null");
        }
        this.service = service;
    }

    ServiceBuilderImpl(ServiceName serviceId, ServiceTargetImpl serviceTarget, ServiceControllerImpl<?> parent) {
        this.serviceId = serviceId;
        this.serviceTarget = serviceTarget;
        this.parent = parent;
        if (serviceId != null) {
            this.addProvidesInternal(serviceId, null);
        }
    }

    @Override
    public ServiceBuilder<T> addAliases(ServiceName ... aliases) {
        this.assertNotInstalled();
        ServiceBuilderImpl.assertNotNull(aliases);
        this.assertThreadSafety();
        for (ServiceName alias : aliases) {
            ServiceBuilderImpl.assertNotNull(alias);
            this.assertNotRequired(alias, false);
        }
        for (ServiceName alias : aliases) {
            if (alias.equals(this.serviceId) || !this.addAliasInternal(alias)) continue;
            this.addProvidesInternal(alias, null);
        }
        return this;
    }

    @Override
    public <V> Supplier<V> requires(ServiceName dependency) {
        this.assertNotInstalled();
        ServiceBuilderImpl.assertNotNull(dependency);
        this.assertThreadSafety();
        this.assertNotInstanceId(dependency);
        this.assertNotProvided(dependency, true);
        return this.addRequiresInternal(dependency).getRegistration().getReadableValue();
    }

    @Override
    public <V> Consumer<V> provides(ServiceName ... dependencies) {
        this.assertNotInstalled();
        ServiceBuilderImpl.assertNotNull(dependencies);
        this.assertThreadSafety();
        for (ServiceName dependency : dependencies) {
            ServiceBuilderImpl.assertNotNull(dependency);
            this.assertNotRequired(dependency, false);
            this.assertNotProvided(dependency, false);
        }
        WritableValueImpl retVal = new WritableValueImpl();
        for (ServiceName dependency : dependencies) {
            this.addProvidesInternal(dependency, retVal);
        }
        return retVal;
    }

    @Override
    public ServiceBuilder<T> setInstance(Service service) {
        this.assertNotInstalled();
        this.assertThreadSafety();
        this.assertServiceNotConfigured();
        this.service = service != null ? service : Service.NULL;
        return this;
    }

    @Override
    public ServiceBuilder<T> setInitialMode(ServiceController.Mode mode) {
        this.assertNotInstalled();
        ServiceBuilderImpl.assertNotNull((Object)mode);
        ServiceBuilderImpl.assertNotRemove(mode);
        this.assertModeNotConfigured();
        this.assertThreadSafety();
        this.initialMode = mode;
        return this;
    }

    @Override
    public ServiceBuilder<T> addMonitor(StabilityMonitor monitor) {
        this.assertNotInstalled();
        ServiceBuilderImpl.assertNotNull(monitor);
        this.assertThreadSafety();
        this.addMonitorInternal(monitor);
        return this;
    }

    @Override
    public ServiceBuilder<T> addListener(LifecycleListener listener) {
        this.assertNotInstalled();
        ServiceBuilderImpl.assertNotNull(listener);
        this.assertThreadSafety();
        this.addListenerInternal(listener);
        return this;
    }

    @Override
    public ServiceController<T> install() throws ServiceRegistryException {
        this.assertNotInstalled();
        this.assertThreadSafety();
        this.installed = true;
        if (this.service == null) {
            this.service = Service.NULL;
        }
        if (this.initialMode == null) {
            this.initialMode = ServiceController.Mode.ACTIVE;
        }
        return this.serviceTarget.install(this);
    }

    @Override
    public <I> ServiceBuilder<T> addDependency(ServiceName dependency, Class<I> type, Injector<I> target) {
        this.assertNotInstalled();
        ServiceBuilderImpl.assertNotNull(dependency);
        ServiceBuilderImpl.assertNotNull(type);
        ServiceBuilderImpl.assertNotNull(target);
        this.assertThreadSafety();
        this.addRequiresInternal(dependency).getInjectorList().add(target);
        return this;
    }

    void addLifecycleListenersNoCheck(Set<LifecycleListener> listeners) {
        if (listeners == null || listeners.isEmpty()) {
            return;
        }
        for (LifecycleListener listener : listeners) {
            if (listener == null) continue;
            this.addListenerInternal(listener);
        }
    }

    void addMonitorsNoCheck(Collection<? extends StabilityMonitor> monitors) {
        for (StabilityMonitor stabilityMonitor : monitors) {
            if (stabilityMonitor == null) continue;
            this.addMonitorInternal(stabilityMonitor);
        }
    }

    void addDependenciesNoCheck(Iterable<ServiceName> dependencies) {
        for (ServiceName dependency : dependencies) {
            if (dependency == null || this.requires != null && this.requires.containsKey(dependency) || this.provides != null && this.provides.containsKey(dependency)) continue;
            this.addRequiresInternal(dependency);
        }
    }

    Service getService() {
        return this.service;
    }

    private Dependency addRequiresInternal(ServiceName name) {
        if (this.requires == null) {
            this.requires = new HashMap<ServiceName, Dependency>();
        }
        if (this.requires.size() == 16383) {
            throw new IllegalArgumentException("Too many dependencies specified (max is 16383)");
        }
        Dependency existing = this.requires.get(name);
        if (existing != null) {
            return existing;
        }
        Dependency dependency = new Dependency(this.serviceTarget.getOrCreateRegistration(name));
        this.requires.put(name, dependency);
        return dependency;
    }

    boolean addAliasInternal(ServiceName alias) {
        if (this.aliases == null) {
            this.aliases = new HashSet<ServiceName>();
        }
        if (!this.aliases.contains(alias)) {
            this.aliases.add(alias);
            return true;
        }
        return false;
    }

    void addProvidesInternal(ServiceName name, WritableValueImpl dependency) {
        if (dependency != null) {
            this.provides.put(name, dependency);
        } else if (!this.provides.containsKey(name)) {
            this.provides.put(name, null);
        }
    }

    void addMonitorInternal(StabilityMonitor monitor) {
        if (this.monitors == null) {
            this.monitors = new IdentityHashSet<StabilityMonitor>();
        }
        this.monitors.add(monitor);
    }

    void addListenerInternal(LifecycleListener listener) {
        if (this.lifecycleListeners == null) {
            this.lifecycleListeners = new IdentityHashSet<LifecycleListener>();
        }
        this.lifecycleListeners.add(listener);
    }

    Collection<ServiceName> getServiceAliases() {
        return this.aliases == null ? Collections.emptySet() : this.aliases;
    }

    Map<ServiceName, WritableValueImpl> getProvides() {
        return this.provides;
    }

    Map<ServiceName, Dependency> getDependencies() {
        return this.requires == null ? Collections.emptyMap() : this.requires;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<StabilityMonitor> getMonitors() {
        for (ServiceController<Object> parent = this.parent; parent != null; parent = parent.getParent()) {
            ServiceControllerImpl<?> serviceControllerImpl = parent;
            synchronized (serviceControllerImpl) {
                this.addMonitorsNoCheck(parent.getMonitors());
                continue;
            }
        }
        return this.monitors == null ? Collections.emptySet() : this.monitors;
    }

    Set<LifecycleListener> getLifecycleListeners() {
        return this.lifecycleListeners == null ? Collections.emptySet() : this.lifecycleListeners;
    }

    ServiceController.Mode getInitialMode() {
        return this.initialMode;
    }

    private void assertNotInstalled() {
        if (this.installed) {
            throw new IllegalStateException("ServiceBuilder already installed");
        }
    }

    private void assertThreadSafety() {
        if (this.thread != Thread.currentThread()) {
            throw new ConcurrentModificationException("ServiceBuilder used by multiple threads");
        }
    }

    private void assertNotInstanceId(ServiceName dependency) {
        if (dependency.equals(this.serviceId)) {
            throw new IllegalArgumentException("Cannot both require and provide same dependency:" + dependency);
        }
    }

    private void assertNotRequired(ServiceName dependency, boolean processingRequires) {
        if (this.requires != null && this.requires.keySet().contains(dependency)) {
            if (processingRequires) {
                throw new IllegalArgumentException("Cannot require dependency more than once:" + dependency);
            }
            throw new IllegalArgumentException("Cannot both require and provide same dependency:" + dependency);
        }
    }

    private void assertNotProvided(ServiceName dependency, boolean processingRequires) {
        if (processingRequires) {
            if (this.provides.containsKey(dependency)) {
                throw new IllegalArgumentException("Cannot both require and provide same dependency:" + dependency);
            }
        } else if (this.provides.get(dependency) != null) {
            throw new IllegalArgumentException("Cannot provide dependency more than once: " + dependency);
        }
    }

    private void assertServiceNotConfigured() {
        if (this.service != null) {
            throw new IllegalStateException("Detected addAliases(), requires(), provides() or setInstance() call after setInstance() method call");
        }
    }

    private void assertModeNotConfigured() {
        if (this.initialMode != null) {
            throw new IllegalStateException("setInitialMode() method called twice");
        }
    }

    private static void assertNotNull(Object parameter) {
        if (parameter == null) {
            throw new NullPointerException("Method parameter cannot be null");
        }
    }

    private static void assertNotRemove(ServiceController.Mode mode) {
        if (mode == ServiceController.Mode.REMOVE) {
            throw new IllegalArgumentException("Initial service mode cannot be REMOVE");
        }
    }

    static final class Dependency {
        private final ServiceRegistrationImpl registration;
        private List<Injector<Object>> injectorList = new ArrayList<Injector<Object>>(0);

        Dependency(ServiceRegistrationImpl registration) {
            this.registration = registration;
        }

        ServiceRegistrationImpl getRegistration() {
            return this.registration;
        }

        List<Injector<Object>> getInjectorList() {
            return this.injectorList;
        }
    }
}

