/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.filters;

import io.undertow.Handlers;
import io.undertow.predicate.Predicate;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.undertow.FilterLocation;
import org.wildfly.extension.undertow.UndertowFilter;

public class FilterService
implements Service<UndertowFilter>,
UndertowFilter {
    private final Consumer<UndertowFilter> serviceConsumer;
    private final Supplier<HandlerWrapper> wrapper;
    private final Supplier<FilterLocation> location;
    private final Predicate predicate;
    private final int priority;

    FilterService(Consumer<UndertowFilter> serviceConsumer, Supplier<HandlerWrapper> wrapper, Supplier<FilterLocation> location, Predicate predicate, int priority) {
        this.serviceConsumer = serviceConsumer;
        this.wrapper = wrapper;
        this.location = location;
        this.predicate = predicate;
        this.priority = priority;
    }

    public void start(StartContext context) throws StartException {
        this.location.get().addFilter(this);
        this.serviceConsumer.accept(this);
    }

    public void stop(StopContext context) {
        this.serviceConsumer.accept(null);
        this.location.get().removeFilter(this);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public UndertowFilter getValue() {
        return this;
    }

    public HttpHandler wrap(HttpHandler next) {
        HttpHandler handler = this.wrapper.get().wrap(next);
        return this.predicate != null ? Handlers.predicate((Predicate)this.predicate, (HttpHandler)handler, (HttpHandler)next) : handler;
    }
}

