/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import io.opentelemetry.sdk.metrics.internal.state.AdaptingCircularBufferCounter;
import io.opentelemetry.sdk.metrics.internal.state.ExponentialCounter;
import io.opentelemetry.sdk.metrics.internal.state.MapCounter;

public interface ExponentialCounterFactory {
    public ExponentialCounter newCounter(int var1);

    public ExponentialCounter copy(ExponentialCounter var1);

    public static ExponentialCounterFactory mapCounter() {
        return new ExponentialCounterFactory(){

            @Override
            public ExponentialCounter newCounter(int maxSize) {
                return new MapCounter(maxSize);
            }

            @Override
            public ExponentialCounter copy(ExponentialCounter other) {
                return new MapCounter(other);
            }

            public String toString() {
                return "mapCounter";
            }
        };
    }

    public static ExponentialCounterFactory circularBufferCounter() {
        return new ExponentialCounterFactory(){

            @Override
            public ExponentialCounter newCounter(int maxSize) {
                return new AdaptingCircularBufferCounter(maxSize);
            }

            @Override
            public ExponentialCounter copy(ExponentialCounter other) {
                return new AdaptingCircularBufferCounter(other);
            }

            public String toString() {
                return "circularBufferCounter";
            }
        };
    }
}

