/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.OptionalInt;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamSizeOperation;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshalledKey;

public class ByteBufferMarshalledKeyMarshaller
implements ProtoStreamMarshaller<ByteBufferMarshalledKey<Object>> {
    private static final int BUFFER_INDEX = 1;
    private static final int HASH_CODE_INDEX = 2;

    @Override
    public ByteBufferMarshalledKey<Object> readFrom(ProtoStreamReader reader) throws IOException {
        ByteBuffer buffer = null;
        int hashCode = 0;
        block4: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    buffer = reader.readByteBuffer();
                    continue block4;
                }
                case 2: {
                    hashCode = reader.readSFixed32();
                    continue block4;
                }
            }
            reader.skipField(tag);
        }
        return new ByteBufferMarshalledKey(buffer, hashCode);
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, ByteBufferMarshalledKey<Object> key) throws IOException {
        int hashCode;
        ByteBuffer buffer = key.getBuffer();
        if (buffer != null) {
            writer.writeBytes(1, buffer);
        }
        if ((hashCode = key.hashCode()) != 0) {
            writer.writeSFixed32(2, hashCode);
        }
    }

    @Override
    public OptionalInt size(ProtoStreamSizeOperation operation, ByteBufferMarshalledKey<Object> key) {
        if (key.isEmpty()) {
            return OptionalInt.of(0);
        }
        int hashCodeSize = 4 + operation.tagSize(2, WireType.FIXED32);
        OptionalInt size = key.size();
        return size.isPresent() ? OptionalInt.of(operation.tagSize(1, WireType.LENGTH_DELIMITED) + operation.varIntSize(size.getAsInt()) + size.getAsInt() + hashCodeSize) : OptionalInt.empty();
    }

    @Override
    public Class<? extends ByteBufferMarshalledKey<Object>> getJavaClass() {
        return ByteBufferMarshalledKey.class;
    }
}

