/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer.metrics;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.wildfly.extension.micrometer.metrics.MetricMetadata;

public class MetricID
implements Comparable<MetricID> {
    private final String metricName;
    private final Map<String, String> tags = new TreeMap<String, String>();

    public MetricID(String metricName, MetricMetadata.MetricTag[] tags) {
        this.metricName = metricName;
        for (MetricMetadata.MetricTag tag : tags) {
            this.tags.put(tag.getKey(), tag.getValue());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricID metricID = (MetricID)o;
        return this.metricName.equals(metricID.metricName) && this.tags.equals(metricID.tags);
    }

    public int hashCode() {
        return Objects.hash(this.metricName, this.tags);
    }

    @Override
    public int compareTo(MetricID other) {
        int compareVal = this.metricName.compareTo(other.metricName);
        if (compareVal == 0 && (compareVal = this.tags.size() - other.tags.size()) == 0) {
            Iterator<Map.Entry<String, String>> thisIterator = this.tags.entrySet().iterator();
            Iterator<Map.Entry<String, String>> otherIterator = other.tags.entrySet().iterator();
            while (thisIterator.hasNext() && otherIterator.hasNext()) {
                Map.Entry<String, String> thisEntry = thisIterator.next();
                Map.Entry<String, String> otherEntry = otherIterator.next();
                compareVal = thisEntry.getKey().compareTo(otherEntry.getKey());
                if (compareVal != 0) {
                    return compareVal;
                }
                compareVal = thisEntry.getValue().compareTo(otherEntry.getValue());
                if (compareVal == 0) continue;
                return compareVal;
            }
        }
        return compareVal;
    }
}

