/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.filter;

import io.narayana.lra.Current;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import java.net.URI;
import org.eclipse.microprofile.config.ConfigProvider;

@Provider
public class ClientLRARequestFilter
implements ClientRequestFilter {
    private boolean canPropagate = ConfigProvider.getConfig().getOptionalValue("mp.lra.propagation.active", Boolean.class).orElse(true);

    public void filter(ClientRequestContext context) {
        MultivaluedMap headers = context.getHeaders();
        if (headers.containsKey((Object)"Long-Running-Action")) {
            return;
        }
        URI lraId = Current.peek();
        if (lraId != null) {
            if (this.canPropagate) {
                headers.putSingle((Object)"Long-Running-Action", (Object)lraId);
                context.setProperty("Long-Running-Action", (Object)lraId);
            }
        } else {
            Object lraContext = context.getProperty("Long-Running-Action");
            if (lraContext != null) {
                if (this.canPropagate) {
                    headers.putSingle((Object)"Long-Running-Action", lraContext);
                }
            } else {
                headers.remove((Object)"Long-Running-Action");
            }
        }
    }
}

