/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.SitesConfiguration;
import org.infinispan.configuration.cache.SitesConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.BackupResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.ComponentServiceConfigurator;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.wildfly.clustering.service.ServiceConfigurator;

public class BackupsServiceConfigurator
extends ComponentServiceConfigurator<SitesConfiguration> {
    private final Map<String, BackupConfiguration> backups = new HashMap<String, BackupConfiguration>();

    BackupsServiceConfigurator(PathAddress address) {
        super(CacheComponent.BACKUPS, address);
    }

    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.backups.clear();
        if (model.hasDefined(BackupResourceDefinition.WILDCARD_PATH.getKey())) {
            SitesConfigurationBuilder builder = new ConfigurationBuilder().sites();
            for (Property property : model.get(BackupResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                String siteName = property.getName();
                ModelNode backup = property.getValue();
                BackupConfigurationBuilder backupBuilder = builder.addBackup();
                backupBuilder.site(siteName).backupFailurePolicy(BackupFailurePolicy.valueOf((String)BackupResourceDefinition.Attribute.FAILURE_POLICY.resolveModelAttribute((ExpressionResolver)context, backup).asString())).replicationTimeout(BackupResourceDefinition.Attribute.TIMEOUT.resolveModelAttribute((ExpressionResolver)context, backup).asLong()).strategy(BackupConfiguration.BackupStrategy.valueOf((String)BackupResourceDefinition.Attribute.STRATEGY.resolveModelAttribute((ExpressionResolver)context, backup).asString())).takeOffline().afterFailures(BackupResourceDefinition.TakeOfflineAttribute.AFTER_FAILURES.resolveModelAttribute((ExpressionResolver)context, backup).asInt()).minTimeToWait(BackupResourceDefinition.TakeOfflineAttribute.MIN_WAIT.resolveModelAttribute((ExpressionResolver)context, backup).asLong());
                this.backups.put(siteName, backupBuilder.create());
            }
        }
        return this;
    }

    @Override
    public SitesConfiguration get() {
        SitesConfigurationBuilder builder = new ConfigurationBuilder().sites();
        for (Map.Entry<String, BackupConfiguration> backup : this.backups.entrySet()) {
            builder.addBackup().read((Object)backup.getValue());
        }
        return builder.create();
    }
}

