/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Map;
import org.infinispan.xsite.XSiteAdminOperations;
import org.jboss.as.clustering.controller.Operation;
import org.jboss.as.clustering.infinispan.subsystem.BackupResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public enum BackupOperation implements Operation<Map.Entry<String, XSiteAdminOperations>>
{
    BRING_SITE_ONLINE("bring-site-online", false){

        public ModelNode execute(ExpressionResolver expressionResolver, ModelNode operation, Map.Entry<String, XSiteAdminOperations> context) {
            return new ModelNode(context.getValue().bringSiteOnline(context.getKey()));
        }
    }
    ,
    TAKE_SITE_OFFLINE("take-site-offline", false){

        public ModelNode execute(ExpressionResolver expressionResolver, ModelNode operation, Map.Entry<String, XSiteAdminOperations> context) {
            return new ModelNode(context.getValue().takeSiteOffline(context.getKey()));
        }
    }
    ,
    SITE_STATUS("site-status", true){

        public ModelNode execute(ExpressionResolver expressionResolver, ModelNode operation, Map.Entry<String, XSiteAdminOperations> context) {
            return new ModelNode(context.getValue().siteStatus(context.getKey()));
        }
    };

    private final OperationDefinition definition;

    private BackupOperation(String name, boolean readOnly) {
        SimpleOperationDefinitionBuilder builder = new SimpleOperationDefinitionBuilder(name, (ResourceDescriptionResolver)InfinispanExtension.SUBSYSTEM_RESOLVER.createChildResolver(BackupResourceDefinition.WILDCARD_PATH));
        if (readOnly) {
            builder.setReadOnly();
        }
        this.definition = builder.setReplyType(ModelType.STRING).setRuntimeOnly().build();
    }

    public OperationDefinition getDefinition() {
        return this.definition;
    }
}

