/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.ResponseProcessingException;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logging.Logger;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.microprofile.client.ExceptionMapping;
import org.jboss.resteasy.microprofile.client.RestClientProxy;
import org.jboss.resteasy.microprofile.client.header.ClientHeaderFillingException;

public class ProxyInvocationHandler
implements InvocationHandler {
    private static final Logger LOGGER = Logger.getLogger(ProxyInvocationHandler.class);
    public static final Type[] NO_TYPES = new Type[0];
    private final Object target;
    private final Set<Object> providerInstances;
    private final ResteasyClient client;
    private final AtomicBoolean closed;

    public ProxyInvocationHandler(Class<?> restClientInterface, Object target, Set<Object> providerInstances, ResteasyClient client) {
        this.target = target;
        this.providerInstances = providerInstances;
        this.client = client;
        this.closed = new AtomicBoolean();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object[] argsReplacement;
        boolean replacementNeeded;
        block25: {
            if (RestClientProxy.class.equals(method.getDeclaringClass())) {
                return this.invokeRestClientProxyMethod(proxy, method, args);
            }
            if (method.getName().equals("close") && (args == null || args.length == 0)) {
                this.close();
                return null;
            }
            if (this.closed.get()) {
                throw new IllegalStateException("RestClientProxy is closed");
            }
            replacementNeeded = false;
            argsReplacement = args != null ? new Object[args.length] : null;
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            if (args == null) break block25;
            for (Object p : this.providerInstances) {
                if (!(p instanceof ParamConverterProvider)) continue;
                int index = 0;
                for (Object arg : args) {
                    block27: {
                        block26: {
                            Type[] genericTypes;
                            if (arg == null) continue;
                            if (parameterAnnotations[index].length <= 0) break block26;
                            ParamConverter converter = ((ParamConverterProvider)p).getConverter(arg.getClass(), null, parameterAnnotations[index]);
                            if (converter == null || (genericTypes = this.getGenericTypes(converter.getClass())).length != 1) break block27;
                            switch (genericTypes[0].getTypeName()) {
                                case "java.lang.String": {
                                    ParamConverter stringConverter = converter;
                                    argsReplacement[index] = stringConverter.toString((Object)((String)arg));
                                    replacementNeeded = true;
                                    break block27;
                                }
                                case "java.lang.Integer": {
                                    ParamConverter intConverter = converter;
                                    argsReplacement[index] = intConverter.toString((Object)((Integer)arg));
                                    replacementNeeded = true;
                                    break block27;
                                }
                                case "java.lang.Boolean": {
                                    ParamConverter boolConverter = converter;
                                    argsReplacement[index] = boolConverter.toString((Object)((Boolean)arg));
                                    replacementNeeded = true;
                                    break block27;
                                }
                            }
                            continue;
                        }
                        argsReplacement[index] = arg;
                    }
                    ++index;
                }
            }
        }
        if (replacementNeeded) {
            args = argsReplacement;
        }
        try {
            return method.invoke(this.target, args);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof CompletionException) {
                cause = cause.getCause();
            }
            if (cause instanceof ExceptionMapping.HandlerException) {
                ((ExceptionMapping.HandlerException)((Object)cause)).mapException(method);
                return null;
            }
            if (cause instanceof ResponseProcessingException) {
                ResponseProcessingException rpe = (ResponseProcessingException)cause;
                if ((cause = rpe.getCause()) instanceof RuntimeException) {
                    throw cause;
                }
            } else {
                if (cause instanceof ProcessingException && cause.getCause() instanceof ClientHeaderFillingException) {
                    throw cause.getCause().getCause();
                }
                if (cause instanceof RuntimeException) {
                    throw cause;
                }
            }
            throw e;
        }
    }

    private Object invokeRestClientProxyMethod(Object proxy, Method method, Object[] args) {
        switch (method.getName()) {
            case "getClient": {
                return this.client;
            }
            case "close": {
                this.close();
                return null;
            }
        }
        throw new IllegalStateException("Unsupported RestClientProxy method: " + method);
    }

    private void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.client.close();
        }
    }

    private Type[] getGenericTypes(Class<?> aClass) {
        Type[] genericInterfaces = aClass.getGenericInterfaces();
        Type[] genericTypes = NO_TYPES;
        for (Type genericInterface : genericInterfaces) {
            if (!(genericInterface instanceof ParameterizedType)) continue;
            genericTypes = ((ParameterizedType)genericInterface).getActualTypeArguments();
        }
        return genericTypes;
    }
}

