/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.faulttolerance.deployment;

import java.util.Optional;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.weld.WeldCapability;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.wildfly.extension.microprofile.faulttolerance.deployment.MicroProfileFaultToleranceMarker;

public class MicroProfileFaultToleranceDependenciesProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
        Optional weldCapability = support.getOptionalCapabilityRuntimeAPI("org.wildfly.weld", WeldCapability.class);
        if (weldCapability.isPresent() && ((WeldCapability)weldCapability.get()).isPartOfWeldDeployment(deploymentUnit) && MicroProfileFaultToleranceMarker.hasMicroProfileFaultToleranceAnnotations(deploymentUnit)) {
            MicroProfileFaultToleranceMarker.mark(deploymentUnit);
            ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
            ModuleLoader moduleLoader = Module.getBootModuleLoader();
            moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, "org.eclipse.microprofile.fault-tolerance.api", false, false, false, false));
            moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, "org.wildfly.microprofile.fault-tolerance-smallrye.deployment", false, false, true, false));
        }
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        MicroProfileFaultToleranceMarker.clearMark(deploymentUnit);
    }
}

