/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.instmgr.cli;

import java.io.File;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;
import org.wildfly.core.instmgr.InstMgrCustomPatchUploadHandler;
import org.wildfly.core.instmgr.cli.AbstractInstMgrCommand;
import org.wildfly.core.instmgr.cli.InstMgrActivator;

@CommandDefinition(name="upload-custom-patch", description="Uploads a custom patch Zip file to the server and subscribes the installation creating a channel to handle the patch.", activator=InstMgrActivator.class)
public class CustomPatchUploadCommand
extends AbstractInstMgrCommand {
    @Option(name="custom-patch-file", required=true)
    private File customPatch;
    @Option(name="manifest", required=true)
    private String manifestGA;

    @Override
    protected Operation buildOperation() throws CommandException {
        ModelNode op = new ModelNode();
        OperationBuilder operationBuilder = OperationBuilder.create((ModelNode)op);
        op.get("operation").set(InstMgrCustomPatchUploadHandler.DEFINITION.getName());
        op.get("manifest").set(this.manifestGA);
        op.get("custom-patch-file").set(0);
        operationBuilder.addFileAsAttachment(this.customPatch);
        return operationBuilder.build();
    }

    @Override
    public CommandResult execute(CLICommandInvocation commandInvocation) throws CommandException, InterruptedException {
        CommandContext ctx = commandInvocation.getCommandContext();
        ModelControllerClient client = ctx.getModelControllerClient();
        if (client == null) {
            ctx.printLine("You are disconnected at the moment. Type 'connect' to connect to the server or 'help' for the list of supported commands.");
            return CommandResult.FAILURE;
        }
        this.executeOp(ctx, this.host);
        ctx.printLine("Custom Patch successfully uploaded");
        return CommandResult.SUCCESS;
    }
}

