/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jbossatx.jta;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.objectstore.ObjectStoreAPI;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.state.InputBuffer;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import com.arjuna.ats.internal.jta.resources.arjunacore.XAResourceRecord;
import com.arjuna.ats.internal.jta.resources.arjunacore.XAResourceRecordWrappingPlugin;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.xa.XAResource;
import org.jboss.tm.XAResourceWrapper;

public class XAResourceRecordWrappingPluginImpl
implements XAResourceRecordWrappingPlugin {
    private ConcurrentMap<Integer, String> keyToName = new ConcurrentHashMap<Integer, String>();
    private ConcurrentMap<String, Integer> nameToKey = new ConcurrentHashMap<String, Integer>();
    private AtomicInteger nextKey = new AtomicInteger(1);
    private ObjectStoreAPI eisNameStore;
    private String nodeIdentifier;

    public void transcribeWrapperData(XAResourceRecord record) {
        XAResource xaResource = (XAResource)record.value();
        if (xaResource instanceof XAResourceWrapper) {
            XAResourceWrapper xaResourceWrapper = (XAResourceWrapper)xaResource;
            record.setProductName(xaResourceWrapper.getProductName());
            record.setProductVersion(xaResourceWrapper.getProductVersion());
            record.setJndiName(xaResourceWrapper.getJndiName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getEISName(XAResource xaResource) throws IOException, ObjectStoreException {
        if (xaResource instanceof XAResourceWrapper) {
            this.initialize();
            String jndiName = ((XAResourceWrapper)xaResource).getJndiName();
            Integer key = (Integer)this.nameToKey.get(jndiName);
            if (key == null) {
                XAResourceRecordWrappingPluginImpl xAResourceRecordWrappingPluginImpl = this;
                synchronized (xAResourceRecordWrappingPluginImpl) {
                    key = (Integer)this.nameToKey.get(jndiName);
                    if (key == null) {
                        key = this.nextKey.getAndIncrement();
                        this.keyToName.put(key, jndiName);
                        this.nameToKey.put(jndiName, key);
                        OutputObjectState oos = new OutputObjectState();
                        oos.packString(this.nodeIdentifier);
                        oos.packInt(key.intValue());
                        oos.packString(jndiName);
                        this.eisNameStore.write_committed(new Uid(), "EISNAME", oos);
                        this.eisNameStore.sync();
                    }
                }
            }
            return key;
        }
        return 0;
    }

    public String getEISName(Integer eisKey) {
        try {
            this.initialize();
        }
        catch (IOException ioe) {
            return "unloadable EIS key file: " + eisKey;
        }
        catch (ObjectStoreException e) {
            return "unloadable EIS key file: " + eisKey;
        }
        if (eisKey == 0) {
            return "unknown eis name";
        }
        if (eisKey == -1) {
            return "foreign XID";
        }
        String eisName = (String)this.keyToName.get(eisKey);
        if (eisName == null) {
            return "forgot eis name for: " + eisKey;
        }
        return eisName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws ObjectStoreException, IOException {
        if (this.nodeIdentifier == null) {
            XAResourceRecordWrappingPluginImpl xAResourceRecordWrappingPluginImpl = this;
            synchronized (xAResourceRecordWrappingPluginImpl) {
                if (this.nodeIdentifier == null) {
                    Uid uid;
                    this.nodeIdentifier = TxControl.getXANodeName();
                    this.eisNameStore = StoreManager.getEISNameStore();
                    InputObjectState states = new InputObjectState();
                    int keyMax = 0;
                    boolean allObjUids = this.eisNameStore.allObjUids("EISNAME", states);
                    while (states.notempty() && !(uid = UidHelper.unpackFrom((InputBuffer)states)).equals(Uid.nullUid())) {
                        InputObjectState oState = this.eisNameStore.read_committed(uid, "EISNAME");
                        String nodeName = oState.unpackString();
                        if (!nodeName.equals(this.nodeIdentifier)) continue;
                        Integer key = oState.unpackInt();
                        String jndiName = oState.unpackString();
                        this.keyToName.put(key, jndiName);
                        this.nameToKey.put(jndiName, key);
                        if (key <= keyMax) continue;
                        keyMax = key;
                    }
                    this.nextKey.set(keyMax + 1);
                }
            }
        }
    }
}

