/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.client;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.RemoteCacheManagerAdmin;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.operations.OperationsFactory;
import org.infinispan.client.hotrod.impl.operations.PingResponse;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.Marshaller;
import org.jboss.as.clustering.infinispan.client.ManagedRemoteCache;
import org.jboss.as.clustering.infinispan.dataconversion.MediaTypeFactory;
import org.jboss.modules.ModuleLoader;
import org.wildfly.clustering.Registrar;
import org.wildfly.clustering.infinispan.client.RemoteCacheContainer;
import org.wildfly.clustering.infinispan.marshalling.ByteBufferMarshallerFactory;
import org.wildfly.clustering.infinispan.marshalling.UserMarshaller;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ManagedRemoteCacheContainer
implements RemoteCacheContainer {
    private final RemoteCacheManager container;
    private final OperationsFactory factory;
    private final String name;
    private final Function<ClassLoader, ByteBufferMarshaller> marshallerFactory;
    private final Registrar<String> registrar;

    public ManagedRemoteCacheContainer(RemoteCacheManager container, String name, ModuleLoader loader, Registrar<String> registrar) {
        this.container = container;
        this.name = name;
        this.registrar = registrar;
        this.marshallerFactory = new ByteBufferMarshallerFactory(container.getConfiguration().marshaller().mediaType(), loader);
        this.factory = new OperationsFactory(container.getChannelFactory(), null, container.getConfiguration());
    }

    public String getName() {
        return this.name;
    }

    public RemoteCacheManagerAdmin administration() {
        return this.container.administration();
    }

    public CompletionStage<Boolean> isAvailable() {
        return this.factory.newFaultTolerantPingOperation().execute().thenApply(PingResponse::isSuccess);
    }

    public <K, V> RemoteCache<K, V> getCache() {
        return this.getCache("");
    }

    public <K, V> RemoteCache<K, V> getCache(String cacheName) {
        boolean overrideValueMarshaller;
        RemoteCache cache = this.container.getCache(cacheName);
        if (cache == null) {
            return null;
        }
        Marshaller defaultMarshaller = this.container.getMarshaller();
        DataFormat.Builder builder = DataFormat.builder().from(cache.getDataFormat()).keyType(defaultMarshaller.mediaType()).valueType(defaultMarshaller.mediaType());
        ClassLoader loader = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        Map.Entry<MediaType, MediaType> types = MediaTypeFactory.INSTANCE.apply(loader);
        boolean overrideKeyMarshaller = !types.getKey().equals((Object)MediaType.APPLICATION_OBJECT);
        boolean bl = overrideValueMarshaller = !types.getValue().equals((Object)MediaType.APPLICATION_OBJECT);
        if (overrideKeyMarshaller || overrideValueMarshaller) {
            UserMarshaller marshaller = new UserMarshaller(defaultMarshaller.mediaType(), this.marshallerFactory.apply(loader));
            if (overrideKeyMarshaller) {
                builder.keyType(marshaller.mediaType());
                builder.keyMarshaller((Marshaller)marshaller);
            }
            if (overrideValueMarshaller) {
                builder.valueType(marshaller.mediaType());
                builder.valueMarshaller((Marshaller)marshaller);
            }
        }
        return new ManagedRemoteCache(this, this.container, cache.withDataFormat(builder.build()), this.registrar);
    }

    public Configuration getConfiguration() {
        return this.container.getConfiguration();
    }

    public boolean isStarted() {
        return this.container.isStarted();
    }

    public boolean switchToCluster(String clusterName) {
        return this.container.switchToCluster(clusterName);
    }

    public boolean switchToDefaultCluster() {
        return this.container.switchToDefaultCluster();
    }

    public Marshaller getMarshaller() {
        return this.container.getMarshaller();
    }

    public boolean isTransactional(String cacheName) {
        return this.container.isTransactional(cacheName);
    }

    public Set<String> getCacheNames() {
        return this.container.getCacheNames();
    }

    public void start() {
    }

    public void stop() {
    }

    public String[] getServers() {
        return this.container.getServers();
    }

    public int getActiveConnectionCount() {
        return this.container.getActiveConnectionCount();
    }

    public int getConnectionCount() {
        return this.container.getConnectionCount();
    }

    public int getIdleConnectionCount() {
        return this.container.getIdleConnectionCount();
    }

    public long getRetries() {
        return this.container.getRetries();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof RemoteCacheContainer)) {
            return false;
        }
        RemoteCacheContainer container = (RemoteCacheContainer)object;
        return this.name.equals(container.getName());
    }

    public String toString() {
        return this.name;
    }
}

