/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session.coarse;

import java.io.NotSerializableException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.wildfly.clustering.ee.Immutability;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.marshalling.spi.Marshallability;
import org.wildfly.clustering.web.cache.session.SessionActivationNotifier;
import org.wildfly.clustering.web.cache.session.SessionAttributes;
import org.wildfly.clustering.web.cache.session.coarse.CoarseImmutableSessionAttributes;

public class CoarseSessionAttributes
extends CoarseImmutableSessionAttributes
implements SessionAttributes {
    private final Map<String, Object> attributes;
    private final Mutator mutator;
    private final Marshallability marshallability;
    private final Immutability immutability;
    private final CacheProperties properties;
    private final SessionActivationNotifier notifier;
    private final AtomicBoolean dirty = new AtomicBoolean(false);

    public CoarseSessionAttributes(Map<String, Object> attributes, Mutator mutator, Marshallability marshallability, Immutability immutability, CacheProperties properties, SessionActivationNotifier notifier) {
        super(attributes);
        this.attributes = attributes;
        this.mutator = mutator;
        this.marshallability = marshallability;
        this.immutability = immutability;
        this.properties = properties;
        this.notifier = notifier;
        if (this.notifier != null) {
            this.notifier.postActivate();
        }
    }

    public Object removeAttribute(String name) {
        Object value = this.attributes.remove(name);
        if (value != null) {
            this.dirty.set(true);
        }
        return value;
    }

    public Object setAttribute(String name, Object value) {
        if (value == null) {
            return this.removeAttribute(name);
        }
        if (this.properties.isMarshalling() && !this.marshallability.isMarshallable(value)) {
            throw new IllegalArgumentException(new NotSerializableException(value.getClass().getName()));
        }
        Object old = this.attributes.put(name, value);
        this.dirty.set(true);
        return old;
    }

    @Override
    public Object getAttribute(String name) {
        Object value = this.attributes.get(name);
        if (!this.immutability.test(value)) {
            this.dirty.set(true);
        }
        return value;
    }

    @Override
    public void close() {
        if (this.notifier != null) {
            this.notifier.prePassivate();
        }
        if (this.dirty.compareAndSet(true, false)) {
            this.mutator.mutate();
        }
    }
}

