/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.search.mapper.orm.event.impl.HibernateOrmListenerTypeContext;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmEntityIdEntityLoadingStrategy;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmEntityLoadingStrategy;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmNonEntityIdPropertyEntityLoadingStrategy;
import org.hibernate.search.mapper.orm.loading.impl.LoadingTypeContext;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSessionTypeContext;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeExtendedMappingCollector;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilter;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeContext;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;

abstract class AbstractHibernateOrmTypeContext<E>
implements PojoTypeContext<E>,
HibernateOrmListenerTypeContext,
HibernateOrmSessionTypeContext<E>,
LoadingTypeContext<E> {
    private final PojoRawTypeIdentifier<E> typeIdentifier;
    private final String jpaEntityName;
    private final EntityMappingType entityMappingType;
    private final boolean documentIdIsEntityId;
    private final HibernateOrmEntityLoadingStrategy<? super E, ?> loadingStrategy;
    private final PojoPathFilter dirtyFilter;
    private final PojoPathFilter dirtyContainingAssociationFilter;
    private final List<PojoRawTypeIdentifier<? super E>> ascendingSuperTypes;

    AbstractHibernateOrmTypeContext(AbstractBuilder<E> builder, SessionFactoryImplementor sessionFactory) {
        this.typeIdentifier = ((AbstractBuilder)builder).typeIdentifier;
        this.jpaEntityName = ((AbstractBuilder)builder).jpaEntityName;
        MappingMetamodelImplementor metamodel = sessionFactory.getMappingMetamodel();
        this.entityMappingType = metamodel.getEntityDescriptor(((AbstractBuilder)builder).hibernateOrmEntityName);
        this.ascendingSuperTypes = ((AbstractBuilder)builder).ascendingSuperTypes;
        if (((AbstractBuilder)builder).documentIdSourcePropertyName != null) {
            if (((AbstractBuilder)builder).documentIdSourcePropertyName.equals(this.entityMappingType().getIdentifierMapping().getAttributeName())) {
                this.documentIdIsEntityId = true;
                this.loadingStrategy = HibernateOrmEntityIdEntityLoadingStrategy.create(sessionFactory, this.entityMappingType());
            } else {
                this.documentIdIsEntityId = false;
                this.loadingStrategy = HibernateOrmNonEntityIdPropertyEntityLoadingStrategy.create(sessionFactory, this.entityMappingType, ((AbstractBuilder)builder).documentIdSourcePropertyName, ((AbstractBuilder)builder).documentIdSourcePropertyHandle);
            }
        } else {
            this.documentIdIsEntityId = false;
            this.loadingStrategy = null;
        }
        this.dirtyFilter = ((AbstractBuilder)builder).dirtyFilter;
        this.dirtyContainingAssociationFilter = ((AbstractBuilder)builder).dirtyContainingAssociationFilter;
    }

    public String toString() {
        return this.typeIdentifier().toString();
    }

    @Override
    public PojoRawTypeIdentifier<E> typeIdentifier() {
        return this.typeIdentifier;
    }

    @Override
    public String jpaEntityName() {
        return this.jpaEntityName;
    }

    public String hibernateOrmEntityName() {
        return this.entityMappingType.getEntityName();
    }

    @Override
    public EntityMappingType entityMappingType() {
        return this.entityMappingType;
    }

    @Override
    public HibernateOrmEntityLoadingStrategy<? super E, ?> loadingStrategy() {
        return this.loadingStrategy;
    }

    @Override
    public List<PojoRawTypeIdentifier<? super E>> ascendingSuperTypes() {
        return this.ascendingSuperTypes;
    }

    @Override
    public Object toIndexingPlanProvidedId(Object entityId) {
        if (this.documentIdIsEntityId) {
            return entityId;
        }
        return null;
    }

    @Override
    public PojoPathFilter dirtyFilter() {
        return this.dirtyFilter;
    }

    @Override
    public PojoPathFilter dirtyContainingAssociationFilter() {
        return this.dirtyContainingAssociationFilter;
    }

    static abstract class AbstractBuilder<E>
    implements PojoTypeExtendedMappingCollector {
        private final PojoRawTypeIdentifier<E> typeIdentifier;
        private final String jpaEntityName;
        private final String hibernateOrmEntityName;
        private String documentIdSourcePropertyName;
        private ValueReadHandle<?> documentIdSourcePropertyHandle;
        private PojoPathFilter dirtyFilter;
        private PojoPathFilter dirtyContainingAssociationFilter;
        private final List<PojoRawTypeIdentifier<? super E>> ascendingSuperTypes;

        AbstractBuilder(PojoRawTypeModel<E> typeModel, String jpaEntityName, String hibernateOrmEntityName) {
            this.typeIdentifier = typeModel.typeIdentifier();
            this.jpaEntityName = jpaEntityName;
            this.hibernateOrmEntityName = hibernateOrmEntityName;
            this.ascendingSuperTypes = typeModel.ascendingSuperTypes().map(PojoRawTypeModel::typeIdentifier).collect(Collectors.toList());
        }

        public void documentIdSourceProperty(PojoPropertyModel<?> documentIdSourceProperty) {
            this.documentIdSourcePropertyName = documentIdSourceProperty.name();
            this.documentIdSourcePropertyHandle = documentIdSourceProperty.handle();
        }

        public void dirtyFilter(PojoPathFilter dirtyFilter) {
            this.dirtyFilter = dirtyFilter;
        }

        public void dirtyContainingAssociationFilter(PojoPathFilter filter) {
            this.dirtyContainingAssociationFilter = filter;
        }
    }
}

