/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.remote;

import java.util.List;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.as.network.ClientMapping;
import org.wildfly.clustering.ejb.infinispan.network.ClientMappingsRegistryEntryServiceConfigurator;
import org.wildfly.clustering.ejb.remote.ClientMappingsRegistryProvider;
import org.wildfly.clustering.infinispan.service.CacheServiceConfigurator;
import org.wildfly.clustering.infinispan.service.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.service.TemplateConfigurationServiceConfigurator;
import org.wildfly.clustering.server.service.ProvidedCacheServiceConfigurator;
import org.wildfly.clustering.server.service.group.DistributedCacheGroupServiceConfiguratorProvider;
import org.wildfly.clustering.server.service.registry.DistributedRegistryServiceConfiguratorProvider;
import org.wildfly.clustering.service.SupplierDependency;

public class InfinispanClientMappingsRegistryProvider
implements ClientMappingsRegistryProvider {
    private final String containerName;
    private final String cacheName;

    public InfinispanClientMappingsRegistryProvider(String containerName, String cacheName) {
        this.containerName = containerName;
        this.cacheName = cacheName;
    }

    public Iterable<CapabilityServiceConfigurator> getServiceConfigurators(String connectorName, SupplierDependency<List<ClientMapping>> clientMappings) {
        TemplateConfigurationServiceConfigurator configurationConfigurator = new TemplateConfigurationServiceConfigurator(ServiceNameFactory.parseServiceName((String)InfinispanCacheRequirement.CONFIGURATION.getName()).append(new String[]{this.containerName, connectorName}), this.containerName, connectorName, this.cacheName);
        CacheServiceConfigurator cacheConfigurator = new CacheServiceConfigurator(ServiceNameFactory.parseServiceName((String)InfinispanCacheRequirement.CACHE.getName()).append(new String[]{this.containerName, connectorName}), this.containerName, connectorName);
        ClientMappingsRegistryEntryServiceConfigurator registryEntryConfigurator = new ClientMappingsRegistryEntryServiceConfigurator(this.containerName, connectorName, clientMappings);
        ProvidedCacheServiceConfigurator groupConfigurator = new ProvidedCacheServiceConfigurator(DistributedCacheGroupServiceConfiguratorProvider.class, this.containerName, connectorName);
        ProvidedCacheServiceConfigurator registryConfigurator = new ProvidedCacheServiceConfigurator(DistributedRegistryServiceConfiguratorProvider.class, this.containerName, connectorName);
        return List.of(configurationConfigurator, cacheConfigurator, registryEntryConfigurator, registryConfigurator, groupConfigurator);
    }
}

