/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.util.MdbValidityStatus;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;

public final class EjbValidationsUtil {
    private EjbValidationsUtil() {
    }

    public static Collection<MdbValidityStatus> assertEjbClassValidity(ClassInfo mdbClass) {
        ArrayList<MdbValidityStatus> mdbComplianceIssueList = new ArrayList<MdbValidityStatus>(MdbValidityStatus.values().length);
        String className = mdbClass.name().toString();
        EjbValidationsUtil.verifyModifiers(className, mdbClass.flags(), mdbComplianceIssueList);
        for (MethodInfo method : mdbClass.methods()) {
            if ("onMessage".equals(method.name())) {
                EjbValidationsUtil.verifyOnMessageMethod(className, method.flags(), mdbComplianceIssueList);
            }
            if (!"finalize".equals(method.name())) continue;
            EjbLogger.DEPLOYMENT_LOGGER.mdbCantHaveFinalizeMethod(className);
            mdbComplianceIssueList.add(MdbValidityStatus.MDB_SHOULD_NOT_HAVE_FINALIZE_METHOD);
        }
        return mdbComplianceIssueList;
    }

    private static void verifyModifiers(String className, short flags, Collection<MdbValidityStatus> mdbComplianceIssueList) {
        if (Modifier.isInterface(flags)) {
            EjbLogger.DEPLOYMENT_LOGGER.mdbClassCannotBeAnInterface(className);
            mdbComplianceIssueList.add(MdbValidityStatus.MDB_CANNOT_BE_AN_INTERFACE);
        }
        if (!Modifier.isPublic(flags) || Modifier.isAbstract(flags) || Modifier.isFinal(flags)) {
            EjbLogger.DEPLOYMENT_LOGGER.mdbClassMustBePublicNonAbstractNonFinal(className);
            mdbComplianceIssueList.add(MdbValidityStatus.MDB_CLASS_CANNOT_BE_PRIVATE_ABSTRACT_OR_FINAL);
        }
    }

    private static void verifyOnMessageMethod(String className, short methodsFlags, Collection<MdbValidityStatus> mdbComplianceIssueList) {
        if (Modifier.isFinal(methodsFlags)) {
            EjbLogger.DEPLOYMENT_LOGGER.mdbOnMessageMethodCantBeFinal(className);
            mdbComplianceIssueList.add(MdbValidityStatus.MDB_ON_MESSAGE_METHOD_CANT_BE_FINAL);
        }
        if (Modifier.isStatic(methodsFlags)) {
            EjbLogger.DEPLOYMENT_LOGGER.mdbOnMessageMethodCantBeStatic(className);
            mdbComplianceIssueList.add(MdbValidityStatus.MDB_ON_MESSAGE_METHOD_CANT_BE_STATIC);
        }
        if (Modifier.isPrivate(methodsFlags)) {
            EjbLogger.DEPLOYMENT_LOGGER.mdbOnMessageMethodCantBePrivate(className);
            mdbComplianceIssueList.add(MdbValidityStatus.MDB_ON_MESSAGE_METHOD_CANT_BE_PRIVATE);
        }
    }

    public static void verifyEjbClassAndDefaultConstructor(Constructor<?> ctor, Class<?> enclosingClass, boolean noInterface, String componentName, String componentClassname, int modifiers) throws DeploymentUnitProcessingException {
        if (ctor == null && noInterface) {
            throw EjbLogger.ROOT_LOGGER.ejbMustHavePublicDefaultConstructor(componentName, componentClassname);
        }
        if (enclosingClass != null) {
            throw EjbLogger.ROOT_LOGGER.ejbMustNotBeInnerClass(componentName, componentClassname);
        }
        if (!Modifier.isPublic(modifiers)) {
            throw EjbLogger.ROOT_LOGGER.ejbMustBePublicClass(componentName, componentClassname);
        }
        if (Modifier.isFinal(modifiers)) {
            throw EjbLogger.ROOT_LOGGER.ejbMustNotBeFinalClass(componentName, componentClassname);
        }
    }

    public static boolean verifyEjbPublicMethodAreNotFinalNorStatic(Method[] methods, String classname) {
        boolean isEjbCompliant = true;
        for (Method method : methods) {
            if (Object.class == method.getDeclaringClass() || EjbValidationsUtil.verifyMethodIsNotFinalNorStatic(method, classname)) continue;
            isEjbCompliant = false;
        }
        return isEjbCompliant;
    }

    public static boolean verifyMethodIsNotFinalNorStatic(Method method, String classname) {
        boolean isMethodCompliant = true;
        if (Modifier.isStatic(method.getModifiers()) || Modifier.isFinal(method.getModifiers())) {
            EjbLogger.ROOT_LOGGER.ejbMethodMustNotBeFinalNorStatic(classname, method.getName());
            isMethodCompliant = false;
        }
        return isMethodCompliant;
    }
}

