/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.instmgr;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipException;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.core.instmgr.AbstractInstMgrUpdateHandler;
import org.wildfly.core.instmgr.InstMgrResolver;
import org.wildfly.core.instmgr.InstMgrService;
import org.wildfly.core.instmgr.logging.InstMgrLogger;
import org.wildfly.installationmanager.MavenOptions;
import org.wildfly.installationmanager.Repository;
import org.wildfly.installationmanager.spi.InstallationManager;
import org.wildfly.installationmanager.spi.InstallationManagerFactory;

public class InstMgrPrepareRevertHandler
extends AbstractInstMgrUpdateHandler {
    public static final String OPERATION_NAME = "prepare-revert";
    private static final AttributeDefinition REVISION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"revision", (ModelType)ModelType.STRING).setRequired(true)).setStorageRuntime()).build();
    static final AttributeDefinition MAVEN_REPO_FILE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"maven-repo-file", (ModelType)ModelType.INT).setStorageRuntime()).setRequired(false)).setAlternatives(new String[]{"repositories"})).build();
    protected static final AttributeDefinition MAVEN_REPO_FILES = ((SimpleListAttributeDefinition.Builder)((SimpleListAttributeDefinition.Builder)((SimpleListAttributeDefinition.Builder)new SimpleListAttributeDefinition.Builder("maven-repo-files", MAVEN_REPO_FILE).setStorageRuntime()).setRequired(false)).setAlternatives(new String[]{"repositories"})).build();
    static final AttributeDefinition REPOSITORIES = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("repositories", REPOSITORY).setStorageRuntime()).setRequired(false)).setAlternatives(new String[]{"maven-repo-file"})).build();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("prepare-revert", InstMgrResolver.RESOLVER).addParameter(REVISION).addParameter(OFFLINE).addParameter(REPOSITORIES).addParameter((AttributeDefinition)LOCAL_CACHE).addParameter(NO_RESOLVE_LOCAL_CACHE).addParameter(MAVEN_REPO_FILES).withFlags(new OperationEntry.Flag[]{OperationEntry.Flag.HOST_CONTROLLER_ONLY}).setRuntimeOnly().build();

    InstMgrPrepareRevertHandler(InstMgrService imService, InstallationManagerFactory imf) {
        super(imService, imf);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final boolean offline = OFFLINE.resolveModelAttribute(context, operation).asBoolean(false);
        String pathLocalRepo = LOCAL_CACHE.resolveModelAttribute(context, operation).asStringOrNull();
        final boolean noResolveLocalCache = NO_RESOLVE_LOCAL_CACHE.resolveModelAttribute(context, operation).asBoolean(false);
        final Path localRepository = pathLocalRepo != null ? Path.of(pathLocalRepo, new String[0]) : null;
        final List mavenRepoFileIndexes = MAVEN_REPO_FILES.resolveModelAttribute(context, operation).asListOrEmpty();
        final List repositoriesMn = REPOSITORIES.resolveModelAttribute(context, operation).asListOrEmpty();
        final String revision = REVISION.resolveModelAttribute(context, operation).asString();
        if (pathLocalRepo != null && noResolveLocalCache) {
            throw InstMgrLogger.ROOT_LOGGER.localCacheWithNoResolveLocalCache();
        }
        if (!mavenRepoFileIndexes.isEmpty() && !repositoriesMn.isEmpty()) {
            throw InstMgrLogger.ROOT_LOGGER.mavenRepoFileWithRepositories();
        }
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                context.acquireControllerLock();
                if (!InstMgrPrepareRevertHandler.this.imService.canPrepareServer()) {
                    throw InstMgrLogger.ROOT_LOGGER.serverAlreadyPrepared();
                }
                try {
                    InstMgrPrepareRevertHandler.this.imService.beginCandidateServer();
                    InstMgrPrepareRevertHandler.this.addCompleteStep(context, InstMgrPrepareRevertHandler.this.imService, null);
                    Path homeDir = InstMgrPrepareRevertHandler.this.imService.getHomeDir();
                    MavenOptions mavenOptions = new MavenOptions(localRepository, noResolveLocalCache, offline);
                    InstallationManager im = InstMgrPrepareRevertHandler.this.imf.create(homeDir, mavenOptions);
                    ArrayList<Repository> repositories = new ArrayList<Repository>();
                    if (!mavenRepoFileIndexes.isEmpty()) {
                        InstMgrLogger.ROOT_LOGGER.debug("Adding possible custom patch repositories");
                        repositories.addAll(InstMgrPrepareRevertHandler.this.retrieveAllCustomPatchRepositories(im));
                        InstMgrLogger.ROOT_LOGGER.debug("Preparing a server candidate to revert by using Operation Streams");
                        Path preparationWorkDir = InstMgrPrepareRevertHandler.this.imService.createTempDir("prepare-revert-");
                        InstMgrPrepareRevertHandler.this.addCompleteStep(context, InstMgrPrepareRevertHandler.this.imService, preparationWorkDir.getFileName().toString());
                        repositories.addAll(InstMgrPrepareRevertHandler.this.getRepositoriesFromOperationStreams(context, mavenRepoFileIndexes, preparationWorkDir));
                    } else {
                        repositories.addAll(InstMgrPrepareRevertHandler.this.toRepositories(context, repositoriesMn));
                    }
                    InstMgrLogger.ROOT_LOGGER.debugf("Calling SPI to prepare an revert at [%s] with the following repositories [%s] and revision [%s]", InstMgrPrepareRevertHandler.this.imService.getPreparedServerDir(), repositories, revision);
                    Files.createDirectories(InstMgrPrepareRevertHandler.this.imService.getPreparedServerDir(), new FileAttribute[0]);
                    im.prepareRevert(revision, InstMgrPrepareRevertHandler.this.imService.getPreparedServerDir(), repositories);
                    String applyRevert = im.generateApplyRevertCommand(homeDir.resolve("bin"), InstMgrPrepareRevertHandler.this.imService.getPreparedServerDir(), AbstractInstMgrUpdateHandler.getOsShell());
                    InstMgrLogger.ROOT_LOGGER.debug("Apply Revert Command: " + applyRevert);
                    InstMgrPrepareRevertHandler.this.imService.commitCandidateServer(applyRevert);
                    context.getResult().set(InstMgrPrepareRevertHandler.this.imService.getPreparedServerDir().normalize().toAbsolutePath().toString());
                }
                catch (ZipException e) {
                    throw new OperationFailedException(e.getLocalizedMessage());
                }
                catch (RuntimeException | OperationFailedException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, OperationContext.Stage.RUNTIME);
    }

    private void addCompleteStep(OperationContext context, final InstMgrService imService, final String mavenRepoParentWorkdir) {
        context.completeStep(new OperationContext.ResultHandler(){

            public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                try {
                    imService.deleteTempDir(mavenRepoParentWorkdir);
                    if (resultAction == OperationContext.ResultAction.ROLLBACK) {
                        imService.resetCandidateStatus();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

