/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.instmgr;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.core.instmgr.InstMgrOperationStepHandler;
import org.wildfly.core.instmgr.InstMgrService;
import org.wildfly.core.instmgr.logging.InstMgrLogger;
import org.wildfly.installationmanager.spi.InstallationManagerFactory;

abstract class InstMgrCustomPatchHandler
extends InstMgrOperationStepHandler {
    protected static final AttributeDefinition MANIFEST_GA = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("manifest", ModelType.STRING).setStorageRuntime()).setRequired(true)).setValidator((ParameterValidator)new ManifestValidator())).build();

    public InstMgrCustomPatchHandler(InstMgrService imService, InstallationManagerFactory imf) {
        super(imService, imf);
    }

    protected static class ManifestValidator
    implements ParameterValidator {
        protected ManifestValidator() {
        }

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            String manifestGA = value.asStringOrNull();
            if (manifestGA != null) {
                String[] parts;
                if (manifestGA.contains("\\") || manifestGA.contains("/")) {
                    throw InstMgrLogger.ROOT_LOGGER.invalidManifestGAV(manifestGA);
                }
                for (String part : parts = manifestGA.split(":")) {
                    if (part != null && !"".equals(part)) continue;
                    throw InstMgrLogger.ROOT_LOGGER.invalidManifestGAV(manifestGA);
                }
                if (parts.length != 2) {
                    throw InstMgrLogger.ROOT_LOGGER.invalidManifestGAOnly(manifestGA);
                }
            }
        }
    }
}

