/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.model.ast;

import java.util.List;
import java.util.function.BiConsumer;
import org.hibernate.jdbc.Expectation;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.ast.AbstractTableMutation;
import org.hibernate.sql.model.ast.ColumnValueBinding;
import org.hibernate.sql.model.ast.ColumnValueParameter;
import org.hibernate.sql.model.ast.MutatingTableReference;
import org.hibernate.sql.model.ast.TableInsert;
import org.hibernate.sql.model.jdbc.JdbcInsertMutation;

public abstract class AbstractTableInsert
extends AbstractTableMutation<JdbcInsertMutation>
implements TableInsert {
    private final List<ColumnValueBinding> valueBindings;

    public AbstractTableInsert(MutatingTableReference mutatingTable, MutationTarget<?> mutationTarget, List<ColumnValueParameter> parameters, List<ColumnValueBinding> valueBindings) {
        this(mutatingTable, mutationTarget, "insert for " + mutationTarget.getRolePath(), parameters, valueBindings);
    }

    public AbstractTableInsert(MutatingTableReference mutatingTable, MutationTarget<?> mutationTarget, String comment, List<ColumnValueParameter> parameters, List<ColumnValueBinding> valueBindings) {
        super(mutatingTable, mutationTarget, comment, parameters);
        this.valueBindings = valueBindings;
    }

    @Override
    protected String getLoggableName() {
        return "TableInsert";
    }

    @Override
    public Expectation getExpectation() {
        return this.getMutatingTable().getTableMapping().getInsertDetails().getExpectation();
    }

    @Override
    public List<ColumnValueBinding> getValueBindings() {
        return this.valueBindings;
    }

    @Override
    public void forEachValueBinding(BiConsumer<Integer, ColumnValueBinding> consumer) {
        AbstractTableInsert.forEachThing(this.valueBindings, consumer);
    }

    @Override
    protected JdbcInsertMutation createMutationOperation(TableMapping tableDetails, String sql, List<JdbcParameterBinder> effectiveBinders) {
        return new JdbcInsertMutation(tableDetails, this.getMutationTarget(), sql, this.isCallable(), this.getExpectation(), effectiveBinders);
    }
}

