/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.subsystem;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.txn.subsystem.LogStoreConstants;
import org.jboss.as.txn.subsystem.LogStoreParticipantDeleteHandler;
import org.jboss.as.txn.subsystem.LogStoreParticipantRecoveryHandler;
import org.jboss.as.txn.subsystem.LogStoreParticipantRefreshHandler;
import org.jboss.as.txn.subsystem.LogStoreProbeHandler;
import org.jboss.as.txn.subsystem.TransactionExtension;

public class LogStoreTransactionParticipantDefinition
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition[] PARTICIPANT_ATTRIBUTES = new SimpleAttributeDefinition[]{LogStoreConstants.JMX_NAME, LogStoreConstants.PARTICIPANT_JNDI_NAME, LogStoreConstants.PARTICIPANT_STATUS, LogStoreConstants.RECORD_TYPE, LogStoreConstants.EIS_NAME, LogStoreConstants.EIS_VERSION};

    LogStoreTransactionParticipantDefinition() {
        super(new SimpleResourceDefinition.Parameters(TransactionExtension.PARTICIPANT_PATH, (ResourceDescriptionResolver)TransactionExtension.getResourceDescriptionResolver("log-store", "transaction", "participant")).setRuntime());
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        LogStoreParticipantRefreshHandler refreshHandler = LogStoreParticipantRefreshHandler.INSTANCE;
        LogStoreProbeHandler probeHandler = LogStoreProbeHandler.INSTANCE;
        resourceRegistration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("refresh", this.getResourceDescriptionResolver()).build(), (OperationStepHandler)refreshHandler);
        resourceRegistration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("recover", this.getResourceDescriptionResolver()).build(), (OperationStepHandler)new LogStoreParticipantRecoveryHandler(refreshHandler));
        resourceRegistration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("delete", this.getResourceDescriptionResolver()).build(), (OperationStepHandler)new LogStoreParticipantDeleteHandler(probeHandler));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (SimpleAttributeDefinition attribute : PARTICIPANT_ATTRIBUTES) {
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)attribute, null);
        }
    }
}

