/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.connector.metadata.api.common.Credential;
import org.jboss.as.connector.metadata.api.ds.DsSecurity;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.subsystems.datasources.Namespace;
import org.jboss.as.connector.util.AbstractParser;
import org.jboss.as.connector.util.ParserException;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.Capacity;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DataSources;
import org.jboss.jca.common.api.metadata.ds.Driver;
import org.jboss.jca.common.api.metadata.ds.DsPool;
import org.jboss.jca.common.api.metadata.ds.DsXaPool;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.logging.Messages;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class DsParser
extends AbstractParser {
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);

    public void parse(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentAddress) throws Exception {
        int iterate;
        try {
            iterate = reader.nextTag();
        }
        catch (XMLStreamException e) {
            iterate = reader.nextTag();
        }
        block1 : switch (iterate) {
            case 2: {
                break;
            }
            case 1: {
                switch (Tag.forName(reader.getLocalName())) {
                    case DATASOURCES: {
                        this.parseDataSources(reader, list, parentAddress);
                        break block1;
                    }
                }
                throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void parseDataSources(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentAddress) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Tag.forName(reader.getLocalName()) == Tag.DATASOURCES) {
                        return;
                    }
                }
                case 1: {
                    switch (DataSources.Tag.forName((String)reader.getLocalName())) {
                        case DATASOURCE: {
                            switch (Namespace.forUri(reader.getNamespaceURI())) {
                                case DATASOURCES_1_1: 
                                case DATASOURCES_2_0: {
                                    this.parseDataSource_1_0(reader, list, parentAddress);
                                    break block0;
                                }
                                case DATASOURCES_1_2: {
                                    this.parseDataSource_1_2(reader, list, parentAddress);
                                    break block0;
                                }
                                case DATASOURCES_3_0: {
                                    this.parseDataSource_3_0(reader, list, parentAddress);
                                    break block0;
                                }
                                case DATASOURCES_4_0: {
                                    this.parseDataSource_4_0(reader, list, parentAddress);
                                    break block0;
                                }
                            }
                            this.parseDataSource_7_0(reader, list, parentAddress);
                            break block0;
                        }
                        case XA_DATASOURCE: {
                            switch (Namespace.forUri(reader.getNamespaceURI())) {
                                case DATASOURCES_1_1: 
                                case DATASOURCES_2_0: {
                                    this.parseXADataSource_1_0(reader, list, parentAddress);
                                    break block0;
                                }
                                case DATASOURCES_1_2: {
                                    this.parseXADataSource_1_2(reader, list, parentAddress);
                                    break block0;
                                }
                                case DATASOURCES_3_0: {
                                    this.parseXADataSource_3_0(reader, list, parentAddress);
                                    break block0;
                                }
                                case DATASOURCES_4_0: {
                                    this.parseXADataSource_4_0(reader, list, parentAddress);
                                    break block0;
                                }
                            }
                            this.parseXADataSource_7_0(reader, list, parentAddress);
                            break block0;
                        }
                        case DRIVERS: {
                            break block0;
                        }
                        case DRIVER: {
                            this.parseDriver(reader, list, parentAddress);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseDataSource_1_2(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentAddress) throws XMLStreamException, ParserException, ValidateException {
        String value;
        String poolName = null;
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        boolean enabled = Defaults.ENABLED;
        boolean persistEnabled = true;
        int count = reader.getAttributeCount();
        block30: for (int i = 0; i < count; ++i) {
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            DataSource.Attribute attribute = DataSource.Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.ENABLED.getXmlName());
                    if (value == null) continue block30;
                    enabled = Boolean.parseBoolean(value);
                    persistEnabled = true;
                    continue block30;
                }
                case JNDI_NAME: {
                    String jndiName = this.rawAttributeText((XMLStreamReader)reader, org.jboss.as.connector.subsystems.common.jndi.Constants.JNDI_NAME.getXmlName());
                    org.jboss.as.connector.subsystems.common.jndi.Constants.JNDI_NAME.parseAndSetParameter(jndiName, operation, (XMLStreamReader)reader);
                    continue block30;
                }
                case POOL_NAME: {
                    poolName = this.rawAttributeText((XMLStreamReader)reader, "pool-name");
                    continue block30;
                }
                case USE_JAVA_CONTEXT: {
                    value = this.rawAttributeText((XMLStreamReader)reader, org.jboss.as.connector.subsystems.common.jndi.Constants.USE_JAVA_CONTEXT.getXmlName());
                    if (value == null) continue block30;
                    org.jboss.as.connector.subsystems.common.jndi.Constants.USE_JAVA_CONTEXT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block30;
                }
                case SPY: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.SPY.getXmlName());
                    if (value == null) continue block30;
                    Constants.SPY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block30;
                }
                case USE_CCM: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.USE_CCM.getXmlName());
                    if (value == null) continue block30;
                    Constants.USE_CCM.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block30;
                }
                case JTA: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.JTA.getXmlName());
                    if (value == null) continue block30;
                    Constants.JTA.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block30;
                }
                case CONNECTABLE: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.CONNECTABLE.getXmlName());
                    if (value == null) continue block30;
                    Constants.CONNECTABLE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block30;
                }
                default: {
                    if (Constants.STATISTICS_ENABLED.getName().equals(reader.getAttributeLocalName(i))) {
                        value = this.rawAttributeText((XMLStreamReader)reader, Constants.STATISTICS_ENABLED.getXmlName());
                        if (value == null) continue block30;
                        Constants.STATISTICS_ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                        continue block30;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ModelNode dsAddress = parentAddress.clone();
        dsAddress.add("data-source", poolName);
        dsAddress.protect();
        operation.get("address").set(dsAddress);
        ArrayList<ModelNode> configPropertiesOperations = new ArrayList<ModelNode>(0);
        while (reader.hasNext()) {
            block10 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSources.Tag.forName((String)reader.getLocalName()) == DataSources.Tag.DATASOURCE) {
                        list.add(operation);
                        list.addAll(configPropertiesOperations);
                        if (enabled) {
                            ModelNode enableOperation = new ModelNode();
                            enableOperation.get("operation").set("enable");
                            enableOperation.get("address").set(dsAddress);
                            enableOperation.get("persistent").set(persistEnabled);
                            list.add(enableOperation);
                        }
                        return;
                    }
                    if (DataSource.Tag.forName((String)reader.getLocalName()) != DataSource.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (DataSource.Tag.forName((String)reader.getLocalName())) {
                        case CONNECTION_PROPERTY: {
                            String name = this.rawAttributeText((XMLStreamReader)reader, "name");
                            String value2 = this.rawElementText((XMLStreamReader)reader);
                            ModelNode configOperation = new ModelNode();
                            configOperation.get("operation").set("add");
                            ModelNode configAddress = dsAddress.clone();
                            configAddress.add(Constants.CONNECTION_PROPERTIES.getName(), name);
                            configAddress.protect();
                            configOperation.get("address").set(configAddress);
                            Constants.CONNECTION_PROPERTY_VALUE.parseAndSetParameter(value2, configOperation, (XMLStreamReader)reader);
                            configPropertiesOperations.add(configOperation);
                            break block10;
                        }
                        case CONNECTION_URL: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.CONNECTION_URL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block10;
                        }
                        case DRIVER_CLASS: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DRIVER_CLASS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block10;
                        }
                        case DATASOURCE_CLASS: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DATASOURCE_CLASS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block10;
                        }
                        case DRIVER: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DATASOURCE_DRIVER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block10;
                        }
                        case POOL: {
                            this.parsePool(reader, operation);
                            break block10;
                        }
                        case NEW_CONNECTION_SQL: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.NEW_CONNECTION_SQL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block10;
                        }
                        case URL_DELIMITER: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.URL_DELIMITER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block10;
                        }
                        case URL_SELECTOR_STRATEGY_CLASS_NAME: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.URL_SELECTOR_STRATEGY_CLASS_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block10;
                        }
                        case TRANSACTION_ISOLATION: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.TRANSACTION_ISOLATION.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block10;
                        }
                        case SECURITY: {
                            this.parseDsSecurity(reader, operation);
                            break block10;
                        }
                        case STATEMENT: {
                            this.parseStatementSettings(reader, operation);
                            break block10;
                        }
                        case TIMEOUT: {
                            this.parseTimeOutSettings(reader, operation);
                            break block10;
                        }
                        case VALIDATION: {
                            this.parseValidationSettings(reader, operation);
                            break block10;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseXADataSource_1_2(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentAddress) throws XMLStreamException, ParserException, ValidateException {
        String value;
        String poolName = null;
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        boolean enabled = Defaults.ENABLED;
        boolean persistEnabled = true;
        int count = reader.getAttributeCount();
        block27: for (int i = 0; i < count; ++i) {
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            XaDataSource.Attribute attribute = XaDataSource.Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.ENABLED.getXmlName());
                    if (value == null) continue block27;
                    enabled = Boolean.parseBoolean(value);
                    persistEnabled = true;
                    continue block27;
                }
                case JNDI_NAME: {
                    String jndiName = this.rawAttributeText((XMLStreamReader)reader, org.jboss.as.connector.subsystems.common.jndi.Constants.JNDI_NAME.getXmlName());
                    org.jboss.as.connector.subsystems.common.jndi.Constants.JNDI_NAME.parseAndSetParameter(jndiName, operation, (XMLStreamReader)reader);
                    continue block27;
                }
                case POOL_NAME: {
                    poolName = this.rawAttributeText((XMLStreamReader)reader, "pool-name");
                    continue block27;
                }
                case USE_JAVA_CONTEXT: {
                    value = this.rawAttributeText((XMLStreamReader)reader, org.jboss.as.connector.subsystems.common.jndi.Constants.USE_JAVA_CONTEXT.getXmlName());
                    if (value == null) continue block27;
                    org.jboss.as.connector.subsystems.common.jndi.Constants.USE_JAVA_CONTEXT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block27;
                }
                case SPY: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.SPY.getXmlName());
                    if (value == null) continue block27;
                    Constants.SPY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block27;
                }
                case USE_CCM: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.USE_CCM.getXmlName());
                    if (value == null) continue block27;
                    Constants.USE_CCM.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block27;
                }
                default: {
                    if (Constants.STATISTICS_ENABLED.getName().equals(reader.getAttributeLocalName(i))) {
                        value = this.rawAttributeText((XMLStreamReader)reader, Constants.STATISTICS_ENABLED.getXmlName());
                        if (value == null) continue block27;
                        Constants.STATISTICS_ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                        continue block27;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ModelNode dsAddress = parentAddress.clone();
        dsAddress.add("xa-data-source", poolName);
        dsAddress.protect();
        operation.get("address").set(dsAddress);
        ArrayList<ModelNode> xadatasourcePropertiesOperations = new ArrayList<ModelNode>(0);
        while (reader.hasNext()) {
            block8 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSources.Tag.forName((String)reader.getLocalName()) == DataSources.Tag.XA_DATASOURCE) {
                        list.add(operation);
                        list.addAll(xadatasourcePropertiesOperations);
                        if (enabled) {
                            ModelNode enableOperation = new ModelNode();
                            enableOperation.get("operation").set("enable");
                            enableOperation.get("address").set(dsAddress);
                            enableOperation.get("persistent").set(persistEnabled);
                            list.add(enableOperation);
                        }
                        return;
                    }
                    if (XaDataSource.Tag.forName((String)reader.getLocalName()) != XaDataSource.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (XaDataSource.Tag.forName((String)reader.getLocalName())) {
                        case XA_DATASOURCE_PROPERTY: {
                            String name = this.rawAttributeText((XMLStreamReader)reader, "name");
                            String value2 = this.rawElementText((XMLStreamReader)reader);
                            ModelNode configOperation = new ModelNode();
                            configOperation.get("operation").set("add");
                            ModelNode configAddress = dsAddress.clone();
                            configAddress.add(Constants.XADATASOURCE_PROPERTIES.getName(), name);
                            configAddress.protect();
                            configOperation.get("address").set(configAddress);
                            Constants.XADATASOURCE_PROPERTY_VALUE.parseAndSetParameter(value2, configOperation, (XMLStreamReader)reader);
                            xadatasourcePropertiesOperations.add(configOperation);
                            break block8;
                        }
                        case XA_DATASOURCE_CLASS: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.XA_DATASOURCE_CLASS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block8;
                        }
                        case DRIVER: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DATASOURCE_DRIVER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block8;
                        }
                        case XA_POOL: {
                            this.parseXaPool(reader, operation);
                            break block8;
                        }
                        case NEW_CONNECTION_SQL: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.NEW_CONNECTION_SQL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block8;
                        }
                        case URL_DELIMITER: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.URL_DELIMITER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block8;
                        }
                        case URL_SELECTOR_STRATEGY_CLASS_NAME: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.URL_SELECTOR_STRATEGY_CLASS_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block8;
                        }
                        case TRANSACTION_ISOLATION: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.TRANSACTION_ISOLATION.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block8;
                        }
                        case SECURITY: {
                            this.parseDsSecurity(reader, operation);
                            break block8;
                        }
                        case STATEMENT: {
                            this.parseStatementSettings(reader, operation);
                            break block8;
                        }
                        case TIMEOUT: {
                            this.parseTimeOutSettings(reader, operation);
                            break block8;
                        }
                        case VALIDATION: {
                            this.parseValidationSettings(reader, operation);
                            break block8;
                        }
                        case RECOVERY: {
                            this.parseRecovery(reader, operation);
                            break block8;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseDriver(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentAddress) throws XMLStreamException, ParserException, ValidateException {
        ModelNode driverAddress = parentAddress.clone();
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        String driverName = null;
        block15: for (Driver.Attribute attribute : Driver.Attribute.values()) {
            switch (attribute) {
                case NAME: {
                    driverName = this.rawAttributeText((XMLStreamReader)reader, attribute.getLocalName());
                    continue block15;
                }
                case MAJOR_VERSION: {
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.DRIVER_MAJOR_VERSION.getXmlName());
                    Constants.DRIVER_MAJOR_VERSION.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block15;
                }
                case MINOR_VERSION: {
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.DRIVER_MINOR_VERSION.getXmlName());
                    Constants.DRIVER_MINOR_VERSION.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block15;
                }
                case MODULE: {
                    String moduleName = this.rawAttributeText((XMLStreamReader)reader, Constants.DRIVER_MODULE_NAME.getXmlName());
                    String slot = null;
                    int slotId = this.findSlot(moduleName);
                    if (slotId != -1) {
                        slot = moduleName.substring(slotId + 1);
                        moduleName = moduleName.substring(0, slotId);
                    }
                    Constants.DRIVER_MODULE_NAME.parseAndSetParameter(moduleName, operation, (XMLStreamReader)reader);
                    if (slot == null) continue block15;
                    Constants.MODULE_SLOT.parseAndSetParameter(slot, operation, (XMLStreamReader)reader);
                    continue block15;
                }
            }
        }
        driverAddress.add("jdbc-driver", driverName);
        driverAddress.protect();
        operation.get("address").set(driverAddress);
        boolean driverClassMatched = false;
        boolean xaDatasourceClassMatched = false;
        boolean datasourceClassMatched = false;
        while (reader.hasNext()) {
            block6 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSources.Tag.forName((String)reader.getLocalName()) == DataSources.Tag.DRIVER) {
                        list.add(operation);
                        return;
                    }
                    if (Driver.Tag.forName((String)reader.getLocalName()) != Driver.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (Driver.Tag.forName((String)reader.getLocalName())) {
                        case DATASOURCE_CLASS: {
                            if (datasourceClassMatched) {
                                throw new ParserException(bundle.unexpectedElement(Constants.DRIVER_DATASOURCE_CLASS_NAME.getXmlName()));
                            }
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DRIVER_DATASOURCE_CLASS_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            datasourceClassMatched = true;
                            break block6;
                        }
                        case XA_DATASOURCE_CLASS: {
                            if (xaDatasourceClassMatched) {
                                throw new ParserException(bundle.unexpectedElement(Constants.DRIVER_XA_DATASOURCE_CLASS_NAME.getXmlName()));
                            }
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DRIVER_XA_DATASOURCE_CLASS_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            xaDatasourceClassMatched = true;
                            break block6;
                        }
                        case DRIVER_CLASS: {
                            if (driverClassMatched) {
                                throw new ParserException(bundle.unexpectedElement(Constants.DRIVER_CLASS_NAME.getXmlName()));
                            }
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DRIVER_CLASS_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            driverClassMatched = true;
                            break block6;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseXADataSource_1_0(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentAddress) throws XMLStreamException, ParserException, ValidateException {
        String value;
        String poolName = null;
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        int count = reader.getAttributeCount();
        block28: for (int i = 0; i < count; ++i) {
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            XaDataSource.Attribute attribute = XaDataSource.Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.ENABLED.getXmlName());
                    if (value == null) continue block28;
                    Constants.ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block28;
                }
                case JNDI_NAME: {
                    String jndiName = this.rawAttributeText((XMLStreamReader)reader, org.jboss.as.connector.subsystems.common.jndi.Constants.JNDI_NAME.getXmlName());
                    org.jboss.as.connector.subsystems.common.jndi.Constants.JNDI_NAME.parseAndSetParameter(jndiName, operation, (XMLStreamReader)reader);
                    continue block28;
                }
                case POOL_NAME: {
                    poolName = this.rawAttributeText((XMLStreamReader)reader, "pool-name");
                    continue block28;
                }
                case USE_JAVA_CONTEXT: {
                    value = this.rawAttributeText((XMLStreamReader)reader, org.jboss.as.connector.subsystems.common.jndi.Constants.USE_JAVA_CONTEXT.getXmlName());
                    if (value == null) continue block28;
                    org.jboss.as.connector.subsystems.common.jndi.Constants.USE_JAVA_CONTEXT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block28;
                }
                case SPY: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.SPY.getXmlName());
                    if (value == null) continue block28;
                    Constants.SPY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block28;
                }
                case USE_CCM: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.USE_CCM.getXmlName());
                    if (value == null) continue block28;
                    Constants.USE_CCM.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block28;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ModelNode dsAddress = parentAddress.clone();
        dsAddress.add("xa-data-source", poolName);
        dsAddress.protect();
        operation.get("address").set(dsAddress);
        ArrayList<ModelNode> xadatasourcePropertiesOperations = new ArrayList<ModelNode>(0);
        while (reader.hasNext()) {
            block8 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSources.Tag.forName((String)reader.getLocalName()) == DataSources.Tag.XA_DATASOURCE) {
                        list.add(operation);
                        list.addAll(xadatasourcePropertiesOperations);
                        return;
                    }
                    if (XaDataSource.Tag.forName((String)reader.getLocalName()) != XaDataSource.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (XaDataSource.Tag.forName((String)reader.getLocalName())) {
                        case XA_DATASOURCE_PROPERTY: {
                            String name = this.rawAttributeText((XMLStreamReader)reader, "name");
                            String value2 = this.rawElementText((XMLStreamReader)reader);
                            ModelNode configOperation = new ModelNode();
                            configOperation.get("operation").set("add");
                            ModelNode configAddress = dsAddress.clone();
                            configAddress.add(Constants.XADATASOURCE_PROPERTIES.getName(), name);
                            configAddress.protect();
                            configOperation.get("address").set(configAddress);
                            Constants.XADATASOURCE_PROPERTY_VALUE.parseAndSetParameter(value2, configOperation, (XMLStreamReader)reader);
                            xadatasourcePropertiesOperations.add(configOperation);
                            break block8;
                        }
                        case XA_DATASOURCE_CLASS: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.XA_DATASOURCE_CLASS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block8;
                        }
                        case DRIVER: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DATASOURCE_DRIVER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block8;
                        }
                        case XA_POOL: {
                            this.parseXaPool(reader, operation);
                            break block8;
                        }
                        case NEW_CONNECTION_SQL: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.NEW_CONNECTION_SQL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block8;
                        }
                        case URL_DELIMITER: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.URL_DELIMITER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block8;
                        }
                        case URL_PROPERTY: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.URL_PROPERTY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block8;
                        }
                        case URL_SELECTOR_STRATEGY_CLASS_NAME: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.URL_SELECTOR_STRATEGY_CLASS_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block8;
                        }
                        case TRANSACTION_ISOLATION: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.TRANSACTION_ISOLATION.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block8;
                        }
                        case SECURITY: {
                            this.parseDsSecurity(reader, operation);
                            break block8;
                        }
                        case STATEMENT: {
                            this.parseStatementSettings(reader, operation);
                            break block8;
                        }
                        case TIMEOUT: {
                            this.parseTimeOutSettings(reader, operation);
                            break block8;
                        }
                        case VALIDATION: {
                            this.parseValidationSettings(reader, operation);
                            break block8;
                        }
                        case RECOVERY: {
                            this.parseRecovery(reader, operation);
                            break block8;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseXADataSource_3_0(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentAddress) throws XMLStreamException, ParserException, ValidateException {
        String value;
        String poolName = null;
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        int count = reader.getAttributeCount();
        block30: for (int i = 0; i < count; ++i) {
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            XaDataSource.Attribute attribute = XaDataSource.Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.ENABLED.getXmlName());
                    if (value == null) continue block30;
                    Constants.ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block30;
                }
                case JNDI_NAME: {
                    String jndiName = this.rawAttributeText((XMLStreamReader)reader, org.jboss.as.connector.subsystems.common.jndi.Constants.JNDI_NAME.getXmlName());
                    org.jboss.as.connector.subsystems.common.jndi.Constants.JNDI_NAME.parseAndSetParameter(jndiName, operation, (XMLStreamReader)reader);
                    continue block30;
                }
                case POOL_NAME: {
                    poolName = this.rawAttributeText((XMLStreamReader)reader, "pool-name");
                    continue block30;
                }
                case USE_JAVA_CONTEXT: {
                    value = this.rawAttributeText((XMLStreamReader)reader, org.jboss.as.connector.subsystems.common.jndi.Constants.USE_JAVA_CONTEXT.getXmlName());
                    if (value == null) continue block30;
                    org.jboss.as.connector.subsystems.common.jndi.Constants.USE_JAVA_CONTEXT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block30;
                }
                case SPY: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.SPY.getXmlName());
                    if (value == null) continue block30;
                    Constants.SPY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block30;
                }
                case USE_CCM: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.USE_CCM.getXmlName());
                    if (value == null) continue block30;
                    Constants.USE_CCM.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block30;
                }
                case CONNECTABLE: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.CONNECTABLE.getXmlName());
                    if (value == null) continue block30;
                    Constants.CONNECTABLE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block30;
                }
                case TRACKING: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.TRACKING.getXmlName());
                    if (value == null) continue block30;
                    Constants.TRACKING.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block30;
                }
                default: {
                    if (Constants.STATISTICS_ENABLED.getName().equals(reader.getAttributeLocalName(i))) {
                        value = this.rawAttributeText((XMLStreamReader)reader, Constants.STATISTICS_ENABLED.getXmlName());
                        if (value == null) continue block30;
                        Constants.STATISTICS_ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                        continue block30;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ModelNode dsAddress = parentAddress.clone();
        dsAddress.add("xa-data-source", poolName);
        dsAddress.protect();
        operation.get("address").set(dsAddress);
        ArrayList<ModelNode> xadatasourcePropertiesOperations = new ArrayList<ModelNode>(0);
        while (reader.hasNext()) {
            block10 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSources.Tag.forName((String)reader.getLocalName()) == DataSources.Tag.XA_DATASOURCE) {
                        list.add(operation);
                        list.addAll(xadatasourcePropertiesOperations);
                        return;
                    }
                    if (XaDataSource.Tag.forName((String)reader.getLocalName()) != XaDataSource.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (XaDataSource.Tag.forName((String)reader.getLocalName())) {
                        case XA_DATASOURCE_PROPERTY: {
                            String name = this.rawAttributeText((XMLStreamReader)reader, "name");
                            String value2 = this.rawElementText((XMLStreamReader)reader);
                            ModelNode configOperation = new ModelNode();
                            configOperation.get("operation").set("add");
                            ModelNode configAddress = dsAddress.clone();
                            configAddress.add(Constants.XADATASOURCE_PROPERTIES.getName(), name);
                            configAddress.protect();
                            configOperation.get("address").set(configAddress);
                            Constants.XADATASOURCE_PROPERTY_VALUE.parseAndSetParameter(value2, configOperation, (XMLStreamReader)reader);
                            xadatasourcePropertiesOperations.add(configOperation);
                            break block10;
                        }
                        case XA_DATASOURCE_CLASS: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.XA_DATASOURCE_CLASS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block10;
                        }
                        case DRIVER: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DATASOURCE_DRIVER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block10;
                        }
                        case XA_POOL: {
                            this.parseXaPool(reader, operation);
                            break block10;
                        }
                        case NEW_CONNECTION_SQL: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.NEW_CONNECTION_SQL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block10;
                        }
                        case URL_DELIMITER: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.URL_DELIMITER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block10;
                        }
                        case URL_PROPERTY: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.URL_PROPERTY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block10;
                        }
                        case URL_SELECTOR_STRATEGY_CLASS_NAME: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.URL_SELECTOR_STRATEGY_CLASS_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block10;
                        }
                        case TRANSACTION_ISOLATION: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.TRANSACTION_ISOLATION.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block10;
                        }
                        case SECURITY: {
                            this.parseDsSecurity(reader, operation);
                            break block10;
                        }
                        case STATEMENT: {
                            this.parseStatementSettings(reader, operation);
                            break block10;
                        }
                        case TIMEOUT: {
                            this.parseTimeOutSettings(reader, operation);
                            break block10;
                        }
                        case VALIDATION: {
                            this.parseValidationSettings(reader, operation);
                            break block10;
                        }
                        case RECOVERY: {
                            this.parseRecovery(reader, operation);
                            break block10;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseXADataSource_4_0(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentAddress) throws XMLStreamException, ParserException, ValidateException {
        String value;
        String poolName = null;
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        int count = reader.getAttributeCount();
        block35: for (int i = 0; i < count; ++i) {
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            XaDataSource.Attribute attribute = XaDataSource.Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.ENABLED.getXmlName());
                    if (value == null) continue block35;
                    Constants.ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block35;
                }
                case JNDI_NAME: {
                    String jndiName = this.rawAttributeText((XMLStreamReader)reader, org.jboss.as.connector.subsystems.common.jndi.Constants.JNDI_NAME.getXmlName());
                    org.jboss.as.connector.subsystems.common.jndi.Constants.JNDI_NAME.parseAndSetParameter(jndiName, operation, (XMLStreamReader)reader);
                    continue block35;
                }
                case POOL_NAME: {
                    poolName = this.rawAttributeText((XMLStreamReader)reader, "pool-name");
                    continue block35;
                }
                case USE_JAVA_CONTEXT: {
                    value = this.rawAttributeText((XMLStreamReader)reader, org.jboss.as.connector.subsystems.common.jndi.Constants.USE_JAVA_CONTEXT.getXmlName());
                    if (value == null) continue block35;
                    org.jboss.as.connector.subsystems.common.jndi.Constants.USE_JAVA_CONTEXT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block35;
                }
                case SPY: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.SPY.getXmlName());
                    if (value == null) continue block35;
                    Constants.SPY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block35;
                }
                case USE_CCM: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.USE_CCM.getXmlName());
                    if (value == null) continue block35;
                    Constants.USE_CCM.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block35;
                }
                case CONNECTABLE: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.CONNECTABLE.getXmlName());
                    if (value == null) continue block35;
                    Constants.CONNECTABLE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block35;
                }
                case MCP: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.MCP.getXmlName());
                    if (value == null) continue block35;
                    Constants.MCP.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block35;
                }
                case ENLISTMENT_TRACE: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.ENLISTMENT_TRACE.getXmlName());
                    Constants.ENLISTMENT_TRACE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block35;
                }
                case TRACKING: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.TRACKING.getXmlName());
                    if (value == null) continue block35;
                    Constants.TRACKING.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block35;
                }
                default: {
                    if (Constants.STATISTICS_ENABLED.getName().equals(reader.getAttributeLocalName(i))) {
                        value = this.rawAttributeText((XMLStreamReader)reader, Constants.STATISTICS_ENABLED.getXmlName());
                        if (value == null) continue block35;
                        Constants.STATISTICS_ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                        continue block35;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ModelNode dsAddress = parentAddress.clone();
        dsAddress.add("xa-data-source", poolName);
        dsAddress.protect();
        operation.get("address").set(dsAddress);
        ArrayList<ModelNode> xadatasourcePropertiesOperations = new ArrayList<ModelNode>(0);
        while (reader.hasNext()) {
            block12 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSources.Tag.forName((String)reader.getLocalName()) == DataSources.Tag.XA_DATASOURCE) {
                        list.add(operation);
                        list.addAll(xadatasourcePropertiesOperations);
                        return;
                    }
                    if (XaDataSource.Tag.forName((String)reader.getLocalName()) != XaDataSource.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (XaDataSource.Tag.forName((String)reader.getLocalName())) {
                        case XA_DATASOURCE_PROPERTY: {
                            String name = this.rawAttributeText((XMLStreamReader)reader, "name");
                            String value2 = this.rawElementText((XMLStreamReader)reader);
                            ModelNode configOperation = new ModelNode();
                            configOperation.get("operation").set("add");
                            ModelNode configAddress = dsAddress.clone();
                            configAddress.add(Constants.XADATASOURCE_PROPERTIES.getName(), name);
                            configAddress.protect();
                            configOperation.get("address").set(configAddress);
                            Constants.XADATASOURCE_PROPERTY_VALUE.parseAndSetParameter(value2, configOperation, (XMLStreamReader)reader);
                            xadatasourcePropertiesOperations.add(configOperation);
                            break block12;
                        }
                        case XA_DATASOURCE_CLASS: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.XA_DATASOURCE_CLASS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block12;
                        }
                        case DRIVER: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DATASOURCE_DRIVER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block12;
                        }
                        case XA_POOL: {
                            this.parseXaPool(reader, operation);
                            break block12;
                        }
                        case NEW_CONNECTION_SQL: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.NEW_CONNECTION_SQL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block12;
                        }
                        case URL_DELIMITER: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.URL_DELIMITER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block12;
                        }
                        case URL_PROPERTY: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.URL_PROPERTY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block12;
                        }
                        case URL_SELECTOR_STRATEGY_CLASS_NAME: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.URL_SELECTOR_STRATEGY_CLASS_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block12;
                        }
                        case TRANSACTION_ISOLATION: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.TRANSACTION_ISOLATION.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block12;
                        }
                        case SECURITY: {
                            switch (Namespace.forUri(reader.getNamespaceURI())) {
                                case DATASOURCES_4_0: {
                                    this.parseDsSecurity(reader, operation);
                                    break block12;
                                }
                            }
                            this.parseDsSecurity_5_0(reader, operation);
                            break block12;
                        }
                        case STATEMENT: {
                            this.parseStatementSettings(reader, operation);
                            break block12;
                        }
                        case TIMEOUT: {
                            this.parseTimeOutSettings(reader, operation);
                            break block12;
                        }
                        case VALIDATION: {
                            this.parseValidationSettings(reader, operation);
                            break block12;
                        }
                        case RECOVERY: {
                            this.parseRecovery(reader, operation);
                            break block12;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseXADataSource_7_0(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentAddress) throws XMLStreamException, ParserException, ValidateException {
        String value;
        String poolName = null;
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        int count = reader.getAttributeCount();
        block35: for (int i = 0; i < count; ++i) {
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            XaDataSource.Attribute attribute = XaDataSource.Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.ENABLED.getXmlName());
                    if (value == null) continue block35;
                    Constants.ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block35;
                }
                case JNDI_NAME: {
                    String jndiName = this.rawAttributeText((XMLStreamReader)reader, org.jboss.as.connector.subsystems.common.jndi.Constants.JNDI_NAME.getXmlName());
                    org.jboss.as.connector.subsystems.common.jndi.Constants.JNDI_NAME.parseAndSetParameter(jndiName, operation, (XMLStreamReader)reader);
                    continue block35;
                }
                case POOL_NAME: {
                    poolName = this.rawAttributeText((XMLStreamReader)reader, "pool-name");
                    continue block35;
                }
                case USE_JAVA_CONTEXT: {
                    value = this.rawAttributeText((XMLStreamReader)reader, org.jboss.as.connector.subsystems.common.jndi.Constants.USE_JAVA_CONTEXT.getXmlName());
                    if (value == null) continue block35;
                    org.jboss.as.connector.subsystems.common.jndi.Constants.USE_JAVA_CONTEXT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block35;
                }
                case SPY: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.SPY.getXmlName());
                    if (value == null) continue block35;
                    Constants.SPY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block35;
                }
                case USE_CCM: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.USE_CCM.getXmlName());
                    if (value == null) continue block35;
                    Constants.USE_CCM.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block35;
                }
                case CONNECTABLE: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.CONNECTABLE.getXmlName());
                    if (value == null) continue block35;
                    Constants.CONNECTABLE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block35;
                }
                case MCP: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.MCP.getXmlName());
                    if (value == null) continue block35;
                    Constants.MCP.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block35;
                }
                case ENLISTMENT_TRACE: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.ENLISTMENT_TRACE.getXmlName());
                    Constants.ENLISTMENT_TRACE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block35;
                }
                case TRACKING: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.TRACKING.getXmlName());
                    if (value == null) continue block35;
                    Constants.TRACKING.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block35;
                }
                default: {
                    if (Constants.STATISTICS_ENABLED.getName().equals(reader.getAttributeLocalName(i))) {
                        value = this.rawAttributeText((XMLStreamReader)reader, Constants.STATISTICS_ENABLED.getXmlName());
                        if (value == null) continue block35;
                        Constants.STATISTICS_ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                        continue block35;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ModelNode dsAddress = parentAddress.clone();
        dsAddress.add("xa-data-source", poolName);
        dsAddress.protect();
        operation.get("address").set(dsAddress);
        ArrayList<ModelNode> xadatasourcePropertiesOperations = new ArrayList<ModelNode>(0);
        while (reader.hasNext()) {
            block12 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSources.Tag.forName((String)reader.getLocalName()) == DataSources.Tag.XA_DATASOURCE) {
                        list.add(operation);
                        list.addAll(xadatasourcePropertiesOperations);
                        return;
                    }
                    if (XaDataSource.Tag.forName((String)reader.getLocalName()) != XaDataSource.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (XaDataSource.Tag.forName((String)reader.getLocalName())) {
                        case XA_DATASOURCE_PROPERTY: {
                            String name = this.rawAttributeText((XMLStreamReader)reader, "name");
                            String value2 = this.rawElementText((XMLStreamReader)reader);
                            ModelNode configOperation = new ModelNode();
                            configOperation.get("operation").set("add");
                            ModelNode configAddress = dsAddress.clone();
                            configAddress.add(Constants.XADATASOURCE_PROPERTIES.getName(), name);
                            configAddress.protect();
                            configOperation.get("address").set(configAddress);
                            Constants.XADATASOURCE_PROPERTY_VALUE.parseAndSetParameter(value2, configOperation, (XMLStreamReader)reader);
                            xadatasourcePropertiesOperations.add(configOperation);
                            break block12;
                        }
                        case XA_DATASOURCE_CLASS: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.XA_DATASOURCE_CLASS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block12;
                        }
                        case DRIVER: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DATASOURCE_DRIVER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block12;
                        }
                        case XA_POOL: {
                            this.parseXaPool(reader, operation);
                            break block12;
                        }
                        case NEW_CONNECTION_SQL: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.NEW_CONNECTION_SQL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block12;
                        }
                        case URL_DELIMITER: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.URL_DELIMITER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block12;
                        }
                        case URL_PROPERTY: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.URL_PROPERTY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block12;
                        }
                        case URL_SELECTOR_STRATEGY_CLASS_NAME: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.URL_SELECTOR_STRATEGY_CLASS_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block12;
                        }
                        case TRANSACTION_ISOLATION: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.TRANSACTION_ISOLATION.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block12;
                        }
                        case SECURITY: {
                            switch (Namespace.forUri(reader.getNamespaceURI())) {
                                case DATASOURCES_4_0: {
                                    this.parseDsSecurity(reader, operation);
                                    break block12;
                                }
                            }
                            this.parseDsSecurity_5_0(reader, operation);
                            break block12;
                        }
                        case STATEMENT: {
                            this.parseStatementSettings(reader, operation);
                            break block12;
                        }
                        case TIMEOUT: {
                            this.parseTimeOutSettings(reader, operation);
                            break block12;
                        }
                        case VALIDATION: {
                            this.parseValidationSetting_7_0(reader, operation);
                            break block12;
                        }
                        case RECOVERY: {
                            this.parseRecovery(reader, operation);
                            break block12;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseDsSecurity(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException, ParserException, ValidateException {
        boolean securityDomainMatched = false;
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.SECURITY) {
                        return;
                    }
                    if (DsSecurity.Tag.forName(reader.getLocalName()) != DsSecurity.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    String value;
                    String localName = reader.getLocalName();
                    DsSecurity.Tag tag = DsSecurity.Tag.forName(localName);
                    if (localName == null) break;
                    if (localName.equals(DsSecurity.Tag.PASSWORD.getLocalName())) {
                        value = this.rawElementText((XMLStreamReader)reader);
                        Constants.PASSWORD.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                        break;
                    }
                    if (localName.equals(DsSecurity.Tag.USER_NAME.getLocalName())) {
                        value = this.rawElementText((XMLStreamReader)reader);
                        Constants.USERNAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                        break;
                    }
                    if (localName.equals(DsSecurity.Tag.SECURITY_DOMAIN.getLocalName())) {
                        if (securityDomainMatched) {
                            throw new ParserException(bundle.unexpectedElement(Constants.SECURITY_DOMAIN.getXmlName()));
                        }
                        value = this.rawElementText((XMLStreamReader)reader);
                        Constants.SECURITY_DOMAIN.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                        securityDomainMatched = true;
                        break;
                    }
                    if (localName.equals(DsSecurity.Tag.REAUTH_PLUGIN.getLocalName())) {
                        this.parseExtension(reader, tag.getLocalName(), operation, Constants.REAUTH_PLUGIN_CLASSNAME, Constants.REAUTHPLUGIN_PROPERTIES);
                        break;
                    }
                    if (localName.equals(Constants.CREDENTIAL_REFERENCE.getXmlName())) {
                        Constants.CREDENTIAL_REFERENCE.getParser().parseElement((AttributeDefinition)Constants.CREDENTIAL_REFERENCE, reader, operation);
                        break;
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseDsSecurity_5_0(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException, ParserException, ValidateException {
        boolean securityDomainMatched = false;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.SECURITY) {
                        return;
                    }
                    if (DsSecurity.Tag.forName(reader.getLocalName()) != DsSecurity.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    DsSecurity.Tag tag = DsSecurity.Tag.forName(reader.getLocalName());
                    switch (tag) {
                        case PASSWORD: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.PASSWORD.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case USER_NAME: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.USERNAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case SECURITY_DOMAIN: {
                            if (securityDomainMatched) {
                                throw new ParserException(bundle.unexpectedElement(Constants.SECURITY_DOMAIN.getXmlName()));
                            }
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.SECURITY_DOMAIN.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            securityDomainMatched = true;
                            break block0;
                        }
                        case ELYTRON_ENABLED: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            value = value == null ? "true" : value;
                            Constants.ELYTRON_ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case AUTHENTICATION_CONTEXT: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.AUTHENTICATION_CONTEXT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case REAUTH_PLUGIN: {
                            this.parseExtension(reader, tag.getLocalName(), operation, Constants.REAUTH_PLUGIN_CLASSNAME, Constants.REAUTHPLUGIN_PROPERTIES);
                            break block0;
                        }
                        case CREDENTIAL_REFERENCE: {
                            Constants.CREDENTIAL_REFERENCE.getParser().parseElement((AttributeDefinition)Constants.CREDENTIAL_REFERENCE, reader, operation);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseDataSource_1_0(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentAddress) throws XMLStreamException, ParserException, ValidateException {
        String value;
        String poolName = null;
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        int count = reader.getAttributeCount();
        block29: for (int i = 0; i < count; ++i) {
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            DataSource.Attribute attribute = DataSource.Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.ENABLED.getXmlName());
                    if (value == null) continue block29;
                    Constants.ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block29;
                }
                case JNDI_NAME: {
                    String jndiName = this.rawAttributeText((XMLStreamReader)reader, org.jboss.as.connector.subsystems.common.jndi.Constants.JNDI_NAME.getXmlName());
                    org.jboss.as.connector.subsystems.common.jndi.Constants.JNDI_NAME.parseAndSetParameter(jndiName, operation, (XMLStreamReader)reader);
                    continue block29;
                }
                case POOL_NAME: {
                    poolName = this.rawAttributeText((XMLStreamReader)reader, "pool-name");
                    continue block29;
                }
                case USE_JAVA_CONTEXT: {
                    value = this.rawAttributeText((XMLStreamReader)reader, org.jboss.as.connector.subsystems.common.jndi.Constants.USE_JAVA_CONTEXT.getXmlName());
                    if (value == null) continue block29;
                    org.jboss.as.connector.subsystems.common.jndi.Constants.USE_JAVA_CONTEXT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block29;
                }
                case SPY: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.SPY.getXmlName());
                    if (value == null) continue block29;
                    Constants.SPY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block29;
                }
                case USE_CCM: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.USE_CCM.getXmlName());
                    if (value == null) continue block29;
                    Constants.USE_CCM.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block29;
                }
                case JTA: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.JTA.getXmlName());
                    if (value == null) continue block29;
                    Constants.JTA.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block29;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ModelNode dsAddress = parentAddress.clone();
        dsAddress.add("data-source", poolName);
        dsAddress.protect();
        operation.get("address").set(dsAddress);
        ArrayList<ModelNode> configPropertiesOperations = new ArrayList<ModelNode>(0);
        while (reader.hasNext()) {
            block9 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSources.Tag.forName((String)reader.getLocalName()) == DataSources.Tag.DATASOURCE) {
                        list.add(operation);
                        list.addAll(configPropertiesOperations);
                        return;
                    }
                    if (DataSource.Tag.forName((String)reader.getLocalName()) != DataSource.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (DataSource.Tag.forName((String)reader.getLocalName())) {
                        case CONNECTION_PROPERTY: {
                            String name = this.rawAttributeText((XMLStreamReader)reader, "name");
                            String value2 = this.rawElementText((XMLStreamReader)reader);
                            ModelNode configOperation = new ModelNode();
                            configOperation.get("operation").set("add");
                            ModelNode configAddress = dsAddress.clone();
                            configAddress.add(Constants.CONNECTION_PROPERTIES.getName(), name);
                            configAddress.protect();
                            configOperation.get("address").set(configAddress);
                            Constants.CONNECTION_PROPERTY_VALUE.parseAndSetParameter(value2, configOperation, (XMLStreamReader)reader);
                            configPropertiesOperations.add(configOperation);
                            break block9;
                        }
                        case CONNECTION_URL: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.CONNECTION_URL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block9;
                        }
                        case DRIVER_CLASS: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DRIVER_CLASS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block9;
                        }
                        case DATASOURCE_CLASS: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DATASOURCE_CLASS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block9;
                        }
                        case DRIVER: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DATASOURCE_DRIVER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block9;
                        }
                        case POOL: {
                            this.parsePool(reader, operation);
                            break block9;
                        }
                        case NEW_CONNECTION_SQL: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.NEW_CONNECTION_SQL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block9;
                        }
                        case URL_DELIMITER: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.URL_DELIMITER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block9;
                        }
                        case URL_SELECTOR_STRATEGY_CLASS_NAME: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.URL_SELECTOR_STRATEGY_CLASS_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block9;
                        }
                        case TRANSACTION_ISOLATION: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.TRANSACTION_ISOLATION.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block9;
                        }
                        case SECURITY: {
                            this.parseDsSecurity(reader, operation);
                            break block9;
                        }
                        case STATEMENT: {
                            this.parseStatementSettings(reader, operation);
                            break block9;
                        }
                        case TIMEOUT: {
                            this.parseTimeOutSettings(reader, operation);
                            break block9;
                        }
                        case VALIDATION: {
                            this.parseValidationSettings(reader, operation);
                            break block9;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseDataSource_3_0(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentAddress) throws XMLStreamException, ParserException, ValidateException {
        String value;
        String poolName = null;
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        int count = reader.getAttributeCount();
        block31: for (int i = 0; i < count; ++i) {
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            DataSource.Attribute attribute = DataSource.Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.ENABLED.getXmlName());
                    if (value == null) continue block31;
                    Constants.ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block31;
                }
                case JNDI_NAME: {
                    String jndiName = this.rawAttributeText((XMLStreamReader)reader, org.jboss.as.connector.subsystems.common.jndi.Constants.JNDI_NAME.getXmlName());
                    org.jboss.as.connector.subsystems.common.jndi.Constants.JNDI_NAME.parseAndSetParameter(jndiName, operation, (XMLStreamReader)reader);
                    continue block31;
                }
                case POOL_NAME: {
                    poolName = this.rawAttributeText((XMLStreamReader)reader, "pool-name");
                    continue block31;
                }
                case USE_JAVA_CONTEXT: {
                    value = this.rawAttributeText((XMLStreamReader)reader, org.jboss.as.connector.subsystems.common.jndi.Constants.USE_JAVA_CONTEXT.getXmlName());
                    if (value == null) continue block31;
                    org.jboss.as.connector.subsystems.common.jndi.Constants.USE_JAVA_CONTEXT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block31;
                }
                case SPY: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.SPY.getXmlName());
                    if (value == null) continue block31;
                    Constants.SPY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block31;
                }
                case USE_CCM: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.USE_CCM.getXmlName());
                    if (value == null) continue block31;
                    Constants.USE_CCM.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block31;
                }
                case JTA: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.JTA.getXmlName());
                    if (value == null) continue block31;
                    Constants.JTA.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block31;
                }
                case CONNECTABLE: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.CONNECTABLE.getXmlName());
                    if (value == null) continue block31;
                    Constants.CONNECTABLE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block31;
                }
                case TRACKING: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.TRACKING.getXmlName());
                    if (value == null) continue block31;
                    Constants.TRACKING.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block31;
                }
                default: {
                    if (Constants.STATISTICS_ENABLED.getName().equals(reader.getAttributeLocalName(i))) {
                        value = this.rawAttributeText((XMLStreamReader)reader, Constants.STATISTICS_ENABLED.getXmlName());
                        if (value == null) continue block31;
                        Constants.STATISTICS_ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                        continue block31;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ModelNode dsAddress = parentAddress.clone();
        dsAddress.add("data-source", poolName);
        dsAddress.protect();
        operation.get("address").set(dsAddress);
        ArrayList<ModelNode> configPropertiesOperations = new ArrayList<ModelNode>(0);
        while (reader.hasNext()) {
            block11 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSources.Tag.forName((String)reader.getLocalName()) == DataSources.Tag.DATASOURCE) {
                        list.add(operation);
                        list.addAll(configPropertiesOperations);
                        return;
                    }
                    if (DataSource.Tag.forName((String)reader.getLocalName()) != DataSource.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (DataSource.Tag.forName((String)reader.getLocalName())) {
                        case CONNECTION_PROPERTY: {
                            String name = this.rawAttributeText((XMLStreamReader)reader, "name");
                            String value2 = this.rawElementText((XMLStreamReader)reader);
                            ModelNode configOperation = new ModelNode();
                            configOperation.get("operation").set("add");
                            ModelNode configAddress = dsAddress.clone();
                            configAddress.add(Constants.CONNECTION_PROPERTIES.getName(), name);
                            configAddress.protect();
                            configOperation.get("address").set(configAddress);
                            Constants.CONNECTION_PROPERTY_VALUE.parseAndSetParameter(value2, configOperation, (XMLStreamReader)reader);
                            configPropertiesOperations.add(configOperation);
                            break block11;
                        }
                        case CONNECTION_URL: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.CONNECTION_URL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block11;
                        }
                        case DRIVER_CLASS: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DRIVER_CLASS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block11;
                        }
                        case DATASOURCE_CLASS: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DATASOURCE_CLASS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block11;
                        }
                        case DRIVER: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DATASOURCE_DRIVER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block11;
                        }
                        case POOL: {
                            this.parsePool(reader, operation);
                            break block11;
                        }
                        case NEW_CONNECTION_SQL: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.NEW_CONNECTION_SQL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block11;
                        }
                        case URL_DELIMITER: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.URL_DELIMITER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block11;
                        }
                        case URL_SELECTOR_STRATEGY_CLASS_NAME: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.URL_SELECTOR_STRATEGY_CLASS_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block11;
                        }
                        case TRANSACTION_ISOLATION: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.TRANSACTION_ISOLATION.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block11;
                        }
                        case SECURITY: {
                            this.parseDsSecurity(reader, operation);
                            break block11;
                        }
                        case STATEMENT: {
                            this.parseStatementSettings(reader, operation);
                            break block11;
                        }
                        case TIMEOUT: {
                            this.parseTimeOutSettings(reader, operation);
                            break block11;
                        }
                        case VALIDATION: {
                            this.parseValidationSettings(reader, operation);
                            break block11;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseDataSource_4_0(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentAddress) throws XMLStreamException, ParserException, ValidateException {
        String value;
        String poolName = null;
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        int count = reader.getAttributeCount();
        block36: for (int i = 0; i < count; ++i) {
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            DataSource.Attribute attribute = DataSource.Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.ENABLED.getXmlName());
                    if (value == null) continue block36;
                    Constants.ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block36;
                }
                case JNDI_NAME: {
                    String jndiName = this.rawAttributeText((XMLStreamReader)reader, org.jboss.as.connector.subsystems.common.jndi.Constants.JNDI_NAME.getXmlName());
                    org.jboss.as.connector.subsystems.common.jndi.Constants.JNDI_NAME.parseAndSetParameter(jndiName, operation, (XMLStreamReader)reader);
                    continue block36;
                }
                case POOL_NAME: {
                    poolName = this.rawAttributeText((XMLStreamReader)reader, "pool-name");
                    continue block36;
                }
                case USE_JAVA_CONTEXT: {
                    value = this.rawAttributeText((XMLStreamReader)reader, org.jboss.as.connector.subsystems.common.jndi.Constants.USE_JAVA_CONTEXT.getXmlName());
                    if (value == null) continue block36;
                    org.jboss.as.connector.subsystems.common.jndi.Constants.USE_JAVA_CONTEXT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block36;
                }
                case SPY: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.SPY.getXmlName());
                    if (value == null) continue block36;
                    Constants.SPY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block36;
                }
                case USE_CCM: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.USE_CCM.getXmlName());
                    if (value == null) continue block36;
                    Constants.USE_CCM.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block36;
                }
                case JTA: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.JTA.getXmlName());
                    if (value == null) continue block36;
                    Constants.JTA.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block36;
                }
                case CONNECTABLE: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.CONNECTABLE.getXmlName());
                    if (value == null) continue block36;
                    Constants.CONNECTABLE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block36;
                }
                case MCP: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.MCP.getXmlName());
                    if (value == null) continue block36;
                    Constants.MCP.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block36;
                }
                case ENLISTMENT_TRACE: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.ENLISTMENT_TRACE.getXmlName());
                    Constants.ENLISTMENT_TRACE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block36;
                }
                case TRACKING: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.TRACKING.getXmlName());
                    if (value == null) continue block36;
                    Constants.TRACKING.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block36;
                }
                default: {
                    if (Constants.STATISTICS_ENABLED.getName().equals(reader.getAttributeLocalName(i))) {
                        value = this.rawAttributeText((XMLStreamReader)reader, Constants.STATISTICS_ENABLED.getXmlName());
                        if (value == null) continue block36;
                        Constants.STATISTICS_ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                        continue block36;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ModelNode dsAddress = parentAddress.clone();
        dsAddress.add("data-source", poolName);
        dsAddress.protect();
        operation.get("address").set(dsAddress);
        ArrayList<ModelNode> configPropertiesOperations = new ArrayList<ModelNode>(0);
        while (reader.hasNext()) {
            block13 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSources.Tag.forName((String)reader.getLocalName()) == DataSources.Tag.DATASOURCE) {
                        list.add(operation);
                        list.addAll(configPropertiesOperations);
                        return;
                    }
                    if (DataSource.Tag.forName((String)reader.getLocalName()) != DataSource.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (DataSource.Tag.forName((String)reader.getLocalName())) {
                        case CONNECTION_PROPERTY: {
                            String name = this.rawAttributeText((XMLStreamReader)reader, "name");
                            String value2 = this.rawElementText((XMLStreamReader)reader);
                            ModelNode configOperation = new ModelNode();
                            configOperation.get("operation").set("add");
                            ModelNode configAddress = dsAddress.clone();
                            configAddress.add(Constants.CONNECTION_PROPERTIES.getName(), name);
                            configAddress.protect();
                            configOperation.get("address").set(configAddress);
                            Constants.CONNECTION_PROPERTY_VALUE.parseAndSetParameter(value2, configOperation, (XMLStreamReader)reader);
                            configPropertiesOperations.add(configOperation);
                            break block13;
                        }
                        case CONNECTION_URL: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.CONNECTION_URL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block13;
                        }
                        case DRIVER_CLASS: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DRIVER_CLASS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block13;
                        }
                        case DATASOURCE_CLASS: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DATASOURCE_CLASS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block13;
                        }
                        case DRIVER: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DATASOURCE_DRIVER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block13;
                        }
                        case POOL: {
                            this.parsePool(reader, operation);
                            break block13;
                        }
                        case NEW_CONNECTION_SQL: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.NEW_CONNECTION_SQL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block13;
                        }
                        case URL_DELIMITER: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.URL_DELIMITER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block13;
                        }
                        case URL_SELECTOR_STRATEGY_CLASS_NAME: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.URL_SELECTOR_STRATEGY_CLASS_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block13;
                        }
                        case TRANSACTION_ISOLATION: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.TRANSACTION_ISOLATION.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block13;
                        }
                        case SECURITY: {
                            switch (Namespace.forUri(reader.getNamespaceURI())) {
                                case DATASOURCES_4_0: {
                                    this.parseDsSecurity(reader, operation);
                                    break block13;
                                }
                            }
                            this.parseDsSecurity_5_0(reader, operation);
                            break block13;
                        }
                        case STATEMENT: {
                            this.parseStatementSettings(reader, operation);
                            break block13;
                        }
                        case TIMEOUT: {
                            this.parseTimeOutSettings(reader, operation);
                            break block13;
                        }
                        case VALIDATION: {
                            this.parseValidationSettings(reader, operation);
                            break block13;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseDataSource_7_0(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentAddress) throws XMLStreamException, ParserException, ValidateException {
        String value;
        String poolName = null;
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        int count = reader.getAttributeCount();
        block36: for (int i = 0; i < count; ++i) {
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            DataSource.Attribute attribute = DataSource.Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.ENABLED.getXmlName());
                    if (value == null) continue block36;
                    Constants.ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block36;
                }
                case JNDI_NAME: {
                    String jndiName = this.rawAttributeText((XMLStreamReader)reader, org.jboss.as.connector.subsystems.common.jndi.Constants.JNDI_NAME.getXmlName());
                    org.jboss.as.connector.subsystems.common.jndi.Constants.JNDI_NAME.parseAndSetParameter(jndiName, operation, (XMLStreamReader)reader);
                    continue block36;
                }
                case POOL_NAME: {
                    poolName = this.rawAttributeText((XMLStreamReader)reader, "pool-name");
                    continue block36;
                }
                case USE_JAVA_CONTEXT: {
                    value = this.rawAttributeText((XMLStreamReader)reader, org.jboss.as.connector.subsystems.common.jndi.Constants.USE_JAVA_CONTEXT.getXmlName());
                    if (value == null) continue block36;
                    org.jboss.as.connector.subsystems.common.jndi.Constants.USE_JAVA_CONTEXT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block36;
                }
                case SPY: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.SPY.getXmlName());
                    if (value == null) continue block36;
                    Constants.SPY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block36;
                }
                case USE_CCM: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.USE_CCM.getXmlName());
                    if (value == null) continue block36;
                    Constants.USE_CCM.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block36;
                }
                case JTA: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.JTA.getXmlName());
                    if (value == null) continue block36;
                    Constants.JTA.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block36;
                }
                case CONNECTABLE: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.CONNECTABLE.getXmlName());
                    if (value == null) continue block36;
                    Constants.CONNECTABLE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block36;
                }
                case MCP: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.MCP.getXmlName());
                    if (value == null) continue block36;
                    Constants.MCP.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block36;
                }
                case ENLISTMENT_TRACE: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.ENLISTMENT_TRACE.getXmlName());
                    Constants.ENLISTMENT_TRACE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block36;
                }
                case TRACKING: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.TRACKING.getXmlName());
                    if (value == null) continue block36;
                    Constants.TRACKING.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block36;
                }
                default: {
                    if (Constants.STATISTICS_ENABLED.getName().equals(reader.getAttributeLocalName(i))) {
                        value = this.rawAttributeText((XMLStreamReader)reader, Constants.STATISTICS_ENABLED.getXmlName());
                        if (value == null) continue block36;
                        Constants.STATISTICS_ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                        continue block36;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ModelNode dsAddress = parentAddress.clone();
        dsAddress.add("data-source", poolName);
        dsAddress.protect();
        operation.get("address").set(dsAddress);
        ArrayList<ModelNode> configPropertiesOperations = new ArrayList<ModelNode>(0);
        while (reader.hasNext()) {
            block13 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSources.Tag.forName((String)reader.getLocalName()) == DataSources.Tag.DATASOURCE) {
                        list.add(operation);
                        list.addAll(configPropertiesOperations);
                        return;
                    }
                    if (DataSource.Tag.forName((String)reader.getLocalName()) != DataSource.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (DataSource.Tag.forName((String)reader.getLocalName())) {
                        case CONNECTION_PROPERTY: {
                            String name = this.rawAttributeText((XMLStreamReader)reader, "name");
                            String value2 = this.rawElementText((XMLStreamReader)reader);
                            ModelNode configOperation = new ModelNode();
                            configOperation.get("operation").set("add");
                            ModelNode configAddress = dsAddress.clone();
                            configAddress.add(Constants.CONNECTION_PROPERTIES.getName(), name);
                            configAddress.protect();
                            configOperation.get("address").set(configAddress);
                            Constants.CONNECTION_PROPERTY_VALUE.parseAndSetParameter(value2, configOperation, (XMLStreamReader)reader);
                            configPropertiesOperations.add(configOperation);
                            break block13;
                        }
                        case CONNECTION_URL: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.CONNECTION_URL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block13;
                        }
                        case DRIVER_CLASS: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DRIVER_CLASS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block13;
                        }
                        case DATASOURCE_CLASS: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DATASOURCE_CLASS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block13;
                        }
                        case DRIVER: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DATASOURCE_DRIVER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block13;
                        }
                        case POOL: {
                            this.parsePool(reader, operation);
                            break block13;
                        }
                        case NEW_CONNECTION_SQL: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.NEW_CONNECTION_SQL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block13;
                        }
                        case URL_DELIMITER: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.URL_DELIMITER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block13;
                        }
                        case URL_SELECTOR_STRATEGY_CLASS_NAME: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.URL_SELECTOR_STRATEGY_CLASS_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block13;
                        }
                        case TRANSACTION_ISOLATION: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.TRANSACTION_ISOLATION.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block13;
                        }
                        case SECURITY: {
                            switch (Namespace.forUri(reader.getNamespaceURI())) {
                                case DATASOURCES_4_0: {
                                    this.parseDsSecurity(reader, operation);
                                    break block13;
                                }
                            }
                            this.parseDsSecurity_5_0(reader, operation);
                            break block13;
                        }
                        case STATEMENT: {
                            this.parseStatementSettings(reader, operation);
                            break block13;
                        }
                        case TIMEOUT: {
                            this.parseTimeOutSettings(reader, operation);
                            break block13;
                        }
                        case VALIDATION: {
                            this.parseValidationSetting_7_0(reader, operation);
                            break block13;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parsePool(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.POOL) {
                        return;
                    }
                    if (DsPool.Tag.forName((String)reader.getLocalName()) != DsPool.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (DsPool.Tag.forName((String)reader.getLocalName())) {
                        case MAX_POOL_SIZE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.MAX_POOL_SIZE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case INITIAL_POOL_SIZE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.INITIAL_POOL_SIZE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case MIN_POOL_SIZE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.MIN_POOL_SIZE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case PREFILL: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.POOL_PREFILL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case FAIR: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FAIR.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case USE_STRICT_MIN: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.POOL_USE_STRICT_MIN.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case FLUSH_STRATEGY: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FLUSH_STRATEGY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case ALLOW_MULTIPLE_USERS: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.ALLOW_MULTIPLE_USERS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case CAPACITY: {
                            this.parseCapacity(reader, operation);
                            break block0;
                        }
                        case CONNECTION_LISTENER: {
                            this.parseExtension(reader, reader.getLocalName(), operation, Constants.CONNECTION_LISTENER_CLASS, Constants.CONNECTION_LISTENER_PROPERTIES);
                            break block0;
                        }
                        case UNKNOWN: {
                            throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseXaPool(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (XaDataSource.Tag.forName((String)reader.getLocalName()) == XaDataSource.Tag.XA_POOL) {
                        return;
                    }
                    if (DsXaPool.Tag.forName((String)reader.getLocalName()) != DsXaPool.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (DsXaPool.Tag.forName((String)reader.getLocalName())) {
                        case MAX_POOL_SIZE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.MAX_POOL_SIZE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case INITIAL_POOL_SIZE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.INITIAL_POOL_SIZE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case MIN_POOL_SIZE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.MIN_POOL_SIZE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case PREFILL: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.POOL_PREFILL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case FAIR: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FAIR.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case USE_STRICT_MIN: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.POOL_USE_STRICT_MIN.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case FLUSH_STRATEGY: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FLUSH_STRATEGY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case ALLOW_MULTIPLE_USERS: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.ALLOW_MULTIPLE_USERS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case CONNECTION_LISTENER: {
                            this.parseExtension(reader, reader.getLocalName(), operation, Constants.CONNECTION_LISTENER_CLASS, Constants.CONNECTION_LISTENER_PROPERTIES);
                            break block0;
                        }
                        case INTERLEAVING: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            value = value == null ? "true" : value;
                            Constants.INTERLEAVING.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case IS_SAME_RM_OVERRIDE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.SAME_RM_OVERRIDE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case NO_TX_SEPARATE_POOLS: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            value = value == null ? "true" : value;
                            Constants.NO_TX_SEPARATE_POOL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case PAD_XID: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.PAD_XID.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case WRAP_XA_RESOURCE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.WRAP_XA_RESOURCE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case CAPACITY: {
                            this.parseCapacity(reader, operation);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseCapacity(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DsPool.Tag.forName((String)reader.getLocalName()) == DsPool.Tag.CAPACITY) {
                        return;
                    }
                    if (Capacity.Tag.forName((String)reader.getLocalName()) != Capacity.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (Capacity.Tag.forName((String)reader.getLocalName())) {
                        case INCREMENTER: {
                            this.parseExtension(reader, reader.getLocalName(), operation, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_CLASS, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_PROPERTIES);
                            break block0;
                        }
                        case DECREMENTER: {
                            this.parseExtension(reader, reader.getLocalName(), operation, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_CLASS, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_PROPERTIES);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseRecovery(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException, ParserException, ValidateException {
        block14: for (Recovery.Attribute attribute : Recovery.Attribute.values()) {
            switch (attribute) {
                case NO_RECOVERY: {
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.NO_RECOVERY.getXmlName());
                    Constants.NO_RECOVERY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block14;
                }
            }
        }
        while (reader.hasNext()) {
            block3 : switch (reader.nextTag()) {
                case 2: {
                    if (XaDataSource.Tag.forName((String)reader.getLocalName()) == XaDataSource.Tag.RECOVERY) {
                        return;
                    }
                    if (Recovery.Tag.forName((String)reader.getLocalName()) != Recovery.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    Recovery.Tag tag = Recovery.Tag.forName((String)reader.getLocalName());
                    switch (tag) {
                        case RECOVER_CREDENTIAL: {
                            switch (Namespace.forUri(reader.getNamespaceURI())) {
                                case DATASOURCES_1_1: 
                                case DATASOURCES_2_0: 
                                case DATASOURCES_1_2: 
                                case DATASOURCES_3_0: 
                                case DATASOURCES_4_0: {
                                    this.parseCredential(reader, operation);
                                    break block3;
                                }
                            }
                            this.parseCredential_5_0(reader, operation);
                            break block3;
                        }
                        case RECOVER_PLUGIN: {
                            this.parseExtension(reader, tag.getLocalName(), operation, Constants.RECOVER_PLUGIN_CLASSNAME, Constants.RECOVER_PLUGIN_PROPERTIES);
                            break block3;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseCredential(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.SECURITY || Recovery.Tag.forName((String)reader.getLocalName()) == Recovery.Tag.RECOVER_CREDENTIAL) {
                        return;
                    }
                    if (Credential.Tag.forName(reader.getLocalName()) != Credential.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (Credential.Tag.forName(reader.getLocalName())) {
                        case PASSWORD: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.RECOVERY_PASSWORD.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case USER_NAME: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.RECOVERY_USERNAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case SECURITY_DOMAIN: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.RECOVERY_SECURITY_DOMAIN.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseCredential_5_0(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.SECURITY || Recovery.Tag.forName((String)reader.getLocalName()) == Recovery.Tag.RECOVER_CREDENTIAL) {
                        return;
                    }
                    if (Credential.Tag.forName(reader.getLocalName()) != Credential.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (Credential.Tag.forName(reader.getLocalName())) {
                        case PASSWORD: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.RECOVERY_PASSWORD.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case USER_NAME: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.RECOVERY_USERNAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case SECURITY_DOMAIN: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.RECOVERY_SECURITY_DOMAIN.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case ELYTRON_ENABLED: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            value = value == null ? "true" : value;
                            Constants.RECOVERY_ELYTRON_ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case AUTHENTICATION_CONTEXT: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.RECOVERY_AUTHENTICATION_CONTEXT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case CREDENTIAL_REFERENCE: {
                            Constants.RECOVERY_CREDENTIAL_REFERENCE.getParser().parseElement((AttributeDefinition)Constants.RECOVERY_CREDENTIAL_REFERENCE, reader, operation);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseValidationSettings(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.VALIDATION) {
                        return;
                    }
                    if (Validation.Tag.forName((String)reader.getLocalName()) != Validation.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    Validation.Tag currTag = Validation.Tag.forName((String)reader.getLocalName());
                    switch (currTag) {
                        case BACKGROUND_VALIDATION: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATION.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case BACKGROUND_VALIDATION_MILLIS: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATIONMILLIS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case CHECK_VALID_CONNECTION_SQL: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.CHECK_VALID_CONNECTION_SQL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case EXCEPTION_SORTER: {
                            this.parseExtension(reader, currTag.getLocalName(), operation, Constants.EXCEPTION_SORTER_CLASSNAME, Constants.EXCEPTION_SORTER_PROPERTIES);
                            break block0;
                        }
                        case STALE_CONNECTION_CHECKER: {
                            this.parseExtension(reader, currTag.getLocalName(), operation, Constants.STALE_CONNECTION_CHECKER_CLASSNAME, Constants.STALE_CONNECTION_CHECKER_PROPERTIES);
                            break block0;
                        }
                        case USE_FAST_FAIL: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.USE_FAST_FAIL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case VALIDATE_ON_MATCH: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.VALIDATE_ON_MATCH.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case VALID_CONNECTION_CHECKER: {
                            this.parseExtension(reader, currTag.getLocalName(), operation, Constants.VALID_CONNECTION_CHECKER_CLASSNAME, Constants.VALID_CONNECTION_CHECKER_PROPERTIES);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseValidationSetting_7_0(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.VALIDATION) {
                        return;
                    }
                    if (Validation.Tag.forName((String)reader.getLocalName()) != Validation.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    Validation.Tag currTag = Validation.Tag.forName((String)reader.getLocalName());
                    switch (currTag) {
                        case BACKGROUND_VALIDATION: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATION.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case BACKGROUND_VALIDATION_MILLIS: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATIONMILLIS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case CHECK_VALID_CONNECTION_SQL: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.CHECK_VALID_CONNECTION_SQL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case EXCEPTION_SORTER: {
                            this.parseModuleExtension(reader, currTag.getLocalName(), operation, Constants.EXCEPTION_SORTER_CLASSNAME, Constants.EXCEPTION_SORTER_MODULE, Constants.EXCEPTION_SORTER_PROPERTIES);
                            break block0;
                        }
                        case STALE_CONNECTION_CHECKER: {
                            this.parseModuleExtension(reader, currTag.getLocalName(), operation, Constants.STALE_CONNECTION_CHECKER_CLASSNAME, Constants.STALE_CONNECTION_CHECKER_MODULE, Constants.STALE_CONNECTION_CHECKER_PROPERTIES);
                            break block0;
                        }
                        case USE_FAST_FAIL: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.USE_FAST_FAIL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case VALIDATE_ON_MATCH: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.VALIDATE_ON_MATCH.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case VALID_CONNECTION_CHECKER: {
                            this.parseModuleExtension(reader, currTag.getLocalName(), operation, Constants.VALID_CONNECTION_CHECKER_CLASSNAME, Constants.VALID_CONNECTION_CHECKER_MODULE, Constants.VALID_CONNECTION_CHECKER_PROPERTIES);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseTimeOutSettings(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.TIMEOUT) {
                        return;
                    }
                    if (TimeOut.Tag.forName((String)reader.getLocalName()) != TimeOut.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (TimeOut.Tag.forName((String)reader.getLocalName())) {
                        case ALLOCATION_RETRY: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.ALLOCATION_RETRY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case ALLOCATION_RETRY_WAIT_MILLIS: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.ALLOCATION_RETRY_WAIT_MILLIS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case BLOCKING_TIMEOUT_MILLIS: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.BLOCKING_TIMEOUT_WAIT_MILLIS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case IDLE_TIMEOUT_MINUTES: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.IDLETIMEOUTMINUTES.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case QUERY_TIMEOUT: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.QUERY_TIMEOUT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case SET_TX_QUERY_TIMEOUT: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            value = value == null ? "true" : value;
                            Constants.SET_TX_QUERY_TIMEOUT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case USE_TRY_LOCK: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.USE_TRY_LOCK.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case XA_RESOURCE_TIMEOUT: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.XA_RESOURCE_TIMEOUT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseStatementSettings(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.STATEMENT) {
                        return;
                    }
                    if (Statement.Tag.forName((String)reader.getLocalName()) != Statement.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (Statement.Tag.forName((String)reader.getLocalName())) {
                        case PREPARED_STATEMENT_CACHE_SIZE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.PREPARED_STATEMENTS_CACHE_SIZE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case TRACK_STATEMENTS: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.TRACK_STATEMENTS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case SHARE_PREPARED_STATEMENTS: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            value = value == null ? "true" : value;
                            Constants.SHARE_PREPARED_STATEMENTS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private int findSlot(String moduleName) {
        boolean insideVariable = false;
        int i = 0;
        while (i < moduleName.length()) {
            if (!insideVariable) {
                if (moduleName.charAt(i) == ':') {
                    return i;
                }
                if (moduleName.charAt(i) == '$' && i + 1 < moduleName.length() && moduleName.charAt(i + 1) == '{') {
                    insideVariable = true;
                    i += 2;
                    continue;
                }
            } else if (moduleName.charAt(i) == '}') {
                insideVariable = false;
            }
            ++i;
        }
        return -1;
    }

    public static enum Tag {
        UNKNOWN(null),
        DATASOURCES("datasources");

        private final String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

