/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.ejb;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.server.session.SecureRandomSessionIdGenerator;
import io.undertow.server.session.SessionIdGenerator;
import io.undertow.util.Headers;
import jakarta.ejb.NoSuchEJBException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import java.io.InputStream;
import java.net.SocketAddress;
import java.util.Base64;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.transaction.xa.XAException;
import org.jboss.ejb.client.EJBIdentifier;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.server.Association;
import org.jboss.ejb.server.SessionOpenRequest;
import org.jboss.marshalling.InputStreamByteInput;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.common.annotation.NotNull;
import org.wildfly.httpclient.common.ContentType;
import org.wildfly.httpclient.common.ElytronIdentityHandler;
import org.wildfly.httpclient.common.HttpMarshallerFactory;
import org.wildfly.httpclient.common.HttpServerHelper;
import org.wildfly.httpclient.common.HttpServiceConfig;
import org.wildfly.httpclient.ejb.EjbConstants;
import org.wildfly.httpclient.ejb.EjbHttpClientMessages;
import org.wildfly.httpclient.ejb.HttpProtocolV1ObjectTable;
import org.wildfly.httpclient.ejb.RemoteHTTPHandler;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.transaction.client.ImportResult;
import org.wildfly.transaction.client.LocalTransaction;
import org.wildfly.transaction.client.LocalTransactionContext;

class HttpSessionOpenHandler
extends RemoteHTTPHandler {
    private final Association association;
    private final ExecutorService executorService;
    private final SessionIdGenerator sessionIdGenerator = new SecureRandomSessionIdGenerator();
    private final LocalTransactionContext localTransactionContext;
    private final HttpServiceConfig httpServiceConfig;

    HttpSessionOpenHandler(Association association, ExecutorService executorService, LocalTransactionContext localTransactionContext, HttpServiceConfig httpServiceConfig) {
        super(executorService);
        this.association = association;
        this.executorService = executorService;
        this.localTransactionContext = localTransactionContext;
        this.httpServiceConfig = httpServiceConfig;
    }

    @Override
    protected void handleInternal(final HttpServerExchange exchange) throws Exception {
        String[] parts;
        String ct = exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
        ContentType contentType = ContentType.parse(ct);
        if (contentType == null || contentType.getVersion() != 1 || !EjbConstants.SESSION_OPEN.getType().equals(contentType.getType())) {
            exchange.setStatusCode(400);
            EjbHttpClientMessages.MESSAGES.debugf("Bad content type %s", (Object)ct);
            return;
        }
        String relativePath = exchange.getRelativePath();
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        if ((parts = relativePath.split("/")).length != 4) {
            exchange.setStatusCode(404);
            return;
        }
        String app = HttpSessionOpenHandler.handleDash(parts[0]);
        String module = HttpSessionOpenHandler.handleDash(parts[1]);
        String distinct = HttpSessionOpenHandler.handleDash(parts[2]);
        String bean = parts[3];
        Cookie cookie = exchange.getRequestCookies().get("JSESSIONID");
        String sessionAffinity = null;
        if (cookie != null) {
            sessionAffinity = cookie.getValue();
        }
        final EJBIdentifier ejbIdentifier = new EJBIdentifier(app, module, bean, distinct);
        exchange.dispatch((Executor)this.executorService, () -> {
            LocalTransaction transaction;
            RemoteHTTPHandler.ReceivedTransaction txConfig;
            try {
                HttpMarshallerFactory httpUnmarshallerFactory = this.httpServiceConfig.getHttpUnmarshallerFactory(exchange);
                Unmarshaller unmarshaller = httpUnmarshallerFactory.createUnmarshaller(HttpProtocolV1ObjectTable.INSTANCE);
                try (InputStream inputStream = exchange.getInputStream();){
                    unmarshaller.start(new InputStreamByteInput(inputStream));
                    txConfig = this.readTransaction(unmarshaller);
                    unmarshaller.finish();
                }
            }
            catch (Exception e) {
                HttpServerHelper.sendException(exchange, this.httpServiceConfig, 500, e);
                return;
            }
            if (txConfig == null || this.localTransactionContext == null) {
                transaction = null;
            } else {
                try {
                    ImportResult<LocalTransaction> result = this.localTransactionContext.findOrImportTransaction(txConfig.getXid(), txConfig.getRemainingTime());
                    transaction = result.getTransaction();
                }
                catch (XAException e) {
                    throw new IllegalStateException(e);
                }
            }
            this.association.receiveSessionOpenRequest(new SessionOpenRequest(){

                @Override
                public boolean hasTransaction() {
                    return txConfig != null;
                }

                @Override
                public Transaction getTransaction() throws SystemException, IllegalStateException {
                    return transaction;
                }

                @Override
                public SocketAddress getPeerAddress() {
                    return exchange.getSourceAddress();
                }

                @Override
                public SocketAddress getLocalAddress() {
                    return exchange.getDestinationAddress();
                }

                @Override
                public Executor getRequestExecutor() {
                    return HttpSessionOpenHandler.this.executorService != null ? HttpSessionOpenHandler.this.executorService : exchange.getIoThread().getWorker();
                }

                @Override
                public String getProtocol() {
                    return exchange.getProtocol().toString();
                }

                @Override
                public boolean isBlockingCaller() {
                    return false;
                }

                @Override
                public EJBIdentifier getEJBIdentifier() {
                    return ejbIdentifier;
                }

                @Override
                public SecurityIdentity getSecurityIdentity() {
                    return exchange.getAttachment(ElytronIdentityHandler.IDENTITY_KEY);
                }

                @Override
                public void writeException(@NotNull Exception exception) {
                    HttpServerHelper.sendException(exchange, HttpSessionOpenHandler.this.httpServiceConfig, 500, exception);
                }

                @Override
                public void writeNoSuchEJB() {
                    HttpServerHelper.sendException(exchange, HttpSessionOpenHandler.this.httpServiceConfig, 404, new NoSuchEJBException());
                }

                @Override
                public void writeWrongViewType() {
                    HttpServerHelper.sendException(exchange, HttpSessionOpenHandler.this.httpServiceConfig, 404, EjbHttpClientMessages.MESSAGES.wrongViewType());
                }

                @Override
                public void writeCancelResponse() {
                    throw new RuntimeException("nyi");
                }

                @Override
                public void writeNotStateful() {
                    HttpServerHelper.sendException(exchange, HttpSessionOpenHandler.this.httpServiceConfig, 500, EjbHttpClientMessages.MESSAGES.notStateful());
                }

                @Override
                public void convertToStateful(@NotNull SessionID sessionId) throws IllegalArgumentException, IllegalStateException {
                    Cookie sessionCookie = exchange.getRequestCookies().get("JSESSIONID");
                    if (sessionCookie == null) {
                        String rootPath = exchange.getResolvedPath();
                        int ejbIndex = rootPath.lastIndexOf("/ejb");
                        if (ejbIndex > 0) {
                            rootPath = rootPath.substring(0, ejbIndex);
                        }
                        exchange.getResponseCookies().put("JSESSIONID", new CookieImpl("JSESSIONID", HttpSessionOpenHandler.this.sessionIdGenerator.createSessionId()).setPath(rootPath));
                    }
                    exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, EjbConstants.EJB_RESPONSE_NEW_SESSION.toString());
                    exchange.getResponseHeaders().put(EjbConstants.EJB_SESSION_ID, Base64.getUrlEncoder().encodeToString(sessionId.getEncodedForm()));
                    exchange.setStatusCode(204);
                    exchange.endExchange();
                }

                @Override
                public <C> C getProviderInterface(Class<C> providerInterfaceType) {
                    return null;
                }
            });
        });
    }

    private static String handleDash(String s) {
        if (s.equals("-")) {
            return "";
        }
        return s;
    }
}

