/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.internal;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.util.List;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockOptions;
import org.hibernate.ScrollMode;
import org.hibernate.cache.spi.QueryKey;
import org.hibernate.cache.spi.QueryResultsCache;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.spi.AppliedGraph;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.internal.ScrollableResultsIterator;
import org.hibernate.query.spi.Limit;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.sql.exec.SqlExecLogger;
import org.hibernate.sql.exec.internal.BaseExecutionContext;
import org.hibernate.sql.exec.internal.JdbcExecHelper;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcSelectExecutor;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.internal.ResultsHelper;
import org.hibernate.sql.results.internal.RowProcessingStateStandardImpl;
import org.hibernate.sql.results.internal.RowTransformerStandardImpl;
import org.hibernate.sql.results.internal.RowTransformerTupleTransformerAdapter;
import org.hibernate.sql.results.jdbc.internal.DeferredResultSetAccess;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesCacheHit;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesResultSetImpl;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.internal.ResultSetAccess;
import org.hibernate.sql.results.jdbc.spi.JdbcValues;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMapping;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMappingProducer;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.hibernate.sql.results.spi.ResultsConsumer;
import org.hibernate.sql.results.spi.RowReader;
import org.hibernate.sql.results.spi.RowTransformer;
import org.hibernate.sql.results.spi.ScrollableResultsConsumer;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public class JdbcSelectExecutorStandardImpl
implements JdbcSelectExecutor {
    public static final JdbcSelectExecutorStandardImpl INSTANCE = new JdbcSelectExecutorStandardImpl();

    @Override
    public <R> List<R> list(JdbcOperationQuerySelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer, Class<R> domainResultType, ListResultsConsumer.UniqueSemantic uniqueSemantic) {
        return (List)this.executeQuery(jdbcSelect, jdbcParameterBindings, executionContext, rowTransformer, domainResultType, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), ListResultsConsumer.instance(uniqueSemantic));
    }

    @Override
    public <R> ScrollableResultsImplementor<R> scroll(JdbcOperationQuerySelect jdbcSelect, ScrollMode scrollMode, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer) {
        SharedSessionContractImplementor session = executionContext.getSession();
        session.autoFlushIfRequired(jdbcSelect.getAffectedTableNames());
        return (ScrollableResultsImplementor)this.executeQueryScroll(jdbcSelect, jdbcParameterBindings, executionContext, rowTransformer, null, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareQueryStatement((String)sql, false, scrollMode), ScrollableResultsConsumer.instance());
    }

    @Override
    public <R> Stream<R> stream(JdbcOperationQuerySelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer) {
        ScrollableResultsImplementor<R> scrollableResults = this.scroll(jdbcSelect, ScrollMode.FORWARD_ONLY, jdbcParameterBindings, executionContext, rowTransformer);
        ScrollableResultsIterator<R> iterator = new ScrollableResultsIterator<R>(scrollableResults);
        Spliterator<R> spliterator = Spliterators.spliteratorUnknownSize(iterator, 256);
        Stream<R> stream = StreamSupport.stream(spliterator, false);
        return (Stream)stream.onClose(scrollableResults::close);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, R> T executeQuery(JdbcOperationQuerySelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer, Class<R> domainResultType, Function<String, PreparedStatement> statementCreator, ResultsConsumer<T, R> resultsConsumer) {
        PersistenceContext persistenceContext = executionContext.getSession().getPersistenceContext();
        boolean defaultReadOnlyOrig = persistenceContext.isDefaultReadOnly();
        Boolean readOnly = executionContext.getQueryOptions().isReadOnly();
        if (readOnly != null) {
            persistenceContext.setDefaultReadOnly(readOnly);
        }
        try {
            T t = this.doExecuteQuery(jdbcSelect, jdbcParameterBindings, executionContext, rowTransformer, domainResultType, statementCreator, resultsConsumer);
            return t;
        }
        finally {
            if (readOnly != null) {
                persistenceContext.setDefaultReadOnly(defaultReadOnlyOrig);
            }
        }
    }

    private <T, R> T executeQueryScroll(JdbcOperationQuerySelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer, Class<R> domainResultType, Function<String, PreparedStatement> statementCreator, ResultsConsumer<T, R> resultsConsumer) {
        return this.doExecuteQuery(jdbcSelect, jdbcParameterBindings, this.getScrollContext(executionContext, executionContext.getSession().getPersistenceContext()), rowTransformer, domainResultType, statementCreator, resultsConsumer);
    }

    private ExecutionContext getScrollContext(ExecutionContext context, PersistenceContext persistenceContext) {
        QueryOptions queryOptions = context.getQueryOptions();
        Boolean readOnly = queryOptions.isReadOnly() == null ? Boolean.valueOf(persistenceContext.isDefaultReadOnly()) : queryOptions.isReadOnly();
        Integer timeout = queryOptions.getTimeout();
        FlushMode flushMode = queryOptions.getFlushMode();
        AppliedGraph appliedGraph = queryOptions.getAppliedGraph();
        TupleTransformer<?> tupleTransformer = queryOptions.getTupleTransformer();
        ResultListTransformer<?> resultListTransformer = queryOptions.getResultListTransformer();
        Boolean resultCachingEnabled = queryOptions.isResultCachingEnabled();
        CacheRetrieveMode cacheRetrieveMode = queryOptions.getCacheRetrieveMode();
        CacheStoreMode cacheStoreMode = queryOptions.getCacheStoreMode();
        String resultCacheRegionName = queryOptions.getResultCacheRegionName();
        LockOptions lockOptions = queryOptions.getLockOptions();
        String comment = queryOptions.getComment();
        List<String> databaseHints = queryOptions.getDatabaseHints();
        Integer fetchSize = queryOptions.getFetchSize();
        Limit limit = queryOptions.getLimit();
        return new JdbcSelectExecutionContext(timeout, flushMode, readOnly, appliedGraph, tupleTransformer, resultListTransformer, resultCachingEnabled, cacheRetrieveMode, cacheStoreMode, resultCacheRegionName, lockOptions, comment, databaseHints, fetchSize, limit, context);
    }

    private <T, R> T doExecuteQuery(JdbcOperationQuerySelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, final ExecutionContext executionContext, RowTransformer<R> rowTransformer, Class<R> domainResultType, Function<String, PreparedStatement> statementCreator, ResultsConsumer<T, R> resultsConsumer) {
        boolean stats;
        DeferredResultSetAccess deferredResultSetAccess = new DeferredResultSetAccess(jdbcSelect, jdbcParameterBindings, executionContext, statementCreator);
        JdbcValues jdbcValues = this.resolveJdbcValuesSource(executionContext.getQueryIdentifier(deferredResultSetAccess.getFinalSql()), jdbcSelect, resultsConsumer.canResultsBeCached(), executionContext, deferredResultSetAccess);
        if (rowTransformer == null) {
            TupleTransformer<?> tupleTransformer = executionContext.getQueryOptions().getTupleTransformer();
            if (tupleTransformer == null) {
                rowTransformer = RowTransformerStandardImpl.instance();
            } else {
                List<DomainResult<?>> domainResults = jdbcValues.getValuesMapping().getDomainResults();
                String[] aliases = new String[domainResults.size()];
                for (int i = 0; i < domainResults.size(); ++i) {
                    aliases[i] = domainResults.get(i).getResultVariable();
                }
                rowTransformer = new RowTransformerTupleTransformerAdapter(aliases, tupleTransformer);
            }
        }
        SharedSessionContractImplementor session = executionContext.getSession();
        long startTime = 0L;
        StatisticsImplementor statistics = session.getFactory().getStatistics();
        if (executionContext.hasQueryExecutionToBeAddedToStatistics() && jdbcValues instanceof JdbcValuesResultSetImpl) {
            stats = statistics.isStatisticsEnabled();
            if (stats) {
                startTime = System.nanoTime();
            }
        } else {
            stats = false;
        }
        JdbcValuesSourceProcessingOptions processingOptions = new JdbcValuesSourceProcessingOptions(){

            @Override
            public Object getEffectiveOptionalObject() {
                return executionContext.getEntityInstance();
            }

            @Override
            public String getEffectiveOptionalEntityName() {
                return null;
            }

            @Override
            public Object getEffectiveOptionalId() {
                return executionContext.getEntityId();
            }

            @Override
            public boolean shouldReturnProxies() {
                return true;
            }
        };
        JdbcValuesSourceProcessingStateStandardImpl valuesProcessingState = new JdbcValuesSourceProcessingStateStandardImpl(executionContext, processingOptions, executionContext::registerLoadingEntityEntry);
        RowReader<R> rowReader = ResultsHelper.createRowReader(executionContext, deferredResultSetAccess.usesFollowOnLocking() ? LockOptions.NONE : executionContext.getQueryOptions().getLockOptions(), rowTransformer, domainResultType, jdbcValues);
        RowProcessingStateStandardImpl rowProcessingState = new RowProcessingStateStandardImpl(valuesProcessingState, executionContext, rowReader, jdbcValues);
        T result = resultsConsumer.consume(jdbcValues, session, processingOptions, valuesProcessingState, rowProcessingState, rowReader);
        if (stats) {
            long endTime = System.nanoTime();
            long milliseconds = TimeUnit.MILLISECONDS.convert(endTime - startTime, TimeUnit.NANOSECONDS);
            statistics.queryExecuted(executionContext.getQueryIdentifier(jdbcSelect.getSqlString()), this.getResultSize(result), milliseconds);
        }
        return result;
    }

    private <T> int getResultSize(T result) {
        if (result instanceof List) {
            return ((List)result).size();
        }
        return -1;
    }

    public JdbcValues resolveJdbcValuesSource(String queryIdentifier, JdbcOperationQuerySelect jdbcSelect, boolean canBeCached, ExecutionContext executionContext, ResultSetAccess resultSetAccess) {
        List<?> cachedResults;
        QueryKey queryResultsCacheKey;
        boolean cacheable;
        SharedSessionContractImplementor session = executionContext.getSession();
        SessionFactoryImplementor factory = session.getFactory();
        boolean queryCacheEnabled = factory.getSessionFactoryOptions().isQueryCacheEnabled();
        CacheMode cacheMode = JdbcExecHelper.resolveCacheMode(executionContext);
        JdbcValuesMappingProducer mappingProducer = jdbcSelect.getJdbcValuesMappingProducer();
        boolean bl = cacheable = queryCacheEnabled && canBeCached && executionContext.getQueryOptions().isResultCachingEnabled() == Boolean.TRUE;
        if (cacheable && cacheMode.isGetEnabled()) {
            SqlExecLogger.SQL_EXEC_LOGGER.debugf("Reading Query result cache data per CacheMode#isGetEnabled [%s]", cacheMode.name());
            Set<String> querySpaces = jdbcSelect.getAffectedTableNames();
            if (querySpaces == null || querySpaces.size() == 0) {
                SqlExecLogger.SQL_EXEC_LOGGER.tracef("Unexpected querySpaces is empty", new Object[0]);
            } else {
                SqlExecLogger.SQL_EXEC_LOGGER.tracef("querySpaces is `%s`", querySpaces);
            }
            QueryResultsCache queryCache = factory.getCache().getQueryResultsCache(executionContext.getQueryOptions().getResultCacheRegionName());
            queryResultsCacheKey = QueryKey.from(jdbcSelect.getSqlString(), executionContext.getQueryOptions().getLimit(), executionContext.getQueryParameterBindings(), session);
            cachedResults = queryCache.get(queryResultsCacheKey, querySpaces, session);
            StatisticsImplementor statistics = factory.getStatistics();
            if (statistics.isStatisticsEnabled()) {
                if (cachedResults == null) {
                    statistics.queryCacheMiss(queryIdentifier, queryCache.getRegion().getName());
                } else {
                    statistics.queryCacheHit(queryIdentifier, queryCache.getRegion().getName());
                }
            }
        } else {
            SqlExecLogger.SQL_EXEC_LOGGER.debugf("Skipping reading Query result cache data: cache-enabled = %s, cache-mode = %s", queryCacheEnabled, cacheMode.name());
            cachedResults = null;
            queryResultsCacheKey = cacheable && cacheMode.isPutEnabled() ? QueryKey.from(jdbcSelect.getSqlString(), executionContext.getQueryOptions().getLimit(), executionContext.getQueryParameterBindings(), session) : null;
        }
        if (cachedResults == null) {
            JdbcValuesMetadata metadataForCache;
            JdbcValuesMapping jdbcValuesMapping;
            if (queryResultsCacheKey == null) {
                jdbcValuesMapping = mappingProducer.resolve(resultSetAccess, session.getLoadQueryInfluencers(), factory);
                metadataForCache = null;
            } else {
                CapturingJdbcValuesMetadata capturingMetadata = new CapturingJdbcValuesMetadata(resultSetAccess);
                jdbcValuesMapping = mappingProducer.resolve(capturingMetadata, session.getLoadQueryInfluencers(), factory);
                metadataForCache = capturingMetadata.resolveMetadataForCache();
            }
            return new JdbcValuesResultSetImpl(resultSetAccess, queryResultsCacheKey, queryIdentifier, executionContext.getQueryOptions(), jdbcValuesMapping, metadataForCache, executionContext);
        }
        JdbcValuesMapping jdbcValuesMapping = cachedResults.isEmpty() || !(cachedResults.get(0) instanceof JdbcValuesMetadata) ? mappingProducer.resolve(resultSetAccess, session.getLoadQueryInfluencers(), factory) : mappingProducer.resolve((JdbcValuesMetadata)cachedResults.get(0), session.getLoadQueryInfluencers(), factory);
        return new JdbcValuesCacheHit(cachedResults, jdbcValuesMapping);
    }

    private static class JdbcSelectExecutionContext
    extends BaseExecutionContext
    implements QueryOptions {
        private final Integer timeout;
        private final FlushMode flushMode;
        private final Boolean readOnly;
        private final AppliedGraph appliedGraph;
        private final TupleTransformer<?> tupleTransformer;
        private final ResultListTransformer<?> resultListTransformer;
        private final Boolean resultCachingEnabled;
        private final CacheRetrieveMode cacheRetrieveMode;
        private final CacheStoreMode cacheStoreMode;
        private final String resultCacheRegionName;
        private final LockOptions lockOptions;
        private final String comment;
        private final List<String> databaseHints;
        private final Integer fetchSize;
        private final Limit limit;
        private final ExecutionContext context;

        public JdbcSelectExecutionContext(Integer timeout, FlushMode flushMode, Boolean readOnly, AppliedGraph appliedGraph, TupleTransformer<?> tupleTransformer, ResultListTransformer<?> resultListTransformer, Boolean resultCachingEnabled, CacheRetrieveMode cacheRetrieveMode, CacheStoreMode cacheStoreMode, String resultCacheRegionName, LockOptions lockOptions, String comment, List<String> databaseHints, Integer fetchSize, Limit limit, ExecutionContext context) {
            super(context.getSession());
            this.timeout = timeout;
            this.flushMode = flushMode;
            this.readOnly = readOnly;
            this.appliedGraph = appliedGraph;
            this.tupleTransformer = tupleTransformer;
            this.resultListTransformer = resultListTransformer;
            this.resultCachingEnabled = resultCachingEnabled;
            this.cacheRetrieveMode = cacheRetrieveMode;
            this.cacheStoreMode = cacheStoreMode;
            this.resultCacheRegionName = resultCacheRegionName;
            this.lockOptions = lockOptions;
            this.comment = comment;
            this.databaseHints = databaseHints;
            this.fetchSize = fetchSize;
            this.limit = limit;
            this.context = context;
        }

        @Override
        public boolean isScrollResult() {
            return true;
        }

        @Override
        public QueryOptions getQueryOptions() {
            return this;
        }

        @Override
        public Integer getTimeout() {
            return this.timeout;
        }

        @Override
        public FlushMode getFlushMode() {
            return this.flushMode;
        }

        @Override
        public Boolean isReadOnly() {
            return this.readOnly;
        }

        @Override
        public AppliedGraph getAppliedGraph() {
            return this.appliedGraph;
        }

        @Override
        public TupleTransformer<?> getTupleTransformer() {
            return this.tupleTransformer;
        }

        @Override
        public ResultListTransformer<?> getResultListTransformer() {
            return this.resultListTransformer;
        }

        @Override
        public Boolean isResultCachingEnabled() {
            return this.resultCachingEnabled;
        }

        @Override
        public CacheRetrieveMode getCacheRetrieveMode() {
            return this.cacheRetrieveMode;
        }

        @Override
        public CacheStoreMode getCacheStoreMode() {
            return this.cacheStoreMode;
        }

        @Override
        public String getResultCacheRegionName() {
            return this.resultCacheRegionName;
        }

        @Override
        public LockOptions getLockOptions() {
            return this.lockOptions;
        }

        @Override
        public String getComment() {
            return this.comment;
        }

        @Override
        public List<String> getDatabaseHints() {
            return this.databaseHints;
        }

        @Override
        public Integer getFetchSize() {
            return this.fetchSize;
        }

        @Override
        public Limit getLimit() {
            return this.limit;
        }

        @Override
        public QueryParameterBindings getQueryParameterBindings() {
            return this.context.getQueryParameterBindings();
        }

        @Override
        public Callback getCallback() {
            return this.context.getCallback();
        }
    }

    private static class CachedJdbcValuesMetadata
    implements JdbcValuesMetadata,
    Serializable {
        private final String[] columnNames;
        private final BasicType<?>[] types;

        public CachedJdbcValuesMetadata(String[] columnNames, BasicType<?>[] types) {
            this.columnNames = columnNames;
            this.types = types;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int resolveColumnPosition(String columnName) {
            int position = ArrayHelper.indexOf(this.columnNames, columnName) + 1;
            if (position == 0) {
                throw new IllegalStateException("Unexpected resolving of unavailable column: " + columnName);
            }
            return position;
        }

        @Override
        public String resolveColumnName(int position) {
            String name = this.columnNames[position - 1];
            if (name == null) {
                throw new IllegalStateException("Unexpected resolving of unavailable column at position: " + position);
            }
            return name;
        }

        @Override
        public <J> BasicType<J> resolveType(int position, JavaType<J> explicitJavaType, TypeConfiguration typeConfiguration) {
            BasicType<?> type = this.types[position - 1];
            if (type == null) {
                throw new IllegalStateException("Unexpected resolving of unavailable column at position: " + position);
            }
            if (explicitJavaType == null || type.getJavaTypeDescriptor() == explicitJavaType) {
                return type;
            }
            return typeConfiguration.getBasicTypeRegistry().resolve(explicitJavaType, type.getJdbcType());
        }
    }

    public static class CapturingJdbcValuesMetadata
    implements JdbcValuesMetadata {
        private final ResultSetAccess resultSetAccess;
        private String[] columnNames;
        private BasicType<?>[] types;

        public CapturingJdbcValuesMetadata(ResultSetAccess resultSetAccess) {
            this.resultSetAccess = resultSetAccess;
        }

        private void initializeArrays() {
            int columnCount = this.resultSetAccess.getColumnCount();
            this.columnNames = new String[columnCount];
            this.types = new BasicType[columnCount];
        }

        @Override
        public int getColumnCount() {
            if (this.columnNames == null) {
                this.initializeArrays();
            }
            return this.columnNames.length;
        }

        @Override
        public int resolveColumnPosition(String columnName) {
            int position;
            if (this.columnNames == null) {
                this.initializeArrays();
            }
            if (this.columnNames == null) {
                position = this.resultSetAccess.resolveColumnPosition(columnName);
                this.columnNames[position - 1] = columnName;
            } else {
                position = ArrayHelper.indexOf(this.columnNames, columnName) + 1;
                if (position == 0) {
                    position = this.resultSetAccess.resolveColumnPosition(columnName);
                    this.columnNames[position - 1] = columnName;
                }
            }
            return position;
        }

        @Override
        public String resolveColumnName(int position) {
            String name;
            if (this.columnNames == null) {
                this.initializeArrays();
            }
            if (this.columnNames == null) {
                this.columnNames[position - 1] = name = this.resultSetAccess.resolveColumnName(position);
            } else {
                name = this.columnNames[position - 1];
                if (name == null) {
                    this.columnNames[position - 1] = name = this.resultSetAccess.resolveColumnName(position);
                }
            }
            return name;
        }

        @Override
        public <J> BasicType<J> resolveType(int position, JavaType<J> explicitJavaType, TypeConfiguration typeConfiguration) {
            if (this.columnNames == null) {
                this.initializeArrays();
            }
            BasicType<J> basicType = this.resultSetAccess.resolveType(position, explicitJavaType, typeConfiguration);
            this.types[position - 1] = basicType;
            return basicType;
        }

        public JdbcValuesMetadata resolveMetadataForCache() {
            if (this.columnNames == null) {
                return null;
            }
            return new CachedJdbcValuesMetadata(this.columnNames, this.types);
        }
    }
}

