/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import jakarta.persistence.criteria.Expression;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.ListPersistentAttribute;
import org.hibernate.metamodel.model.domain.MapPersistentAttribute;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.query.PathException;
import org.hibernate.query.SemanticException;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.hql.spi.SqmPathRegistry;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.domain.AbstractSqmPluralJoin;
import org.hibernate.query.sqm.tree.domain.AbstractSqmSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmIndexedCollectionAccessPath;
import org.hibernate.query.sqm.tree.domain.SqmListJoin;
import org.hibernate.query.sqm.tree.domain.SqmMapJoin;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedSimplePath;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.spi.NavigablePath;

public class SqmPluralValuedSimplePath<E>
extends AbstractSqmSimplePath<E> {
    public SqmPluralValuedSimplePath(NavigablePath navigablePath, PluralPersistentAttribute<?, ?, E> referencedNavigable, SqmPath<?> lhs, NodeBuilder nodeBuilder) {
        this(navigablePath, referencedNavigable, lhs, (String)null, nodeBuilder);
    }

    public SqmPluralValuedSimplePath(NavigablePath navigablePath, PluralPersistentAttribute<?, ?, E> referencedNavigable, SqmPath<?> lhs, String explicitAlias, NodeBuilder nodeBuilder) {
        super(navigablePath, referencedNavigable, lhs, explicitAlias, nodeBuilder);
    }

    @Override
    public SqmPluralValuedSimplePath<E> copy(SqmCopyContext context) {
        SqmPluralValuedSimplePath existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmPluralValuedSimplePath<E> path = context.registerCopy(this, new SqmPluralValuedSimplePath<E>(this.getNavigablePath(), this.getReferencedPathSource(), (SqmPath<?>)this.getLhs().copy(context), this.getExplicitAlias(), (NodeBuilder)this.nodeBuilder()));
        this.copyTo(path, context);
        return path;
    }

    public PluralPersistentAttribute<?, ?, E> getReferencedPathSource() {
        return (PluralPersistentAttribute)super.getReferencedPathSource();
    }

    @Override
    public PluralPersistentAttribute<?, ?, E> getNodeType() {
        return this.getReferencedPathSource();
    }

    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitPluralValuedPath(this);
    }

    @Override
    public SqmPath<?> resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        CollectionPart.Nature nature = CollectionPart.Nature.fromNameExact(name);
        if (nature == null) {
            throw new SemanticException("illegal attempt to dereference collection [" + this.getNavigablePath() + "] with element property reference [" + name + "]");
        }
        JpaPath sqmPath = this.get(name);
        creationState.getProcessingStateStack().getCurrent().getPathRegistry().register((SqmPath<?>)sqmPath);
        return sqmPath;
    }

    @Override
    public SqmPath<?> resolveIndexedAccess(SqmExpression<?> selector, boolean isTerminal, SqmCreationState creationState) {
        SqmPathRegistry pathRegistry = creationState.getCurrentProcessingState().getPathRegistry();
        String alias = selector.toHqlString();
        NavigablePath navigablePath = this.getNavigablePath().getParent().append(this.getNavigablePath().getLocalName(), alias).append(CollectionPart.Nature.ELEMENT.getName());
        Object indexedPath = pathRegistry.findFromByPath(navigablePath);
        if (indexedPath != null) {
            return indexedPath;
        }
        Object path = pathRegistry.findFromByPath(navigablePath.getParent());
        if (path == null) {
            Expression index;
            AbstractSqmPluralJoin join;
            SqmPathSource referencedPathSource = this.getReferencedPathSource();
            Object parent = pathRegistry.resolveFrom((SqmPath<?>)this.getLhs());
            if (referencedPathSource instanceof ListPersistentAttribute) {
                join = new SqmListJoin(parent, (ListPersistentAttribute)referencedPathSource, alias, SqmJoinType.INNER, false, parent.nodeBuilder());
                index = ((SqmListJoin)join).index();
            } else if (referencedPathSource instanceof MapPersistentAttribute) {
                join = new SqmMapJoin(parent, (MapPersistentAttribute)referencedPathSource, alias, SqmJoinType.INNER, false, parent.nodeBuilder());
                index = ((SqmMapJoin)join).key();
            } else {
                throw new SemanticException("Index access is only supported on list or map attributes: " + this.getNavigablePath());
            }
            join.setJoinPredicate((SqmPredicate)creationState.getCreationContext().getNodeBuilder().equal(index, selector));
            parent.addSqmJoin(join);
            path = join;
            pathRegistry.register((SqmPath<?>)path);
        }
        SqmIndexedCollectionAccessPath result = new SqmIndexedCollectionAccessPath(navigablePath, (SqmPath<?>)path, selector);
        pathRegistry.register(result);
        return result;
    }

    public <S extends E> SqmTreatedSimplePath<E, S> treatAs(Class<S> treatJavaType) throws PathException {
        return (SqmTreatedSimplePath)this.treatAs((EntityDomainType)this.nodeBuilder().getDomainModel().entity(treatJavaType));
    }

    public <S extends E> SqmTreatedPath<E, S> treatAs(EntityDomainType<S> treatTarget) throws PathException {
        return this.getTreatedPath(treatTarget);
    }
}

