/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.function.BiConsumer;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.metamodel.mapping.AttributeMetadata;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.metamodel.mapping.SingularAttributeMapping;
import org.hibernate.metamodel.mapping.internal.AbstractSingularAttributeMapping;
import org.hibernate.metamodel.mapping.internal.SingleAttributeIdentifierMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResultGraphNode;
import org.hibernate.type.descriptor.java.JavaType;

public class BasicAttributeMapping
extends AbstractSingularAttributeMapping
implements SingularAttributeMapping,
BasicValuedModelPart {
    private final NavigableRole navigableRole;
    private final String tableExpression;
    private final String mappedColumnExpression;
    private final SelectablePath selectablePath;
    private final boolean isFormula;
    private final String customReadExpression;
    private final String customWriteExpression;
    private final String columnDefinition;
    private final Long length;
    private final Integer precision;
    private final Integer scale;
    private final JdbcMapping jdbcMapping;
    private final boolean nullable;
    private final boolean insertable;
    private final boolean updateable;
    private final boolean partitioned;
    private final JavaType domainTypeDescriptor;

    public BasicAttributeMapping(String attributeName, NavigableRole navigableRole, int stateArrayPosition, int fetchableIndex, AttributeMetadata attributeMetadata, FetchTiming mappedFetchTiming, FetchStyle mappedFetchStyle, String tableExpression, String mappedColumnExpression, SelectablePath selectablePath, boolean isFormula, String customReadExpression, String customWriteExpression, String columnDefinition, Long length, Integer precision, Integer scale, boolean nullable, boolean insertable, boolean updateable, boolean partitioned, JdbcMapping jdbcMapping, ManagedMappingType declaringType, PropertyAccess propertyAccess) {
        super(attributeName, stateArrayPosition, fetchableIndex, attributeMetadata, mappedFetchTiming, mappedFetchStyle, declaringType, propertyAccess);
        this.navigableRole = navigableRole;
        this.tableExpression = tableExpression;
        this.mappedColumnExpression = mappedColumnExpression;
        this.selectablePath = selectablePath == null ? new SelectablePath(mappedColumnExpression) : selectablePath;
        this.isFormula = isFormula;
        this.columnDefinition = columnDefinition;
        this.length = length;
        this.precision = precision;
        this.scale = scale;
        this.nullable = nullable;
        this.insertable = insertable;
        this.updateable = updateable;
        this.partitioned = partitioned;
        this.jdbcMapping = jdbcMapping;
        this.domainTypeDescriptor = jdbcMapping.getJavaTypeDescriptor();
        this.customReadExpression = customReadExpression;
        this.customWriteExpression = isFormula ? null : customWriteExpression;
    }

    public static BasicAttributeMapping withSelectableMapping(ManagedMappingType declaringType, BasicValuedModelPart original, PropertyAccess propertyAccess, boolean insertable, boolean updateable, SelectableMapping selectableMapping) {
        AttributeMetadata attributeMetadata;
        String attributeName = null;
        int stateArrayPosition = 0;
        if (original instanceof SingleAttributeIdentifierMapping) {
            SingleAttributeIdentifierMapping mapping = (SingleAttributeIdentifierMapping)((Object)original);
            attributeName = mapping.getAttributeName();
            attributeMetadata = null;
        } else if (original instanceof SingularAttributeMapping) {
            SingularAttributeMapping mapping = (SingularAttributeMapping)((Object)original);
            attributeName = mapping.getAttributeName();
            stateArrayPosition = mapping.getStateArrayPosition();
            attributeMetadata = mapping.getAttributeMetadata();
        } else {
            attributeMetadata = null;
        }
        return new BasicAttributeMapping(attributeName, original.getNavigableRole(), stateArrayPosition, original.getFetchableKey(), attributeMetadata, FetchTiming.IMMEDIATE, FetchStyle.JOIN, selectableMapping.getContainingTableExpression(), selectableMapping.getSelectionExpression(), selectableMapping.getSelectablePath(), selectableMapping.isFormula(), selectableMapping.getCustomReadExpression(), selectableMapping.getCustomWriteExpression(), selectableMapping.getColumnDefinition(), selectableMapping.getLength(), selectableMapping.getPrecision(), selectableMapping.getScale(), selectableMapping.isNullable(), insertable, updateable, selectableMapping.isPartitioned(), original.getJdbcMapping(), declaringType, propertyAccess);
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping;
    }

    @Override
    public MappingType getMappedType() {
        return this.getJdbcMapping();
    }

    @Override
    public JavaType<?> getJavaType() {
        return this.domainTypeDescriptor;
    }

    @Override
    public String getSelectionExpression() {
        return this.mappedColumnExpression;
    }

    @Override
    public String getSelectableName() {
        return this.selectablePath.getSelectableName();
    }

    @Override
    public SelectablePath getSelectablePath() {
        return this.selectablePath;
    }

    @Override
    public boolean isFormula() {
        return this.isFormula;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public boolean isInsertable() {
        return this.insertable;
    }

    @Override
    public boolean isUpdateable() {
        return this.updateable;
    }

    @Override
    public boolean isPartitioned() {
        return this.partitioned;
    }

    @Override
    public String getCustomReadExpression() {
        return this.customReadExpression;
    }

    @Override
    public String getCustomWriteExpression() {
        return this.customWriteExpression;
    }

    @Override
    public String getWriteExpression() {
        return this.customWriteExpression;
    }

    @Override
    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public Long getLength() {
        return this.length;
    }

    @Override
    public Integer getPrecision() {
        return this.precision;
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }

    @Override
    public String getContainingTableExpression() {
        return this.tableExpression;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    public String toString() {
        return "BasicAttributeMapping(" + this.navigableRole + ")@" + System.identityHashCode(this);
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        SqlSelection sqlSelection = this.resolveSqlSelection(navigablePath, tableGroup, true, null, creationState);
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.jdbcMapping, navigablePath);
    }

    private SqlSelection resolveSqlSelection(NavigablePath navigablePath, TableGroup tableGroup, boolean allowFkOptimization, FetchParent fetchParent, DomainResultCreationState creationState) {
        SqlExpressionResolver expressionResolver = creationState.getSqlAstCreationState().getSqlExpressionResolver();
        TableReference tableReference = tableGroup.resolveTableReference(navigablePath, this.getContainingTableExpression(), allowFkOptimization);
        return expressionResolver.resolveSqlSelection(expressionResolver.resolveSqlExpression(tableReference, this), this.jdbcMapping.getJdbcJavaType(), fetchParent, creationState.getSqlAstCreationState().getCreationContext().getSessionFactory().getTypeConfiguration());
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.resolveSqlSelection(navigablePath, tableGroup, true, null, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        selectionConsumer.accept(this.resolveSqlSelection(navigablePath, tableGroup, true, null, creationState), this.getJdbcMapping());
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        int valuesArrayPosition;
        EntityMappingType containingEntityMapping = this.findContainingEntityMapping();
        boolean coerceResultType = false;
        if (fetchTiming == FetchTiming.DELAYED && !(fetchParent instanceof EmbeddableResultGraphNode) && containingEntityMapping.getEntityPersister().getPropertyLaziness()[this.getStateArrayPosition()]) {
            valuesArrayPosition = -1;
        } else {
            SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
            TableGroup tableGroup = sqlAstCreationState.getFromClauseAccess().getTableGroup(fetchParent.getNavigablePath());
            assert (tableGroup != null);
            SqlSelection sqlSelection = this.resolveSqlSelection(fetchablePath, tableGroup, true, fetchParent, creationState);
            valuesArrayPosition = sqlSelection.getValuesArrayPosition();
            if (sqlSelection.getExpressionType() != null) {
                coerceResultType = sqlSelection.getExpressionType().getSingleJdbcMapping().getJdbcJavaType() != this.getJdbcMapping().getJdbcJavaType();
            }
        }
        return new BasicFetch(valuesArrayPosition, fetchParent, fetchablePath, (BasicValuedModelPart)this, fetchTiming, creationState, coerceResultType);
    }

    @Override
    public <X, Y> int forEachDisassembledJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, x, y, value, this.getJdbcMapping());
        return this.getJdbcTypeCount();
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(offset, this.jdbcMapping);
        return this.getJdbcTypeCount();
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        consumer.accept(offset, this);
        return this.getJdbcTypeCount();
    }

    @Override
    public <X, Y> int breakDownJdbcValues(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        valueConsumer.consume(offset, x, y, this.disassemble(domainValue, session), this);
        return this.getJdbcTypeCount();
    }
}

