/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb.logging;

import java.util.List;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;

@MessageLogger(projectCode="WFLYORB", length=4)
public interface JacORBLogger
extends BasicLogger {
    public static final JacORBLogger ROOT_LOGGER = (JacORBLogger)Logger.getMessageLogger(JacORBLogger.class, (String)"org.jboss.as.jacorb");

    @Message(id=38, value="Illegal initializer value: %s. Should be one of [security,transactions]")
    public XMLStreamException invalidInitializerConfig(String var1, @Param Location var2);

    @Message(id=39, value="Illegal SSL config option: %s. Should be one of [0.20,40,60]")
    public XMLStreamException invalidSSLConfig(String var1, @Param Location var2);

    @Message(id=132, value="Properties %s cannot be emulated using OpenJDK ORB and are not supported")
    public OperationFailedException cannotEmulateProperties(List<String> var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=133, value="JacORB is not used as an ORB implementation anymore. JacORB subsystem would be emulated using the current OpenJDK ORB implementation. Ability to emulate legacy JacORB configurations using OpenJDK ORB will be removed in future.")
    public void jacorbEmulationWarning();

    @Message(id=134, value="Properties %s cannot be emulated using OpenJDK ORB and are not supported")
    public String cannotEmulatePropertiesWarning(List<String> var1);

    @Message(id=135, value="Migration failed, see results for more details.")
    public String migrationFailed();

    @Message(id=136, value="The properties %s use expressions. Configuration properties that are used to resolve those expressions should be transformed manually to the new iiop-openjdk subsystem format")
    public String expressionMigrationWarning(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=137, value="After the migration the subsystem will use Elytron implementation of org.omg.PortableInterceptor.ClientRequestInterceptor. Please refer to org.wildfly.iiop.openjdk.csiv2.ElytronSASClientInterceptor documentation for the implementation details.")
    public void migratedToElytronSecurityWarning();
}

