/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client._private;

import java.io.IOException;
import java.io.InvalidClassException;
import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.Locale;
import java.util.ServiceConfigurationError;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.naming.CommunicationException;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InterruptedNamingException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.naming.client.ExhaustedDestinationsException;
import org.wildfly.naming.client.RenameAcrossNamingProvidersException;
import org.wildfly.naming.client._private.Messages;
import org.wildfly.security.auth.AuthenticationException;

public class Messages_$logger
extends DelegatingBasicLogger
implements Messages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Messages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final AtomicBoolean deprecatedProperties_$Once = new AtomicBoolean(false);

    public Messages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void serviceConfigFailed(ServiceConfigurationError error) {
        this.log.logf(FQCN, Logger.Level.TRACE, (Throwable)error, this.serviceConfigFailed$str(), new Object[0]);
    }

    protected String serviceConfigFailed$str() {
        return "Service configuration failure loading naming providers";
    }

    @Override
    public final void greeting(String version) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.greeting$str(), (Object)version);
    }

    protected String greeting$str() {
        return "WildFly Naming version %s";
    }

    protected String invalidProviderUri$str() {
        return "WFNAM00003: Invalid naming provider URI: %s";
    }

    @Override
    public final ConfigurationException invalidProviderUri(Exception cause, Object providerUri) {
        ConfigurationException result = new ConfigurationException(String.format(this.getLoggingLocale(), this.invalidProviderUri$str(), providerUri));
        result.initCause(cause);
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String nameNotFound$str() {
        return "WFNAM00004: Name \"%s\" is not found";
    }

    @Override
    public final NameNotFoundException nameNotFound(Name name1, Name name) {
        NameNotFoundException result = new NameNotFoundException(String.format(this.getLoggingLocale(), this.nameNotFound$str(), name1));
        Messages_$logger._copyStackTraceMinusOne(result);
        result.setResolvedName(name);
        return result;
    }

    protected String invalidEmptyName$str() {
        return "WFNAM00005: Invalid empty name";
    }

    @Override
    public final InvalidNameException invalidEmptyName() {
        InvalidNameException result = new InvalidNameException(String.format(this.getLoggingLocale(), this.invalidEmptyName$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String readOnlyContext$str() {
        return "WFNAM00006: Cannot modify read-only naming context";
    }

    @Override
    public final NoPermissionException readOnlyContext() {
        NoPermissionException result = new NoPermissionException(String.format(this.getLoggingLocale(), this.readOnlyContext$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidURLSchemeName$str() {
        return "WFNAM00007: Invalid URL scheme name \"%s\"";
    }

    @Override
    public final InvalidNameException invalidURLSchemeName(String name) {
        InvalidNameException result = new InvalidNameException(String.format(this.getLoggingLocale(), this.invalidURLSchemeName$str(), name));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nameIndexOutOfBounds$str() {
        return "WFNAM00009: Name index %d is out of bounds";
    }

    @Override
    public final IndexOutOfBoundsException nameIndexOutOfBounds(int pos) {
        IndexOutOfBoundsException result = new IndexOutOfBoundsException(String.format(this.getLoggingLocale(), this.nameIndexOutOfBounds$str(), pos));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidNullSegment$str() {
        return "WFNAM00010: Invalid null name segment at index %d";
    }

    @Override
    public final IllegalArgumentException invalidNullSegment(int index) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidNullSegment$str(), index));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingCloseQuote$str() {
        return "WFNAM00011: Missing close quote '%s' in name \"%s\"";
    }

    @Override
    public final InvalidNameException missingCloseQuote(char quote, String name) {
        InvalidNameException result = new InvalidNameException(String.format(this.getLoggingLocale(), this.missingCloseQuote$str(), Character.valueOf(quote), name));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingEscape$str() {
        return "WFNAM00012: Unterminated escape sequence in name \"%s\"";
    }

    @Override
    public final InvalidNameException missingEscape(String name) {
        InvalidNameException result = new InvalidNameException(String.format(this.getLoggingLocale(), this.missingEscape$str(), name));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String renameAcrossProviders$str() {
        return "WFNAM00014: Renaming from \"%s\" to \"%s\" across providers is not supported";
    }

    @Override
    public final RenameAcrossNamingProvidersException renameAcrossProviders(Name oldName, Name newName) {
        RenameAcrossNamingProvidersException result = new RenameAcrossNamingProvidersException(String.format(this.getLoggingLocale(), this.renameAcrossProviders$str(), oldName, newName));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notContextInCompositeName$str() {
        return "WFNAM00015: Composite name segment \"%s\" does not refer to a context";
    }

    @Override
    public final NotContextException notContextInCompositeName(String segment) {
        NotContextException result = new NotContextException(String.format(this.getLoggingLocale(), this.notContextInCompositeName$str(), segment));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void contextCloseFailed(Context context, Throwable cause) {
        this.log.logf(FQCN, Logger.Level.DEBUG, cause, this.contextCloseFailed$str(), (Object)context);
    }

    protected String contextCloseFailed$str() {
        return "WFNAM00016: Closing context \"%s\" failed";
    }

    protected String noRemotingEndpoint$str() {
        return "WFNAM00017: No JBoss Remoting endpoint has been configured";
    }

    @Override
    public final CommunicationException noRemotingEndpoint() {
        CommunicationException result = new CommunicationException(String.format(this.getLoggingLocale(), this.noRemotingEndpoint$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String connectFailed$str() {
        return "WFNAM00018: Failed to connect to remote host";
    }

    @Override
    public final CommunicationException connectFailed(Throwable cause) {
        CommunicationException result = new CommunicationException(String.format(this.getLoggingLocale(), this.connectFailed$str(), new Object[0]));
        result.initCause(cause);
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String operationInterrupted$str() {
        return "WFNAM00019: Naming operation interrupted";
    }

    @Override
    public final InterruptedNamingException operationInterrupted() {
        InterruptedNamingException result = new InterruptedNamingException(String.format(this.getLoggingLocale(), this.operationInterrupted$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String operationFailed$str() {
        return "WFNAM00020: Remote naming operation failed";
    }

    @Override
    public final CommunicationException operationFailed(Throwable cause) {
        CommunicationException result = new CommunicationException(String.format(this.getLoggingLocale(), this.operationFailed$str(), new Object[0]));
        result.initCause(cause);
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noCompatibleVersions$str() {
        return "WFNAM00022: The server provided no compatible protocol versions";
    }

    @Override
    public final CommunicationException noCompatibleVersions() {
        CommunicationException result = new CommunicationException(String.format(this.getLoggingLocale(), this.noCompatibleVersions$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidResponse$str() {
        return "WFNAM00023: Received an invalid response from the server";
    }

    @Override
    public final CommunicationException invalidResponse() {
        CommunicationException result = new CommunicationException(String.format(this.getLoggingLocale(), this.invalidResponse$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notSupported$str() {
        return "WFNAM00024: Naming operation not supported";
    }

    @Override
    public final OperationNotSupportedException notSupported() {
        OperationNotSupportedException result = new OperationNotSupportedException(String.format(this.getLoggingLocale(), this.notSupported$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void oldContextDeprecated() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.oldContextDeprecated$str(), new Object[0]);
    }

    protected String oldContextDeprecated$str() {
        return "WFNAM00025: org.jboss.naming.remote.client.InitialContextFactory is deprecated; new applications should use org.wildfly.naming.client.WildFlyInitialContextFactory instead";
    }

    protected String noProviderForUri$str() {
        return "WFNAM00026: No provider for found for URI: %s";
    }

    @Override
    public final OperationNotSupportedException noProviderForUri(String uri) {
        OperationNotSupportedException result = new OperationNotSupportedException(String.format(this.getLoggingLocale(), this.noProviderForUri$str(), uri));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidHeader$str() {
        return "WFNAM00029: Invalid leading bytes in header";
    }

    @Override
    public final CommunicationException invalidHeader() {
        CommunicationException result = new CommunicationException(String.format(this.getLoggingLocale(), this.invalidHeader$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String outcomeNotUnderstood$str() {
        return "WFNAM00031: Outcome not understood";
    }

    @Override
    public final IOException outcomeNotUnderstood() {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.outcomeNotUnderstood$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String authenticationFailed$str() {
        return "WFNAM00032: Peer authentication failed";
    }

    @Override
    public final javax.naming.AuthenticationException authenticationFailed(AuthenticationException cause) {
        javax.naming.AuthenticationException result = new javax.naming.AuthenticationException(String.format(this.getLoggingLocale(), this.authenticationFailed$str(), new Object[0]));
        result.initCause(cause);
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String connectionSharingUnsupported$str() {
        return "WFNAM00033: Connection sharing not supported";
    }

    @Override
    public final javax.naming.AuthenticationException connectionSharingUnsupported() {
        javax.naming.AuthenticationException result = new javax.naming.AuthenticationException(String.format(this.getLoggingLocale(), this.connectionSharingUnsupported$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void unexpectedParameterType(int expected, int actual) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.unexpectedParameterType$str(), (Object)expected, (Object)actual);
    }

    protected String unexpectedParameterType$str() {
        return "WFNAM00034: Unexpected parameter type - expected: %d  received: %d";
    }

    @Override
    public final void failedToSendExceptionResponse(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToSendExceptionResponse$str(), new Object[0]);
    }

    protected String failedToSendExceptionResponse$str() {
        return "WFNAM00035: Failed to send exception response to client";
    }

    @Override
    public final void unexpectedError(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.unexpectedError$str(), new Object[0]);
    }

    protected String unexpectedError$str() {
        return "WFNAM00036: Unexpected internal error";
    }

    @Override
    public final void nullCorrelationId(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.nullCorrelationId$str(), new Object[0]);
    }

    protected String nullCorrelationId$str() {
        return "WFNAM00037: null correlationId so error not sent to client";
    }

    protected String unrecognizedMessageId$str() {
        return "WFNAM00038: Unrecognized messageId";
    }

    @Override
    public final IOException unrecognizedMessageId() {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.unrecognizedMessageId$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void failedToSendHeader(IOException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToSendHeader$str(), new Object[0]);
    }

    protected String failedToSendHeader$str() {
        return "WFNAM00039: Unable to send header, closing channel";
    }

    protected String unsupportedProtocolVersion$str() {
        return "WFNAM00040: Unsupported protocol version [ %d ]";
    }

    @Override
    public final IllegalArgumentException unsupportedProtocolVersion(int version) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unsupportedProtocolVersion$str(), version));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void failedToDetermineClientVersion(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.failedToDetermineClientVersion$str(), new Object[0]);
    }

    protected String failedToDetermineClientVersion$str() {
        return "WFNAM00041: Error determining version selected by client";
    }

    protected String callbackHandlerAndUsernameAndPasswordSpecified$str() {
        return "WFNAM00042: Cannot specify both a callback handler and a username/password for connection";
    }

    @Override
    public final RuntimeException callbackHandlerAndUsernameAndPasswordSpecified() {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.callbackHandlerAndUsernameAndPasswordSpecified$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToLoadCallbackHandlerClass$str() {
        return "WFNAM00043: Unable to load callback handler class \"%s\"";
    }

    @Override
    public final RuntimeException failedToLoadCallbackHandlerClass(Exception cause, String callbackHandlerClass) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToLoadCallbackHandlerClass$str(), callbackHandlerClass), cause);
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToInstantiateCallbackHandlerInstance$str() {
        return "WFNAM00044: Unable to instantiate callback handler instance of type  \"%s\"";
    }

    @Override
    public final NamingException failedToInstantiateCallbackHandlerInstance(Exception cause, String callbackHandlerClass) {
        NamingException result = new NamingException(String.format(this.getLoggingLocale(), this.failedToInstantiateCallbackHandlerInstance$str(), callbackHandlerClass));
        result.initCause(cause);
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void deprecatedProperties() {
        if (this.log.isEnabled(Logger.Level.INFO) && deprecatedProperties_$Once.compareAndSet(false, true)) {
            this.log.logf(FQCN, Logger.Level.INFO, null, this.deprecatedProperties$str(), new Object[0]);
        }
    }

    protected String deprecatedProperties$str() {
        return "WFNAM00049: Usage of the legacy \"remote.connections\" property is deprecated; please use javax.naming.Context#PROVIDER_URL instead";
    }

    @Override
    public final void ignoringLegacyProperties() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.ignoringLegacyProperties$str(), new Object[0]);
    }

    protected String ignoringLegacyProperties$str() {
        return "WFNAM00051: Provider URLs already given via standard mechanism; ignoring legacy property-based connection configuration";
    }

    protected String invalidNumericProperty$str() {
        return "WFNAM00052: Invalid value given for property \"%s\": \"%s\" is not numeric";
    }

    @Override
    public final ConfigurationException invalidNumericProperty(Throwable e, String propertyName, String resultStr) {
        ConfigurationException result = new ConfigurationException(String.format(this.getLoggingLocale(), this.invalidNumericProperty$str(), propertyName, resultStr));
        result.initCause(e);
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidProviderGenerated$str() {
        return "WFNAM00053: Failed to synthesize a valid provider URL";
    }

    @Override
    public final ConfigurationException invalidProviderGenerated(Throwable e) {
        ConfigurationException result = new ConfigurationException(String.format(this.getLoggingLocale(), this.invalidProviderGenerated$str(), new Object[0]));
        result.initCause(e);
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void ignoringDuplicateDestination(URI uri) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.ignoringDuplicateDestination$str(), (Object)uri);
    }

    protected String ignoringDuplicateDestination$str() {
        return "WFNAM00054: Ignoring duplicate destination URI \"%s\"";
    }

    protected String noMoreDestinations2$str() {
        return "WFNAM00055: No more destinations are available to attempt the operation (%d blocklisted, %d transiently failed). See suppressed exceptions for details";
    }

    @Override
    public final ExhaustedDestinationsException noMoreDestinations(int blocklisted, int transientlyFailed) {
        ExhaustedDestinationsException result = new ExhaustedDestinationsException(String.format(this.getLoggingLocale(), this.noMoreDestinations2$str(), blocklisted, transientlyFailed));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noMoreDestinations0$str() {
        return "WFNAM00056: No more destinations are available to attempt the operation.";
    }

    @Override
    public final ExhaustedDestinationsException noMoreDestinations() {
        ExhaustedDestinationsException result = new ExhaustedDestinationsException(String.format(this.getLoggingLocale(), this.noMoreDestinations0$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void oldClientPropertyFileDeprecated() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.oldClientPropertyFileDeprecated$str(), new Object[0]);
    }

    protected String oldClientPropertyFileDeprecated$str() {
        return "WFNAM00057: jboss-naming-client.properties is deprecated; new applications should use org.wildfly.naming.client.WildFlyInitialContextFactory instead";
    }

    protected String cannotResolveFilteredClass$str() {
        return "WFNAM00058: Exception resolving class %s for unmarshalling; it has either been blocklisted or not allowlisted";
    }

    @Override
    public final InvalidClassException cannotResolveFilteredClass(String clazz) {
        InvalidClassException result = new InvalidClassException(String.format(this.getLoggingLocale(), this.cannotResolveFilteredClass$str(), clazz));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void javaeeToJakartaeeBackwardCompatibilityLayerInstalled() {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.javaeeToJakartaeeBackwardCompatibilityLayerInstalled$str(), new Object[0]);
    }

    protected String javaeeToJakartaeeBackwardCompatibilityLayerInstalled$str() {
        return "WFNAM00059: JavaEE to JakartaEE backward compatibility layer have been installed";
    }
}

