/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton;

import java.util.EnumSet;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.IdentityServiceConfigurator;
import org.wildfly.clustering.singleton.SingletonRequirement;
import org.wildfly.extension.clustering.singleton.AliasServiceBuilder;
import org.wildfly.extension.clustering.singleton.SingletonResourceDefinition;
import org.wildfly.extension.clustering.singleton.SingletonServiceNameFactory;

public class SingletonServiceHandler
implements ResourceServiceHandler {
    public void installServices(OperationContext context, ModelNode model) throws OperationFailedException {
        String defaultPolicy = SingletonResourceDefinition.Attribute.DEFAULT.resolveModelAttribute((ExpressionResolver)context, model).asString();
        ServiceTarget target = context.getServiceTarget();
        ServiceName serviceName = SingletonResourceDefinition.Capability.DEFAULT_POLICY.getServiceName(context.getCurrentAddress());
        ServiceName targetServiceName = SingletonServiceNameFactory.SINGLETON_POLICY.getServiceName(context, defaultPolicy);
        new IdentityServiceConfigurator(serviceName, targetServiceName).build(target).install();
        ServiceName legacyServiceName = SingletonResourceDefinition.Capability.DEFAULT_LEGACY_POLICY.getServiceName(context.getCurrentAddress());
        new AliasServiceBuilder(legacyServiceName, targetServiceName, SingletonRequirement.SINGLETON_POLICY.getType()).build(target).install();
    }

    public void removeServices(OperationContext context, ModelNode model) {
        PathAddress address = context.getCurrentAddress();
        for (SingletonResourceDefinition.Capability capability : EnumSet.allOf(SingletonResourceDefinition.Capability.class)) {
            context.removeService(capability.getServiceName(address));
        }
    }
}

