/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Set;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.jgroups.subsystem.SocketTransportResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.TransportConfigurationServiceConfigurator;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jgroups.protocols.BasicTCP;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;

public class SocketTransportConfigurationServiceConfigurator<TP extends BasicTCP>
extends TransportConfigurationServiceConfigurator<TP> {
    private volatile SupplierDependency<SocketBinding> clientBinding;

    public SocketTransportConfigurationServiceConfigurator(PathAddress address) {
        super(address);
    }

    @Override
    public <B> ServiceBuilder<B> register(ServiceBuilder<B> builder) {
        return super.register(this.clientBinding.register(builder));
    }

    @Override
    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        String bindingName = SocketTransportResourceDefinition.Attribute.CLIENT_SOCKET_BINDING.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        this.clientBinding = bindingName != null ? new ServiceSupplierDependency(CommonUnaryRequirement.SOCKET_BINDING.getServiceName(context, bindingName)) : new SimpleSupplierDependency(null);
        return super.configure(context, model);
    }

    @Override
    public Map<String, SocketBinding> getSocketBindings() {
        Map<String, SocketBinding> bindings = super.getSocketBindings();
        SocketBinding clientBinding = (SocketBinding)this.clientBinding.get();
        for (String serviceName : Set.of("jgroups.tcp.sock", "jgroups.nio.client")) {
            bindings.put(serviceName, clientBinding);
        }
        return bindings;
    }

    @Override
    public void accept(TP protocol) {
        SocketBinding clientBinding = (SocketBinding)this.clientBinding.get();
        if (clientBinding != null) {
            InetSocketAddress socketAddress = clientBinding.getSocketAddress();
            this.setValue(protocol, "client_bind_addr", socketAddress.getAddress());
            this.setValue(protocol, "client_bind_port", socketAddress.getPort());
        }
        super.accept(protocol);
    }
}

