/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc.extensions.mysql;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.jboss.jca.adapters.jdbc.extensions.mysql.SecurityActions;
import org.jboss.jca.adapters.jdbc.spi.ValidConnectionChecker;

public class MySQLValidConnectionChecker
implements ValidConnectionChecker,
Serializable {
    private static final long serialVersionUID = 1323747853035005642L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLException isValidConnection(Connection c) {
        Method ping = null;
        try {
            ping = SecurityActions.getMethod(c.getClass(), "ping", null);
            SecurityActions.setAccessible(ping);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (ping != null) {
            try {
                ping.invoke((Object)c, (Object[])null);
            }
            catch (Exception e) {
                if (e instanceof SQLException) {
                    return (SQLException)e;
                }
                return new SQLException("Ping failed: " + e.toString(), e);
            }
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = c.createStatement();
            rs = stmt.executeQuery("SELECT 1");
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                SQLException sQLException = (SQLException)e;
                return sQLException;
            }
            SQLException sQLException = new SQLException("SELECT 1 failed: " + e.toString(), e);
            return sQLException;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return null;
    }
}

