/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.cache.bean;

import java.io.IOException;
import java.time.Instant;
import org.infinispan.protostream.descriptors.WireType;
import org.jboss.ejb.client.SessionID;
import org.wildfly.clustering.ejb.cache.bean.SimpleBeanCreationMetaData;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class SimpleBeanCreationMetaDataMarshaller
implements ProtoStreamMarshaller<SimpleBeanCreationMetaData<SessionID>> {
    private static final int NAME_INDEX = 1;
    private static final int GROUP_IDENTIFIER_INDEX = 2;
    private static final int CREATION_TIME_INDEX = 3;
    private static final Instant DEFAULT_CREATION_TIME = Instant.EPOCH;

    public Class<? extends SimpleBeanCreationMetaData<SessionID>> getJavaClass() {
        return SimpleBeanCreationMetaData.class;
    }

    public SimpleBeanCreationMetaData<SessionID> readFrom(ProtoStreamReader reader) throws IOException {
        String name = null;
        SessionID groupId = null;
        Instant creationTime = Instant.EPOCH;
        block5: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    name = reader.readString();
                    continue block5;
                }
                case 2: {
                    groupId = (SessionID)reader.readObject(SessionID.class);
                    continue block5;
                }
                case 3: {
                    creationTime = (Instant)reader.readObject(Instant.class);
                    continue block5;
                }
            }
            reader.skipField(tag);
        }
        return new SimpleBeanCreationMetaData<Object>(name, groupId, creationTime);
    }

    public void writeTo(ProtoStreamWriter writer, SimpleBeanCreationMetaData<SessionID> metaData) throws IOException {
        Instant creationTime;
        SessionID groupId;
        String name = metaData.getName();
        if (name != null) {
            writer.writeString(1, name);
        }
        if ((groupId = metaData.getGroupId()) != null) {
            writer.writeObject(2, (Object)groupId);
        }
        if (!DEFAULT_CREATION_TIME.equals(creationTime = metaData.getCreationTime())) {
            writer.writeObject(3, (Object)creationTime);
        }
    }
}

