/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.code;

import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.code.CodeAttributesGetter;
import io.opentelemetry.instrumentation.api.internal.ClassNames;

public final class CodeSpanNameExtractor<REQUEST>
implements SpanNameExtractor<REQUEST> {
    private final CodeAttributesGetter<REQUEST> getter;

    public static <REQUEST> SpanNameExtractor<REQUEST> create(CodeAttributesGetter<REQUEST> getter) {
        return new CodeSpanNameExtractor<REQUEST>(getter);
    }

    private CodeSpanNameExtractor(CodeAttributesGetter<REQUEST> getter) {
        this.getter = getter;
    }

    public String extract(REQUEST request) {
        String methodName;
        Class<?> cls = this.getter.codeClass(request);
        String className = cls != null ? ClassNames.simpleName(cls) : "<unknown>";
        int lambdaIdx = className.indexOf("$$Lambda$");
        if (lambdaIdx > -1) {
            className = className.substring(0, lambdaIdx + "$$Lambda$".length());
        }
        if ((methodName = this.getter.methodName(request)) == null) {
            return className;
        }
        return className + "." + methodName;
    }
}

