/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.search.backend.elasticsearch.index.layout.impl.IndexNames;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

final class IndexNamesRegistry {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Map<String, IndexNames> indexNamesByName = new ConcurrentHashMap<String, IndexNames>();

    IndexNamesRegistry() {
    }

    void register(IndexNames newIndexNames) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        names.add(newIndexNames.write().original);
        names.add(newIndexNames.read().original);
        names.add(IndexNames.normalizeName(newIndexNames.hibernateSearchIndex()));
        for (String name : names) {
            IndexNames existingIndexNames = this.indexNamesByName.putIfAbsent(name, newIndexNames);
            if (existingIndexNames == null) continue;
            throw log.conflictingIndexNames(existingIndexNames.hibernateSearchIndex(), newIndexNames.hibernateSearchIndex(), name);
        }
    }
}

