/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.container;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.aesh.command.Command;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.container.CommandContainer;
import org.aesh.command.container.CommandContainerResult;
import org.aesh.command.impl.internal.ProcessedCommand;
import org.aesh.command.impl.parser.CommandLineParser;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.invocation.InvocationProviders;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.validator.CommandValidatorException;
import org.aesh.command.validator.OptionValidatorException;
import org.aesh.parser.ParsedLine;
import org.aesh.readline.AeshContext;

public abstract class DefaultCommandContainer<CI extends CommandInvocation>
implements CommandContainer<CI> {
    private final ConcurrentLinkedQueue<ParsedLine> lines = new ConcurrentLinkedQueue();

    @Override
    public void addLine(ParsedLine aeshLine) {
        this.lines.add(aeshLine);
    }

    @Override
    public ParsedLine pollLine() {
        return this.lines.poll();
    }

    @Override
    public void emptyLine() {
        this.lines.clear();
    }

    @Override
    public ProcessedCommand<Command<CI>, CI> parseAndPopulate(InvocationProviders invocationProviders, AeshContext aeshContext) throws CommandLineParserException, OptionValidatorException {
        if (this.lines.isEmpty()) {
            return null;
        }
        ParsedLine aeshLine = this.lines.poll();
        this.getParser().parse(aeshLine.iterator(), CommandLineParser.Mode.STRICT);
        if (this.getParser().getProcessedCommand().parserExceptions().size() > 0) {
            throw this.getParser().getProcessedCommand().parserExceptions().get(0);
        }
        this.getParser().parsedCommand().getCommandPopulator().populateObject(this.getParser().parsedCommand().getProcessedCommand(), invocationProviders, aeshContext, CommandLineParser.Mode.VALIDATE);
        return this.getParser().parsedCommand().getProcessedCommand();
    }

    @Override
    public CommandContainerResult executeCommand(ParsedLine line, InvocationProviders invocationProviders, AeshContext aeshContext, CI commandInvocation) throws CommandLineParserException, OptionValidatorException, CommandValidatorException, CommandException, InterruptedException {
        this.getParser().parse(line.iterator(), CommandLineParser.Mode.STRICT);
        return this.executeCommand(invocationProviders, aeshContext, commandInvocation);
    }

    private CommandContainerResult executeCommand(InvocationProviders invocationProviders, AeshContext aeshContext, CI commandInvocation) throws CommandLineParserException, OptionValidatorException, CommandValidatorException, CommandException, InterruptedException {
        this.getParser().parsedCommand().getCommandPopulator().populateObject(this.getParser().parsedCommand().getProcessedCommand(), invocationProviders, aeshContext, CommandLineParser.Mode.VALIDATE);
        if (this.getParser().parsedCommand().getProcessedCommand().validator() != null && !this.getParser().parsedCommand().getProcessedCommand().hasOptionWithOverrideRequired()) {
            this.getParser().parsedCommand().getProcessedCommand().validator().validate(this.getParser().parsedCommand().getCommand());
        }
        CommandResult result = this.getParser().parsedCommand().getCommand().execute(commandInvocation);
        return new CommandContainerResult(this.getParser().parsedCommand().getProcessedCommand().resultHandler(), result);
    }

    @Override
    public String printHelp(String childCommandName) {
        if (this.getParser().isGroupCommand() && childCommandName.contains(" ")) {
            String[] names = childCommandName.split(" ");
            if (names.length > 1 && names[1].length() > 0) {
                CommandLineParser current = this.getParser();
                for (int i = 1; i < names.length; ++i) {
                    CommandLineParser child = current.getChildParser(names[i]);
                    if (child == null) continue;
                    if (child.isGroupCommand()) {
                        current = child;
                        continue;
                    }
                    return child.printHelp();
                }
            }
            return "Child command " + names[1] + " not found.";
        }
        return this.getParser().printHelp();
    }
}

