/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.Map;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.metadata.api.ds.DsSecurity;
import org.jboss.as.connector.subsystems.datasources.AbstractXMLDataSourceRuntimeHandler;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DsPool;
import org.jboss.modules.ModuleClassLoader;

public class XMLDataSourceRuntimeHandler
extends AbstractXMLDataSourceRuntimeHandler<DataSource> {
    public static final XMLDataSourceRuntimeHandler INSTANCE = new XMLDataSourceRuntimeHandler();

    @Override
    protected void executeReadAttribute(String attributeName, OperationContext context, DataSource dataSource, PathAddress address) {
        String target = address.getLastElement().getKey();
        if (target.equals("connection-properties")) {
            this.handlePropertyAttribute(attributeName, context, dataSource, address.getLastElement().getValue());
        } else if (target.equals("data-source")) {
            this.handleDatasourceAttribute(attributeName, context, dataSource);
        }
    }

    private void handlePropertyAttribute(String attributeName, OperationContext context, DataSource dataSource, String propName) {
        if (!attributeName.equals("value")) {
            throw ConnectorLogger.ROOT_LOGGER.unknownAttribute(attributeName);
        }
        this.setStringIfNotNull(context, (String)dataSource.getConnectionProperties().get(propName));
    }

    private void handleDatasourceAttribute(String attributeName, OperationContext context, DataSource dataSource) {
        if (attributeName.equals(Constants.CONNECTION_URL.getName())) {
            this.setStringIfNotNull(context, dataSource.getConnectionUrl());
        } else if (attributeName.equals(Constants.CONNECTION_PROPERTIES.getName())) {
            Map propertiesMap = dataSource.getConnectionProperties();
            if (propertiesMap == null) {
                return;
            }
            for (Map.Entry entry : propertiesMap.entrySet()) {
                context.getResult().asPropertyList().add(new ModelNode().set((String)entry.getKey(), (String)entry.getValue()).asProperty());
            }
        } else if (attributeName.equals(Constants.DRIVER_CLASS.getName())) {
            this.setStringIfNotNull(context, dataSource.getDriverClass());
        } else if (attributeName.equals(Constants.DATASOURCE_CLASS.getName())) {
            this.setStringIfNotNull(context, dataSource.getDataSourceClass());
        } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.jndi.Constants.JNDI_NAME.getName())) {
            this.setStringIfNotNull(context, dataSource.getJndiName());
        } else if (attributeName.equals(Constants.DATASOURCE_DRIVER.getName())) {
            this.setStringIfNotNull(context, dataSource.getDriver());
        } else if (attributeName.equals(Constants.NEW_CONNECTION_SQL.getName())) {
            this.setStringIfNotNull(context, dataSource.getNewConnectionSql());
        } else if (attributeName.equals(Constants.URL_DELIMITER.getName())) {
            this.setStringIfNotNull(context, dataSource.getUrlDelimiter());
        } else if (attributeName.equals(Constants.URL_SELECTOR_STRATEGY_CLASS_NAME.getName())) {
            this.setStringIfNotNull(context, dataSource.getUrlSelectorStrategyClassName());
        } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.jndi.Constants.USE_JAVA_CONTEXT.getName())) {
            this.setBooleanIfNotNull(context, dataSource.isUseJavaContext());
        } else if (attributeName.equals(Constants.JTA.getName())) {
            this.setBooleanIfNotNull(context, dataSource.isJTA());
        } else if (attributeName.equals(Constants.ENABLED.getName())) {
            this.setBooleanIfNotNull(context, dataSource.isEnabled());
        } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.pool.Constants.MAX_POOL_SIZE.getName())) {
            if (dataSource.getPool() == null) {
                return;
            }
            this.setIntIfNotNull(context, dataSource.getPool().getMaxPoolSize());
        } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.pool.Constants.INITIAL_POOL_SIZE.getName())) {
            if (dataSource.getPool() == null) {
                return;
            }
            this.setIntIfNotNull(context, dataSource.getPool().getInitialPoolSize());
        } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.pool.Constants.MIN_POOL_SIZE.getName())) {
            if (dataSource.getPool() == null) {
                return;
            }
            this.setIntIfNotNull(context, dataSource.getPool().getMinPoolSize());
        } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.pool.Constants.POOL_PREFILL.getName())) {
            if (dataSource.getPool() == null) {
                return;
            }
            this.setBooleanIfNotNull(context, dataSource.getPool().isPrefill());
        } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FAIR.getName())) {
            if (dataSource.getPool() == null) {
                return;
            }
            this.setBooleanIfNotNull(context, dataSource.getPool().isFair());
        } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.pool.Constants.POOL_USE_STRICT_MIN.getName())) {
            if (dataSource.getPool() == null) {
                return;
            }
            this.setBooleanIfNotNull(context, dataSource.getPool().isUseStrictMin());
        } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_CLASS.getName())) {
            if (dataSource.getPool() == null || dataSource.getPool().getCapacity() == null || dataSource.getPool().getCapacity().getIncrementer() == null) {
                return;
            }
            this.setStringIfNotNull(context, dataSource.getPool().getCapacity().getIncrementer().getClassName());
        } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_CLASS.getName())) {
            if (dataSource.getPool() == null || dataSource.getPool().getCapacity() == null || dataSource.getPool().getCapacity().getDecrementer() == null) {
                return;
            }
            this.setStringIfNotNull(context, dataSource.getPool().getCapacity().getDecrementer().getClassName());
        } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_PROPERTIES.getName())) {
            DsPool pool = dataSource.getPool();
            if (pool == null || pool.getCapacity() == null || pool.getCapacity().getIncrementer() == null) {
                return;
            }
            Map propertiesMap = pool.getCapacity().getIncrementer().getConfigPropertiesMap();
            if (propertiesMap == null) {
                return;
            }
            for (Map.Entry entry : propertiesMap.entrySet()) {
                context.getResult().asPropertyList().add(new ModelNode().set((String)entry.getKey(), (String)entry.getValue()).asProperty());
            }
        } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_PROPERTIES.getName())) {
            DsPool pool = dataSource.getPool();
            if (pool == null || pool.getCapacity() == null || pool.getCapacity().getDecrementer() == null) {
                return;
            }
            Map propertiesMap = pool.getCapacity().getDecrementer().getConfigPropertiesMap();
            if (propertiesMap == null) {
                return;
            }
            for (Map.Entry entry : propertiesMap.entrySet()) {
                context.getResult().asPropertyList().add(new ModelNode().set((String)entry.getKey(), (String)entry.getValue()).asProperty());
            }
        } else if (attributeName.equals(Constants.USERNAME.getName())) {
            if (dataSource.getSecurity() == null) {
                return;
            }
            this.setStringIfNotNull(context, dataSource.getSecurity().getUserName());
        } else if (!attributeName.equals(Constants.PASSWORD.getName()) && !attributeName.equals(Constants.CREDENTIAL_REFERENCE.getName())) {
            if (attributeName.equals(Constants.SECURITY_DOMAIN.getName())) {
                if (dataSource.getSecurity() == null) {
                    return;
                }
                assert (dataSource.getSecurity() instanceof DsSecurity);
                if (((DsSecurity)dataSource.getSecurity()).isElytronEnabled()) {
                    return;
                }
                this.setStringIfNotNull(context, dataSource.getSecurity().getSecurityDomain());
            } else if (attributeName.equals(Constants.ELYTRON_ENABLED.getName())) {
                if (dataSource.getSecurity() == null) {
                    return;
                }
                assert (dataSource.getSecurity() instanceof DsSecurity);
                if (!((DsSecurity)dataSource.getSecurity()).isElytronEnabled()) {
                    return;
                }
                this.setBooleanIfNotNull(context, ((DsSecurity)dataSource.getSecurity()).isElytronEnabled());
            } else if (attributeName.equals(Constants.AUTHENTICATION_CONTEXT.getName())) {
                if (dataSource.getSecurity() == null) {
                    return;
                }
                assert (dataSource.getSecurity() instanceof DsSecurity);
                if (!((DsSecurity)dataSource.getSecurity()).isElytronEnabled()) {
                    return;
                }
                this.setStringIfNotNull(context, dataSource.getSecurity().getSecurityDomain());
            } else if (attributeName.equals(Constants.REAUTH_PLUGIN_CLASSNAME.getName())) {
                if (dataSource.getSecurity() == null) {
                    return;
                }
                if (dataSource.getSecurity().getReauthPlugin() == null) {
                    return;
                }
                this.setStringIfNotNull(context, dataSource.getSecurity().getReauthPlugin().getClassName());
            } else if (attributeName.equals(Constants.REAUTHPLUGIN_PROPERTIES.getName())) {
                if (dataSource.getSecurity() == null) {
                    return;
                }
                if (dataSource.getSecurity().getReauthPlugin() == null) {
                    return;
                }
                Map propertiesMap = dataSource.getSecurity().getReauthPlugin().getConfigPropertiesMap();
                if (propertiesMap == null) {
                    return;
                }
                for (Map.Entry entry : propertiesMap.entrySet()) {
                    context.getResult().asPropertyList().add(new ModelNode().set((String)entry.getKey(), (String)entry.getValue()).asProperty());
                }
            } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FLUSH_STRATEGY.getName())) {
                if (dataSource.getPool() == null) {
                    return;
                }
                this.setStringIfNotNull(context, dataSource.getPool().getFlushStrategy().getName());
            } else if (attributeName.equals(Constants.PREPARED_STATEMENTS_CACHE_SIZE.getName())) {
                if (dataSource.getStatement() == null) {
                    return;
                }
                this.setLongIfNotNull(context, dataSource.getStatement().getPreparedStatementsCacheSize());
            } else if (attributeName.equals(Constants.SHARE_PREPARED_STATEMENTS.getName())) {
                if (dataSource.getStatement() == null) {
                    return;
                }
                this.setBooleanIfNotNull(context, dataSource.getStatement().isSharePreparedStatements());
            } else if (attributeName.equals(Constants.TRACK_STATEMENTS.getName())) {
                if (dataSource.getStatement() == null) {
                    return;
                }
                if (dataSource.getStatement().getTrackStatements() == null) {
                    return;
                }
                this.setStringIfNotNull(context, dataSource.getStatement().getTrackStatements().name());
            } else if (attributeName.equals(Constants.ALLOCATION_RETRY.getName())) {
                if (dataSource.getTimeOut() == null) {
                    return;
                }
                this.setIntIfNotNull(context, dataSource.getTimeOut().getAllocationRetry());
            } else if (attributeName.equals(Constants.ALLOCATION_RETRY_WAIT_MILLIS.getName())) {
                if (dataSource.getTimeOut() == null) {
                    return;
                }
                this.setLongIfNotNull(context, dataSource.getTimeOut().getAllocationRetryWaitMillis());
            } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.pool.Constants.BLOCKING_TIMEOUT_WAIT_MILLIS.getName())) {
                if (dataSource.getTimeOut() == null) {
                    return;
                }
                this.setLongIfNotNull(context, dataSource.getTimeOut().getBlockingTimeoutMillis());
            } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.pool.Constants.IDLETIMEOUTMINUTES.getName())) {
                if (dataSource.getTimeOut() == null) {
                    return;
                }
                this.setLongIfNotNull(context, dataSource.getTimeOut().getIdleTimeoutMinutes());
            } else if (attributeName.equals(Constants.QUERY_TIMEOUT.getName())) {
                if (dataSource.getTimeOut() == null) {
                    return;
                }
                this.setLongIfNotNull(context, dataSource.getTimeOut().getQueryTimeout());
            } else if (attributeName.equals(Constants.USE_TRY_LOCK.getName())) {
                if (dataSource.getTimeOut() == null) {
                    return;
                }
                this.setLongIfNotNull(context, dataSource.getTimeOut().getUseTryLock());
            } else if (attributeName.equals(Constants.SET_TX_QUERY_TIMEOUT.getName())) {
                if (dataSource.getTimeOut() == null) {
                    return;
                }
                this.setBooleanIfNotNull(context, dataSource.getTimeOut().isSetTxQueryTimeout());
            } else if (attributeName.equals(Constants.TRANSACTION_ISOLATION.getName())) {
                if (dataSource.getTransactionIsolation() == null) {
                    return;
                }
                this.setStringIfNotNull(context, dataSource.getTransactionIsolation().name());
            } else if (attributeName.equals(Constants.CHECK_VALID_CONNECTION_SQL.getName())) {
                if (dataSource.getValidation() == null) {
                    return;
                }
                this.setStringIfNotNull(context, dataSource.getValidation().getCheckValidConnectionSql());
            } else if (attributeName.equals(Constants.EXCEPTION_SORTER_CLASSNAME.getName())) {
                if (dataSource.getValidation() == null) {
                    return;
                }
                if (dataSource.getValidation().getExceptionSorter() == null) {
                    return;
                }
                this.setStringIfNotNull(context, dataSource.getValidation().getExceptionSorter().getClassName());
            } else if (attributeName.equals(Constants.EXCEPTION_SORTER_MODULE.getName())) {
                if (dataSource.getValidation() == null) {
                    return;
                }
                if (dataSource.getValidation().getExceptionSorter() == null) {
                    return;
                }
                ClassLoader exceptionSorterClassLoader = dataSource.getValidation().getExceptionSorter().getClassLoader();
                if (exceptionSorterClassLoader instanceof ModuleClassLoader) {
                    this.setStringIfNotNull(context, ((ModuleClassLoader)exceptionSorterClassLoader).getModule().toString());
                }
            } else if (attributeName.equals(Constants.EXCEPTION_SORTER_PROPERTIES.getName())) {
                if (dataSource.getValidation() == null) {
                    return;
                }
                if (dataSource.getValidation().getExceptionSorter() == null) {
                    return;
                }
                Map propertiesMap = dataSource.getValidation().getExceptionSorter().getConfigPropertiesMap();
                if (propertiesMap == null) {
                    return;
                }
                for (Map.Entry entry : propertiesMap.entrySet()) {
                    context.getResult().asPropertyList().add(new ModelNode().set((String)entry.getKey(), (String)entry.getValue()).asProperty());
                }
            } else if (attributeName.equals(Constants.STALE_CONNECTION_CHECKER_CLASSNAME.getName())) {
                if (dataSource.getValidation() == null) {
                    return;
                }
                if (dataSource.getValidation().getStaleConnectionChecker() == null) {
                    return;
                }
                this.setStringIfNotNull(context, dataSource.getValidation().getStaleConnectionChecker().getClassName());
            } else if (attributeName.equals(Constants.STALE_CONNECTION_CHECKER_MODULE.getName())) {
                if (dataSource.getValidation() == null) {
                    return;
                }
                if (dataSource.getValidation().getStaleConnectionChecker() == null) {
                    return;
                }
                ClassLoader staleConnectionCheckerClassLoader = dataSource.getValidation().getStaleConnectionChecker().getClassLoader();
                if (staleConnectionCheckerClassLoader instanceof ModuleClassLoader) {
                    this.setStringIfNotNull(context, ((ModuleClassLoader)staleConnectionCheckerClassLoader).getModule().toString());
                }
            } else if (attributeName.equals(Constants.STALE_CONNECTION_CHECKER_PROPERTIES.getName())) {
                if (dataSource.getValidation() == null) {
                    return;
                }
                if (dataSource.getValidation().getStaleConnectionChecker() == null) {
                    return;
                }
                Map propertiesMap = dataSource.getValidation().getStaleConnectionChecker().getConfigPropertiesMap();
                if (propertiesMap == null) {
                    return;
                }
                for (Map.Entry entry : propertiesMap.entrySet()) {
                    context.getResult().asPropertyList().add(new ModelNode().set((String)entry.getKey(), (String)entry.getValue()).asProperty());
                }
            } else if (attributeName.equals(Constants.VALID_CONNECTION_CHECKER_CLASSNAME.getName())) {
                if (dataSource.getValidation() == null) {
                    return;
                }
                if (dataSource.getValidation().getValidConnectionChecker() == null) {
                    return;
                }
                this.setStringIfNotNull(context, dataSource.getValidation().getValidConnectionChecker().getClassName());
            } else if (attributeName.equals(Constants.VALID_CONNECTION_CHECKER_MODULE.getName())) {
                if (dataSource.getValidation() == null) {
                    return;
                }
                if (dataSource.getValidation().getValidConnectionChecker() == null) {
                    return;
                }
                ClassLoader validConnectionCheckerClassLoader = dataSource.getValidation().getValidConnectionChecker().getClassLoader();
                if (validConnectionCheckerClassLoader instanceof ModuleClassLoader) {
                    this.setStringIfNotNull(context, ((ModuleClassLoader)validConnectionCheckerClassLoader).getModule().toString());
                }
            } else if (attributeName.equals(Constants.VALID_CONNECTION_CHECKER_PROPERTIES.getName())) {
                if (dataSource.getValidation() == null) {
                    return;
                }
                if (dataSource.getValidation().getValidConnectionChecker() == null) {
                    return;
                }
                Map propertiesMap = dataSource.getValidation().getValidConnectionChecker().getConfigPropertiesMap();
                if (propertiesMap == null) {
                    return;
                }
                for (Map.Entry entry : propertiesMap.entrySet()) {
                    context.getResult().asPropertyList().add(new ModelNode().set((String)entry.getKey(), (String)entry.getValue()).asProperty());
                }
            } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATIONMILLIS.getName())) {
                if (dataSource.getValidation() == null) {
                    return;
                }
                this.setLongIfNotNull(context, dataSource.getValidation().getBackgroundValidationMillis());
            } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATION.getName())) {
                if (dataSource.getValidation() == null) {
                    return;
                }
                this.setBooleanIfNotNull(context, dataSource.getValidation().isBackgroundValidation());
            } else if (attributeName.equals(org.jboss.as.connector.subsystems.common.pool.Constants.USE_FAST_FAIL.getName())) {
                if (dataSource.getValidation() == null) {
                    return;
                }
                this.setBooleanIfNotNull(context, dataSource.getValidation().isUseFastFail());
            } else if (attributeName.equals(Constants.VALIDATE_ON_MATCH.getName())) {
                if (dataSource.getValidation() == null) {
                    return;
                }
                this.setBooleanIfNotNull(context, dataSource.getValidation().isValidateOnMatch());
            } else if (attributeName.equals(Constants.SPY.getName())) {
                this.setBooleanIfNotNull(context, dataSource.isSpy());
            } else if (attributeName.equals(Constants.USE_CCM.getName())) {
                this.setBooleanIfNotNull(context, dataSource.isUseCcm());
            } else if (attributeName.equals(Constants.ALLOW_MULTIPLE_USERS.getName())) {
                DsPool pool = dataSource.getPool();
                if (!(pool instanceof DsPool)) {
                    return;
                }
                this.setBooleanIfNotNull(context, pool.isAllowMultipleUsers());
            } else if (attributeName.equals(Constants.CONNECTION_LISTENER_CLASS.getName())) {
                DsPool pool = dataSource.getPool();
                if (!(pool instanceof DsPool) || pool.getConnectionListener() == null) {
                    return;
                }
                this.setStringIfNotNull(context, pool.getConnectionListener().getClassName());
            } else if (attributeName.equals(Constants.CONNECTION_LISTENER_PROPERTIES.getName())) {
                DsPool pool = dataSource.getPool();
                if (!(pool instanceof DsPool) || pool.getConnectionListener() == null) {
                    return;
                }
                Map propertiesMap = pool.getConnectionListener().getConfigPropertiesMap();
                if (propertiesMap == null) {
                    return;
                }
                for (Map.Entry entry : propertiesMap.entrySet()) {
                    context.getResult().asPropertyList().add(new ModelNode().set((String)entry.getKey(), (String)entry.getValue()).asProperty());
                }
            } else if (attributeName.equals(Constants.CONNECTABLE.getName())) {
                context.getResult().set(false);
            } else if (attributeName.equals(Constants.STATISTICS_ENABLED.getName())) {
                context.getResult().set(false);
            } else {
                if (attributeName.equals(Constants.TRACKING.getName())) {
                    return;
                }
                if (attributeName.equals(Constants.MCP.getName())) {
                    return;
                }
                if (attributeName.equals(Constants.ENLISTMENT_TRACE.getName())) {
                    return;
                }
                throw ConnectorLogger.ROOT_LOGGER.unknownAttribute(attributeName);
            }
        }
    }
}

