/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.security;

import java.security.AccessController;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.security.ElytronCallbackHandler;
import org.jboss.as.connector.security.ElytronSecurityContext;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.jca.core.spi.security.Callback;
import org.jboss.jca.core.spi.security.SecurityContext;
import org.jboss.jca.core.spi.security.SecurityIntegration;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceName;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ElytronSecurityIntegration
implements SecurityIntegration {
    static final String SECURITY_IDENTITY_ROLE = "ejb";
    private static final String SECURITY_DOMAIN_CAPABILITY = "org.wildfly.security.security-domain";
    private static final RuntimeCapability<Void> SECURITY_DOMAIN_RUNTIME_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.security.security-domain", (boolean)true, SecurityDomain.class).build();
    private final ThreadLocal<SecurityContext> securityContext = new ThreadLocal();

    public SecurityContext createSecurityContext(String sd) throws Exception {
        return new ElytronSecurityContext();
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext.get();
    }

    public void setSecurityContext(SecurityContext context) {
        this.securityContext.set(context);
    }

    public CallbackHandler createCallbackHandler() {
        throw ConnectorLogger.ROOT_LOGGER.unsupportedCreateCallbackHandlerMethod();
    }

    public CallbackHandler createCallbackHandler(Callback callback) {
        assert (callback != null);
        String securityDomainName = callback.getDomain();
        if (securityDomainName != null) {
            ServiceContainer container = this.currentServiceContainer();
            ServiceName securityDomainServiceName = SECURITY_DOMAIN_RUNTIME_CAPABILITY.getCapabilityServiceName(new String[]{securityDomainName});
            SecurityDomain securityDomain = (SecurityDomain)container.getRequiredService(securityDomainServiceName).getValue();
            return new ElytronCallbackHandler(securityDomain, callback);
        }
        throw ConnectorLogger.ROOT_LOGGER.invalidCallbackSecurityDomain();
    }

    private ServiceContainer currentServiceContainer() {
        if (WildFlySecurityManager.isChecking()) {
            return (ServiceContainer)AccessController.doPrivileged(CurrentServiceContainer.GET_ACTION);
        }
        return CurrentServiceContainer.getServiceContainer();
    }
}

