/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.extensions.highlight.encoder;

import java.awt.Color;
import java.io.OutputStream;
import java.util.Map;
import org.aesh.extensions.highlight.Encoder;
import org.aesh.extensions.highlight.Theme;
import org.aesh.extensions.highlight.TokenType;

public class TerminalEncoder
extends Encoder.AbstractEncoder
implements Encoder {
    public TerminalEncoder(OutputStream out, Theme theme, Map<String, Object> options) {
        super(out, theme, options);
        this.write("\u001b[0m");
    }

    @Override
    public void textToken(String text, TokenType type) {
        Color color = this.color(type);
        if (color != null) {
            this.write(TerminalString.of(color, text));
        } else {
            this.write(text);
        }
    }

    @Override
    public void beginGroup(TokenType type) {
    }

    @Override
    public void endGroup(TokenType type) {
    }

    @Override
    public void beginLine(TokenType type) {
    }

    @Override
    public void endLine(TokenType type) {
    }

    public static class TerminalString {
        public static final String START_COLOR = "\u001b[38;5;";
        public static final String END = "m";
        public static final String RESET = "\u001b[0m";

        public static String of(Color color, String text) {
            StringBuilder sb = new StringBuilder();
            sb.append(START_COLOR).append(TerminalString.from(color)).append(END);
            sb.append(text);
            sb.append(RESET);
            return sb.toString();
        }

        public static String from(Color color) {
            return String.valueOf(TerminalString.rgbToAnsi(color.getRed(), color.getGreen(), color.getBlue()));
        }

        private static int rgbToAnsi(int red, int green, int blue) {
            return 16 + TerminalString.getAnsiScale(red) * 36 + TerminalString.getAnsiScale(green) * 6 + TerminalString.getAnsiScale(blue);
        }

        public static int getAnsiScale(int color) {
            return Math.round(color / 51);
        }
    }
}

