/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.facet.impl;

import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.procedures.IntProcedure;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.range.LongRange;
import org.apache.lucene.facet.range.Range;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.LongMultiValues;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.LongMultiValuesSource;
import org.hibernate.search.backend.lucene.lowlevel.facet.impl.LongMultiValueRangeCounter;
import org.hibernate.search.backend.lucene.lowlevel.facet.impl.MultiValueRangeFacetCounts;

public class LongMultiValueRangeFacetCounts
extends MultiValueRangeFacetCounts {
    public LongMultiValueRangeFacetCounts(String field, LongMultiValuesSource valueSource, FacetsCollector hits, LongRange ... ranges) throws IOException {
        this(field, valueSource, hits, (Query)null, ranges);
    }

    public LongMultiValueRangeFacetCounts(String field, LongMultiValuesSource valueSource, FacetsCollector hits, Query fastMatchQuery, LongRange ... ranges) throws IOException {
        super(field, (Range[])ranges, fastMatchQuery);
        this.count(valueSource, hits.getMatchingDocs());
    }

    private void count(LongMultiValuesSource valueSource, List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        LongRange[] longRanges = (LongRange[])this.ranges;
        IntHashSet uniqueLeafIndicesForDocument = new IntHashSet();
        LongMultiValueRangeCounter counter = new LongMultiValueRangeCounter(longRanges);
        IntProcedure incrementCountForLeafWithIndex = counter::incrementCountForLeafWithIndex;
        int missingCount = 0;
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            DocIdSetIterator fastMatchDocs;
            LongMultiValues fv = valueSource.getValues(hits.context);
            this.totCount += hits.totalHits;
            if (this.fastMatchQuery != null) {
                IndexReaderContext topLevelContext = ReaderUtil.getTopLevelContext((IndexReaderContext)hits.context);
                IndexSearcher searcher = new IndexSearcher(topLevelContext);
                searcher.setQueryCache(null);
                Weight fastMatchWeight = searcher.createWeight(searcher.rewrite(this.fastMatchQuery), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
                Scorer s = fastMatchWeight.scorer(hits.context);
                if (s == null) continue;
                fastMatchDocs = s.iterator();
            } else {
                fastMatchDocs = null;
            }
            DocIdSetIterator docs = hits.bits.iterator();
            int doc = docs.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                if (fastMatchDocs != null) {
                    int fastMatchDoc = fastMatchDocs.docID();
                    if (fastMatchDoc < doc) {
                        fastMatchDoc = fastMatchDocs.advance(doc);
                    }
                    if (doc != fastMatchDoc) {
                        doc = docs.advance(fastMatchDoc);
                        continue;
                    }
                }
                if (fv.advanceExact(doc)) {
                    while (fv.hasNextValue()) {
                        int leafIndex = counter.findLeafIndex(fv.nextValue());
                        uniqueLeafIndicesForDocument.add(leafIndex);
                    }
                    uniqueLeafIndicesForDocument.forEach(incrementCountForLeafWithIndex);
                    uniqueLeafIndicesForDocument.clear();
                } else {
                    ++missingCount;
                }
                doc = docs.nextDoc();
            }
        }
        int x = counter.fillCounts(this.counts);
        this.totCount -= (missingCount += x);
    }
}

