/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.appclient.deployment;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.appclient.deployment.AppClientAttachments;
import org.jboss.as.appclient.deployment.AppClientJBossAllParser;
import org.jboss.as.appclient.logging.AppClientLogger;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.metadata.MetadataCompleteMarker;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.ee.structure.JBossDescriptorPropertyReplacement;
import org.jboss.as.ee.structure.SpecDescriptorPropertyReplacement;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.metadata.appclient.jboss.JBossClientMetaData;
import org.jboss.metadata.appclient.parser.jboss.JBossClientMetaDataParser;
import org.jboss.metadata.appclient.parser.spec.ApplicationClientMetaDataParser;
import org.jboss.metadata.appclient.spec.AppClientEnvironmentRefsGroupMetaData;
import org.jboss.metadata.appclient.spec.ApplicationClientMetaData;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;
import org.jboss.metadata.parser.util.NoopXMLResolver;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.vfs.VirtualFile;

public class ApplicationClientParsingDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final String APP_XML = "META-INF/application-client.xml";
    private static final String JBOSS_CLIENT_XML = "META-INF/jboss-client.xml";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        JBossClientMetaData merged;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.APPLICATION_CLIENT, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        ApplicationClientMetaData appClientMD = this.parseAppClient(deploymentUnit, SpecDescriptorPropertyReplacement.propertyReplacer((DeploymentUnit)deploymentUnit));
        JBossClientMetaData jbossClientMD = this.parseJBossClient(deploymentUnit, JBossDescriptorPropertyReplacement.propertyReplacer((DeploymentUnit)deploymentUnit));
        if (appClientMD == null && jbossClientMD == null) {
            return;
        }
        if (appClientMD == null) {
            merged = jbossClientMD;
        } else {
            merged = new JBossClientMetaData();
            merged.setEnvironmentRefsGroupMetaData(new AppClientEnvironmentRefsGroupMetaData());
            merged.merge(jbossClientMD, appClientMD);
        }
        if (merged.isMetadataComplete()) {
            MetadataCompleteMarker.setMetadataComplete((DeploymentUnit)deploymentUnit, (boolean)true);
        }
        deploymentUnit.putAttachment(AppClientAttachments.APPLICATION_CLIENT_META_DATA, (Object)merged);
        DeploymentDescriptorEnvironment environment = new DeploymentDescriptorEnvironment("java:module/env/", (RemoteEnvironment)merged.getEnvironmentRefsGroupMetaData());
        deploymentUnit.putAttachment(Attachments.MODULE_DEPLOYMENT_DESCRIPTOR_ENVIRONMENT, (Object)environment);
        if (merged.getModuleName() != null && !merged.getModuleName().isEmpty()) {
            EEModuleDescription description = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
            description.setModuleName(merged.getModuleName());
        }
    }

    private ApplicationClientMetaData parseAppClient(DeploymentUnit deploymentUnit, PropertyReplacer propertyReplacer) throws DeploymentUnitProcessingException {
        ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_ROOT);
        VirtualFile alternateDescriptor = (VirtualFile)deploymentRoot.getAttachment(org.jboss.as.ee.structure.Attachments.ALTERNATE_CLIENT_DEPLOYMENT_DESCRIPTOR);
        VirtualFile descriptor = alternateDescriptor != null ? alternateDescriptor : deploymentRoot.getRoot().getChild(APP_XML);
        if (descriptor.exists()) {
            InputStream is = null;
            try {
                ApplicationClientMetaData data;
                is = descriptor.openStream();
                ApplicationClientMetaData applicationClientMetaData = data = new ApplicationClientMetaDataParser().parse(this.getXMLStreamReader(is), propertyReplacer);
                return applicationClientMetaData;
            }
            catch (XMLStreamException e) {
                throw AppClientLogger.ROOT_LOGGER.failedToParseXml(e, descriptor, e.getLocation().getLineNumber(), e.getLocation().getColumnNumber());
            }
            catch (IOException e) {
                throw new DeploymentUnitProcessingException("Failed to parse " + descriptor, (Throwable)e);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private JBossClientMetaData parseJBossClient(DeploymentUnit deploymentUnit, PropertyReplacer propertyReplacer) throws DeploymentUnitProcessingException {
        VirtualFile deploymentRoot = ((ResourceRoot)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_ROOT)).getRoot();
        VirtualFile appXml = deploymentRoot.getChild(JBOSS_CLIENT_XML);
        if (appXml.exists()) {
            InputStream is = null;
            try {
                JBossClientMetaData data;
                is = appXml.openStream();
                JBossClientMetaData jBossClientMetaData = data = new JBossClientMetaDataParser().parse(this.getXMLStreamReader(is), propertyReplacer);
                return jBossClientMetaData;
            }
            catch (XMLStreamException e) {
                throw AppClientLogger.ROOT_LOGGER.failedToParseXml(e, appXml, e.getLocation().getLineNumber(), e.getLocation().getColumnNumber());
            }
            catch (IOException e) {
                throw AppClientLogger.ROOT_LOGGER.failedToParseXml(e, appXml);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return (JBossClientMetaData)deploymentUnit.getAttachment(AppClientJBossAllParser.ATTACHMENT_KEY);
    }

    private XMLStreamReader getXMLStreamReader(InputStream is) throws XMLStreamException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        inputFactory.setXMLResolver(NoopXMLResolver.create());
        XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(is);
        return xmlReader;
    }
}

