/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.function.UnaryOperator;
import org.infinispan.Cache;
import org.jboss.as.clustering.controller.FunctionExecutorRegistry;
import org.jboss.as.clustering.controller.ManagementResourceRegistration;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.infinispan.subsystem.BackupsResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheServiceHandler;
import org.jboss.as.clustering.infinispan.subsystem.PartitionHandlingResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StateTransferResourceDefinition;
import org.jboss.as.controller.PathElement;

public class SharedStateCacheResourceDefinition
extends ClusteredCacheResourceDefinition {
    private final FunctionExecutorRegistry<Cache<?, ?>> executors;

    SharedStateCacheResourceDefinition(PathElement path, UnaryOperator<ResourceDescriptor> configurator, ClusteredCacheServiceHandler handler, FunctionExecutorRegistry<Cache<?, ?>> executors) {
        super(path, (UnaryOperator<ResourceDescriptor>)new ResourceDescriptorConfigurator(configurator), handler, executors);
        this.executors = executors;
    }

    @Override
    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = super.register(parent);
        new PartitionHandlingResourceDefinition().register(registration);
        new StateTransferResourceDefinition().register(registration);
        new BackupsResourceDefinition(this.executors).register(registration);
        return registration;
    }

    private static class ResourceDescriptorConfigurator
    implements UnaryOperator<ResourceDescriptor> {
        private final UnaryOperator<ResourceDescriptor> configurator;

        ResourceDescriptorConfigurator(UnaryOperator<ResourceDescriptor> configurator) {
            this.configurator = configurator;
        }

        @Override
        public ResourceDescriptor apply(ResourceDescriptor descriptor) {
            return ((ResourceDescriptor)this.configurator.apply(descriptor)).addRequiredChildren(new PathElement[]{PartitionHandlingResourceDefinition.PATH, StateTransferResourceDefinition.PATH, BackupsResourceDefinition.PATH});
        }
    }
}

