/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ListValidator;
import org.jboss.as.controller.operations.validation.NillableOrExpressionParameterValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.common.Assert;

public abstract class ListAttributeDefinition
extends AttributeDefinition {
    private final ParameterValidator elementValidator;

    protected ListAttributeDefinition(Builder<?, ?> builder) {
        super(builder);
        this.elementValidator = builder.getElementValidator();
    }

    public ParameterValidator getElementValidator() {
        return this.elementValidator;
    }

    public AttributeDefinition getValueAttributeDefinition() {
        return null;
    }

    @Deprecated
    public ModelNode parse(String value, XMLStreamReader reader) throws XMLStreamException {
        try {
            return SimpleAttributeDefinition.parse(this, this.elementValidator, value);
        }
        catch (OperationFailedException e) {
            throw new XMLStreamException(e.getFailureDescription().toString(), reader.getLocation());
        }
    }

    @Deprecated
    public void parseAndAddParameterElement(String value, ModelNode operation, XMLStreamReader reader) throws XMLStreamException {
        ModelNode paramVal = this.parse(value, reader);
        operation.get(this.getName()).add(paramVal);
    }

    @Override
    public ModelNode addResourceAttributeDescription(ResourceBundle bundle, String prefix, ModelNode resourceDescription) {
        ModelNode result = super.addResourceAttributeDescription(bundle, prefix, resourceDescription);
        this.addValueTypeDescription(result, bundle);
        return result;
    }

    @Override
    public ModelNode addResourceAttributeDescription(ModelNode resourceDescription, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        ModelNode result = super.addResourceAttributeDescription(resourceDescription, resolver, locale, bundle);
        this.addAttributeValueTypeDescription(result, resolver, locale, bundle);
        return result;
    }

    @Override
    public ModelNode addOperationParameterDescription(ModelNode resourceDescription, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        ModelNode result = super.addOperationParameterDescription(resourceDescription, operationName, resolver, locale, bundle);
        this.addOperationParameterValueTypeDescription(result, operationName, resolver, locale, bundle);
        return result;
    }

    @Override
    public ModelNode addOperationParameterDescription(ResourceBundle bundle, String prefix, ModelNode operationDescription) {
        ModelNode result = super.addOperationParameterDescription(bundle, prefix, operationDescription);
        this.addValueTypeDescription(result, bundle);
        return result;
    }

    @Override
    public ModelNode addOperationReplyDescription(ModelNode resourceDescription, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        ModelNode result = super.addOperationReplyDescription(resourceDescription, operationName, resolver, locale, bundle);
        this.addOperationReplyValueTypeDescription(result, operationName, resolver, locale, bundle);
        return result;
    }

    protected abstract void addValueTypeDescription(ModelNode var1, ResourceBundle var2);

    protected abstract void addAttributeValueTypeDescription(ModelNode var1, ResourceDescriptionResolver var2, Locale var3, ResourceBundle var4);

    protected abstract void addOperationParameterValueTypeDescription(ModelNode var1, String var2, ResourceDescriptionResolver var3, Locale var4, ResourceBundle var5);

    protected void addOperationReplyValueTypeDescription(ModelNode node, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        this.addOperationParameterValueTypeDescription(node, operationName, resolver, locale, bundle);
    }

    @Override
    public void marshallAsElement(ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
        this.getMarshaller().marshallAsElement(this, resourceModel, marshallDefault, writer);
    }

    @Override
    protected ModelNode convertParameterExpressions(ModelNode parameter) {
        List asList;
        ModelNode result = parameter;
        try {
            asList = parameter.asList();
        }
        catch (IllegalArgumentException iae) {
            asList = null;
        }
        if (asList != null) {
            boolean changeMade = false;
            ModelNode newList = new ModelNode().setEmptyList();
            for (ModelNode item : asList) {
                ModelNode converted = this.convertParameterElementExpressions(item);
                newList.add(converted);
                changeMade |= !converted.equals(item);
            }
            if (changeMade) {
                result = newList;
            }
        }
        return result;
    }

    protected ModelNode convertParameterElementExpressions(ModelNode parameterElement) {
        return this.isAllowExpression() ? ListAttributeDefinition.convertStringExpression(parameterElement) : parameterElement;
    }

    @Deprecated
    public void parseAndSetParameter(String value, ModelNode operation, XMLStreamReader reader) throws XMLStreamException {
        if (value != null) {
            for (String element : value.split(",")) {
                this.parseAndAddParameterElement(element.trim(), operation, reader);
            }
        }
    }

    public static abstract class Builder<BUILDER extends Builder, ATTRIBUTE extends ListAttributeDefinition>
    extends AbstractAttributeDefinitionBuilder<BUILDER, ATTRIBUTE> {
        private ParameterValidator elementValidator;
        private Boolean allowNullElement;
        private boolean allowDuplicates = true;

        protected Builder(String attributeName) {
            super(attributeName, ModelType.LIST);
            this.setAttributeParser(AttributeParser.STRING_LIST);
        }

        protected Builder(String attributeName, boolean optional) {
            super(attributeName, ModelType.LIST, optional);
            this.setAttributeParser(AttributeParser.STRING_LIST);
        }

        public Builder(ListAttributeDefinition basis) {
            super(basis);
            this.elementValidator = basis.getElementValidator();
        }

        public ParameterValidator getElementValidator() {
            if (this.elementValidator == null) {
                return null;
            }
            ParameterValidator toWrap = this.elementValidator;
            NillableOrExpressionParameterValidator wrappedElementValidator = null;
            if (this.elementValidator instanceof NillableOrExpressionParameterValidator) {
                NillableOrExpressionParameterValidator wrapped = (NillableOrExpressionParameterValidator)this.elementValidator;
                Boolean allow = wrapped.getAllowNull();
                if ((allow == null || allow != false) == this.getAllowNullElement() && wrapped.isAllowExpression() == this.isAllowExpression()) {
                    wrappedElementValidator = wrapped;
                } else {
                    toWrap = wrapped.getDelegate();
                }
            }
            if (wrappedElementValidator == null) {
                this.elementValidator = new NillableOrExpressionParameterValidator(toWrap, this.getAllowNullElement(), this.isAllowExpression());
            }
            return this.elementValidator;
        }

        public final BUILDER setElementValidator(ParameterValidator elementValidator) {
            Assert.checkNotNullParam((String)"elementValidator", (Object)elementValidator);
            this.elementValidator = elementValidator;
            super.setValidator(null);
            return (BUILDER)this;
        }

        @Override
        public BUILDER setValidator(ParameterValidator validator) {
            return this.setElementValidator(validator);
        }

        public BUILDER setListValidator(ParameterValidator validator) {
            return (BUILDER)((Builder)super.setValidator(validator));
        }

        @Override
        public int getMinSize() {
            int min = super.getMinSize();
            if (min < 0) {
                min = 0;
                this.setMinSize(min);
            }
            return min;
        }

        @Override
        public int getMaxSize() {
            int max = super.getMaxSize();
            if (max < 1) {
                max = Integer.MAX_VALUE;
                this.setMaxSize(max);
            }
            return max;
        }

        public boolean getAllowNullElement() {
            return this.allowNullElement == null ? this.isNillable() : this.allowNullElement.booleanValue();
        }

        public BUILDER setAllowNullElement(boolean allowNullElement) {
            this.allowNullElement = allowNullElement;
            return (BUILDER)this;
        }

        public BUILDER setAllowDuplicates(boolean allowDuplicates) {
            this.allowDuplicates = allowDuplicates;
            return (BUILDER)this;
        }

        @Override
        public ParameterValidator getValidator() {
            ParameterValidator result = super.getValidator();
            if (result == null) {
                ParameterValidator listElementValidator = this.getElementValidator();
                assert (listElementValidator != null);
                result = new ListValidator(this.getElementValidator(), this.isNillable(), this.getMinSize(), this.getMaxSize(), this.allowDuplicates);
            }
            return result;
        }
    }
}

